/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.index.indexer.document.LastModifiedRange;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentTraverser;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;

public class NodeStateEntryTraverser
implements Iterable<NodeStateEntry>,
Closeable {
    private final Closer closer = Closer.create();
    private final RevisionVector rootRevision;
    private final DocumentNodeStore documentNodeStore;
    private final MongoDocumentStore documentStore;
    private final LastModifiedRange lastModifiedRange;
    private Consumer<String> progressReporter = id -> {};
    private Predicate<String> pathPredicate = path -> true;
    private final String id;

    public NodeStateEntryTraverser(String id, DocumentNodeStore documentNodeStore, MongoDocumentStore documentStore) {
        this(id, documentNodeStore.getHeadRevision(), documentNodeStore, documentStore, new LastModifiedRange(0L, Long.MAX_VALUE));
    }

    public NodeStateEntryTraverser(String id2, RevisionVector rootRevision, DocumentNodeStore documentNodeStore, MongoDocumentStore documentStore, LastModifiedRange lastModifiedRange) {
        this.id = id2;
        this.rootRevision = rootRevision;
        this.documentNodeStore = documentNodeStore;
        this.documentStore = documentStore;
        this.lastModifiedRange = lastModifiedRange;
    }

    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Iterator<NodeStateEntry> iterator() {
        return this.getIncludedDocs().iterator();
    }

    public NodeStateEntryTraverser withProgressCallback(Consumer<String> progressReporter) {
        this.progressReporter = progressReporter;
        return this;
    }

    public NodeStateEntryTraverser withPathPredicate(Predicate<String> pathPredicate) {
        this.pathPredicate = pathPredicate;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private Iterable<NodeStateEntry> getIncludedDocs() {
        return FluentIterable.from(this.getDocsFilteredByPath()).filter(doc -> this.includeDoc((NodeDocument)doc)).transformAndConcat(doc -> this.getEntries((NodeDocument)doc));
    }

    private boolean includeDoc(NodeDocument doc) {
        String path = doc.getPath().toString();
        return !doc.isSplitDocument() && !NodeStateUtils.isHiddenPath((String)path) && this.pathPredicate.test(path);
    }

    public LastModifiedRange getDocumentModificationRange() {
        return this.lastModifiedRange;
    }

    private Iterable<NodeStateEntry> getEntries(NodeDocument doc) {
        Path path = doc.getPath();
        DocumentNodeState nodeState = this.documentNodeStore.getNode(path, this.rootRevision);
        if (nodeState == null || !nodeState.exists()) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)Iterables.concat(Collections.singleton(nodeState), (Iterable)nodeState.getAllBundledNodesStates()), dns -> {
            NodeStateEntry.NodeStateEntryBuilder builder = new NodeStateEntry.NodeStateEntryBuilder((NodeState)dns, dns.getPath().toString());
            if (doc.getModified() != null) {
                builder.withLastModified(doc.getModified());
            }
            return builder.build();
        });
    }

    private Iterable<NodeDocument> getDocsFilteredByPath() {
        CloseableIterable<NodeDocument> docs = this.findAllDocuments();
        this.closer.register(docs);
        return docs;
    }

    private CloseableIterable<NodeDocument> findAllDocuments() {
        return new MongoDocumentTraverser(this.documentStore).getAllDocuments(Collection.NODES, this.lastModifiedRange, this::includeId);
    }

    private boolean includeId(String id) {
        this.progressReporter.accept(id);
        if (Utils.isIdFromLongPath((String)id)) {
            return true;
        }
        if (Utils.isPreviousDocId((String)id)) {
            return true;
        }
        String path = Utils.getPathFromId((String)id);
        if (NodeStateUtils.isHiddenPath((String)path)) {
            return false;
        }
        return this.pathPredicate.test(path);
    }
}

