/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.index.IndexerSupport;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeException;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeIndexer;
import org.apache.jackrabbit.oak.index.indexer.document.LastModifiedRange;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverser;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverserFactory;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateIndexer;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateIndexerProvider;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.DefaultMemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileNodeStoreBuilder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStore;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.DocumentStoreSplitter;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.plugins.index.progress.IndexingProgressReporter;
import org.apache.jackrabbit.oak.plugins.index.progress.MetricRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.TraversalRateEstimator;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentStoreIndexerBase
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Logger traversalLog = LoggerFactory.getLogger((String)(DocumentStoreIndexerBase.class.getName() + ".traversal"));
    protected final Closer closer = Closer.create();
    protected final IndexHelper indexHelper;
    protected List<NodeStateIndexerProvider> indexerProviders;
    protected final IndexerSupport indexerSupport;
    private final Set<String> indexerPaths = new HashSet<String>();
    private static final int MAX_DOWNLOAD_ATTEMPTS = Integer.parseInt(System.getProperty("oak.indexer.maxDownloadRetries", "5")) + 1;

    public DocumentStoreIndexerBase(IndexHelper indexHelper, IndexerSupport indexerSupport) {
        this.indexHelper = indexHelper;
        this.indexerSupport = indexerSupport;
    }

    protected void setProviders() throws IOException {
        this.indexerProviders = this.createProviders();
    }

    private FlatFileStore buildFlatFileStore(NodeState checkpointedState, CompositeIndexer indexer) throws IOException {
        Stopwatch flatFileStoreWatch = Stopwatch.createStarted();
        CompositeException lastException = null;
        ArrayList<File> previousDownloadDirs = new ArrayList<File>();
        FlatFileStore flatFileStore = null;
        DocumentNodeState rootDocumentState = (DocumentNodeState)checkpointedState;
        DocumentNodeStore nodeStore = (DocumentNodeStore)this.indexHelper.getNodeStore();
        DocumentStoreSplitter splitter = new DocumentStoreSplitter(this.getMongoDocumentStore());
        List<Long> lastModifiedBreakPoints = splitter.split(Collection.NODES, 0L, 10);
        FlatFileNodeStoreBuilder builder = null;
        int backOffTimeInMillis = 5000;
        DefaultMemoryManager memoryManager = new DefaultMemoryManager();
        for (int executionCount = 1; flatFileStore == null && executionCount <= MAX_DOWNLOAD_ATTEMPTS; ++executionCount) {
            try {
                builder = new FlatFileNodeStoreBuilder(this.indexHelper.getWorkDir(), memoryManager).withLastModifiedBreakPoints(lastModifiedBreakPoints).withBlobStore((BlobStore)this.indexHelper.getGCBlobStore()).withPreferredPathElements(indexer.getRelativeIndexedNodeNames()).addExistingDataDumpDir(this.indexerSupport.getExistingDataDumpDir()).withNodeStateEntryTraverserFactory(new MongoNodeStateEntryTraverserFactory(rootDocumentState.getRootRevision(), nodeStore, this.getMongoDocumentStore(), this.traversalLog, indexer));
                for (File dir : previousDownloadDirs) {
                    builder.addExistingDataDumpDir(dir);
                }
                flatFileStore = builder.build();
                this.closer.register((Closeable)flatFileStore);
                continue;
            }
            catch (CompositeException e) {
                e.logAllExceptions("Underlying throwable caught during download", this.log);
                this.log.info("Could not build flat file store. Execution count {}. Retries left {}. Time elapsed {}", new Object[]{executionCount, MAX_DOWNLOAD_ATTEMPTS - executionCount, flatFileStoreWatch});
                lastException = e;
                previousDownloadDirs.add(builder.getFlatFileStoreDir());
                if (executionCount >= MAX_DOWNLOAD_ATTEMPTS) continue;
                try {
                    this.log.info("Waiting for {} millis before retrying", (Object)backOffTimeInMillis);
                    Thread.sleep(backOffTimeInMillis);
                    backOffTimeInMillis *= 2;
                    continue;
                }
                catch (InterruptedException ie) {
                    this.log.error("Interrupted while waiting before retrying download ", (Throwable)ie);
                }
            }
        }
        if (flatFileStore == null) {
            throw new IOException("Could not build flat file store", lastException);
        }
        this.log.info("Completed the flat file store build in {}", (Object)flatFileStoreWatch);
        return flatFileStore;
    }

    public void reindex() throws CommitFailedException, IOException {
        IndexingProgressReporter progressReporter = new IndexingProgressReporter(IndexUpdateCallback.NOOP, NodeTraversalCallback.NOOP);
        this.configureEstimators(progressReporter);
        NodeState checkpointedState = this.indexerSupport.retrieveNodeStateForCheckpoint();
        MemoryNodeStore copyOnWriteStore = new MemoryNodeStore(checkpointedState);
        this.indexerSupport.switchIndexLanesAndReindexFlag((NodeStore)copyOnWriteStore);
        NodeBuilder builder = copyOnWriteStore.getRoot().builder();
        CompositeIndexer indexer = this.prepareIndexers((NodeStore)copyOnWriteStore, builder, progressReporter);
        if (indexer.isEmpty()) {
            return;
        }
        this.closer.register((Closeable)indexer);
        FlatFileStore flatFileStore = this.buildFlatFileStore(checkpointedState, indexer);
        progressReporter.reset();
        if (flatFileStore.getEntryCount() > 0L) {
            FlatFileStore finalFlatFileStore = flatFileStore;
            progressReporter.setNodeCountEstimator((basePath, indexPaths) -> finalFlatFileStore.getEntryCount());
        }
        progressReporter.reindexingTraversalStart("/");
        this.preIndexOpertaions(indexer.getIndexers());
        Stopwatch indexerWatch = Stopwatch.createStarted();
        for (NodeStateEntry entry : flatFileStore) {
            this.reportDocumentRead(entry.getPath(), progressReporter);
            indexer.index(entry);
        }
        progressReporter.reindexingTraversalEnd();
        progressReporter.logReport();
        this.log.info("Completed the indexing in {}", (Object)indexerWatch);
        copyOnWriteStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.indexerSupport.postIndexWork((NodeStore)copyOnWriteStore);
    }

    private MongoDocumentStore getMongoDocumentStore() {
        return (MongoDocumentStore)Preconditions.checkNotNull((Object)this.indexHelper.getService(MongoDocumentStore.class));
    }

    private void configureEstimators(IndexingProgressReporter progressReporter) {
        long nodesCount;
        StatisticsProvider statsProvider = this.indexHelper.getStatisticsProvider();
        if (statsProvider instanceof MetricStatisticsProvider) {
            MetricRegistry registry = ((MetricStatisticsProvider)statsProvider).getRegistry();
            progressReporter.setTraversalRateEstimator((TraversalRateEstimator)new MetricRateEstimator("async", registry));
        }
        if ((nodesCount = this.getEstimatedDocumentCount()) > 0L) {
            progressReporter.setNodeCountEstimator((basePath, indexPaths) -> nodesCount);
            progressReporter.setEstimatedCount(nodesCount);
            this.log.info("Estimated number of documents in Mongo are {}", (Object)nodesCount);
        }
    }

    private long getEstimatedDocumentCount() {
        MongoConnection mongoConnection = this.indexHelper.getService(MongoConnection.class);
        if (mongoConnection != null) {
            return mongoConnection.getDatabase().getCollection("nodes").count();
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private void reportDocumentRead(String id, IndexingProgressReporter progressReporter) {
        try {
            progressReporter.traversedNode(() -> id);
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
        this.traversalLog.trace(id);
    }

    protected CompositeIndexer prepareIndexers(NodeStore copyOnWriteStore, NodeBuilder builder, IndexingProgressReporter progressReporter) {
        NodeState root = copyOnWriteStore.getRoot();
        ArrayList<NodeStateIndexer> indexers = new ArrayList<NodeStateIndexer>();
        for (String indexPath : this.indexHelper.getIndexPaths()) {
            NodeState indexState = NodeStateUtils.getNode((NodeState)root, (String)indexPath);
            NodeBuilder idxBuilder = IndexerSupport.childBuilder(builder, indexPath, false);
            String type = indexState.getString("type");
            if (type == null) {
                this.log.warn("No 'type' property found on indexPath [{}]. Skipping it", (Object)indexPath);
                continue;
            }
            this.removeIndexState(idxBuilder);
            idxBuilder.setProperty("reindex", (Object)false);
            for (NodeStateIndexerProvider indexerProvider : this.indexerProviders) {
                NodeStateIndexer indexer = indexerProvider.getIndexer(type, indexPath, idxBuilder, root, progressReporter);
                if (indexer == null) continue;
                indexers.add(indexer);
                this.closer.register((Closeable)indexer);
                progressReporter.registerIndex(indexPath, true, -1L);
                this.indexerPaths.add(indexPath);
            }
        }
        return new CompositeIndexer(indexers);
    }

    protected abstract List<NodeStateIndexerProvider> createProviders() throws IOException;

    protected abstract void preIndexOpertaions(List<NodeStateIndexer> var1);

    private void removeIndexState(NodeBuilder definition) {
        for (String rm : definition.getChildNodeNames()) {
            NodeBuilder childNode;
            if (!NodeStateUtils.isHidden((String)rm) || (childNode = definition.getChildNode(rm)).getBoolean("retainNodeInReindex")) continue;
            definition.getChildNode(rm).remove();
        }
    }

    private static class MongoNodeStateEntryTraverserFactory
    implements NodeStateEntryTraverserFactory {
        private static final AtomicInteger traverserInstanceCounter = new AtomicInteger(0);
        private static final String TRAVERSER_ID_PREFIX = "NSET";
        private final RevisionVector rootRevision;
        private final DocumentNodeStore documentNodeStore;
        private final MongoDocumentStore documentStore;
        private final Logger traversalLogger;
        private final CompositeIndexer indexer;

        private MongoNodeStateEntryTraverserFactory(RevisionVector rootRevision, DocumentNodeStore documentNodeStore, MongoDocumentStore documentStore, Logger traversalLogger, CompositeIndexer indexer) {
            this.rootRevision = rootRevision;
            this.documentNodeStore = documentNodeStore;
            this.documentStore = documentStore;
            this.traversalLogger = traversalLogger;
            this.indexer = indexer;
        }

        @Override
        public NodeStateEntryTraverser create(LastModifiedRange lastModifiedRange) {
            IndexingProgressReporter progressReporterPerTask = new IndexingProgressReporter(IndexUpdateCallback.NOOP, NodeTraversalCallback.NOOP);
            String entryTraverserID = TRAVERSER_ID_PREFIX + traverserInstanceCounter.incrementAndGet();
            progressReporterPerTask.setMessagePrefix("Dumping from " + entryTraverserID);
            return new NodeStateEntryTraverser(entryTraverserID, this.rootRevision, this.documentNodeStore, this.documentStore, lastModifiedRange).withProgressCallback(id -> {
                try {
                    progressReporterPerTask.traversedNode(() -> id);
                }
                catch (CommitFailedException e) {
                    throw new RuntimeException(e);
                }
                this.traversalLogger.trace(id);
            }).withPathPredicate(this.indexer::shouldInclude);
        }
    }
}

