/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateIndexer;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;

public class CompositeIndexer
implements NodeStateIndexer {
    private final List<NodeStateIndexer> indexers;

    public CompositeIndexer(List<NodeStateIndexer> indexers) {
        this.indexers = (List)Preconditions.checkNotNull(indexers);
    }

    public boolean isEmpty() {
        return this.indexers.isEmpty();
    }

    @Override
    public boolean shouldInclude(String path) {
        return this.indexers.stream().anyMatch(indexer -> indexer.shouldInclude(path));
    }

    @Override
    public boolean shouldInclude(NodeDocument doc) {
        return this.indexers.stream().anyMatch(indexer -> indexer.shouldInclude(doc));
    }

    @Override
    public boolean index(NodeStateEntry entry) throws IOException, CommitFailedException {
        boolean result = false;
        for (NodeStateIndexer indexer : this.indexers) {
            result |= indexer.index(entry);
        }
        return result;
    }

    @Override
    public boolean indexesRelativeNodes() {
        for (NodeStateIndexer indexer : this.indexers) {
            if (!indexer.indexesRelativeNodes()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getRelativeIndexedNodeNames() {
        HashSet<String> result = new HashSet<String>();
        for (NodeStateIndexer indexer : this.indexers) {
            result.addAll(indexer.getRelativeIndexedNodeNames());
        }
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    public List<NodeStateIndexer> getIndexers() {
        return this.indexers;
    }
}

