/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.index.IndexerSupport;
import org.apache.jackrabbit.oak.plugins.index.CorruptIndexHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.plugins.index.progress.MetricRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.NodeCountEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.NodeCounterMBeanEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.TraversalRateEstimator;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

public abstract class OutOfBandIndexerBase
implements Closeable,
IndexUpdateCallback,
NodeTraversalCallback {
    protected final Closer closer = Closer.create();
    private final IndexHelper indexHelper;
    private NodeStore copyOnWriteStore;
    private IndexerSupport indexerSupport;
    private static final String REINDEX_LANE = "offline-reindex-async";
    public static final String LOCAL_INDEX_ROOT_DIR = "indexes";

    public OutOfBandIndexerBase(IndexHelper indexHelper, IndexerSupport indexerSupport) {
        this.indexHelper = (IndexHelper)Preconditions.checkNotNull((Object)indexHelper);
        this.indexerSupport = (IndexerSupport)Preconditions.checkNotNull((Object)indexerSupport);
    }

    public void reindex() throws CommitFailedException, IOException {
        NodeState checkpointedState = this.indexerSupport.retrieveNodeStateForCheckpoint();
        this.copyOnWriteStore = new MemoryNodeStore(checkpointedState);
        NodeState baseState = this.copyOnWriteStore.getRoot();
        this.indexerSupport.switchIndexLanesAndReindexFlag(this.copyOnWriteStore);
        this.preformIndexUpdate(baseState);
        this.indexerSupport.postIndexWork(this.copyOnWriteStore);
    }

    protected File getLocalIndexDir() throws IOException {
        return this.indexerSupport.getLocalIndexDir();
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public void indexUpdate() throws CommitFailedException {
    }

    public void traversedNode(NodeTraversalCallback.PathSource pathSource) throws CommitFailedException {
    }

    protected void preformIndexUpdate(NodeState baseState) throws IOException, CommitFailedException {
        NodeBuilder builder = this.copyOnWriteStore.getRoot().builder();
        IndexUpdate indexUpdate = new IndexUpdate(this.createIndexEditorProvider(), REINDEX_LANE, this.copyOnWriteStore.getRoot(), builder, (IndexUpdateCallback)this, (NodeTraversalCallback)this, CommitInfo.EMPTY, CorruptIndexHandler.NOOP);
        this.configureEstimators(indexUpdate);
        NodeState before = baseState;
        NodeState after = this.copyOnWriteStore.getRoot();
        CommitFailedException exception = EditorDiff.process((Editor)VisibleEditor.wrap((Editor)indexUpdate), (NodeState)before, (NodeState)after);
        if (exception != null) {
            throw exception;
        }
        this.copyOnWriteStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    protected abstract IndexEditorProvider createIndexEditorProvider() throws IOException;

    private void configureEstimators(IndexUpdate indexUpdate) {
        StatisticsProvider statsProvider = this.indexHelper.getStatisticsProvider();
        if (statsProvider instanceof MetricStatisticsProvider) {
            MetricRegistry registry = ((MetricStatisticsProvider)statsProvider).getRegistry();
            indexUpdate.setTraversalRateEstimator((TraversalRateEstimator)new MetricRateEstimator(REINDEX_LANE, registry));
        }
        NodeCounterMBeanEstimator estimator = new NodeCounterMBeanEstimator(this.indexHelper.getNodeStore());
        indexUpdate.setNodeCountEstimator((NodeCountEstimator)estimator);
    }
}

