/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.run.cli.CommonOptions;
import org.apache.jackrabbit.oak.run.cli.FileStoreTarBuilderCustomizer;
import org.apache.jackrabbit.oak.run.cli.Options;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.azure.tool.ToolUtils;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

class SegmentTarFixtureProvider {
    SegmentTarFixtureProvider() {
    }

    static NodeStore configureSegment(Options options, BlobStore blobStore, Whiteboard wb, Closer closer, boolean readOnly) throws IOException, InvalidFileStoreVersionException {
        SegmentNodeStore nodeStore;
        FileStoreBuilder builder;
        StatisticsProvider statisticsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)WhiteboardUtils.getService((Whiteboard)wb, StatisticsProvider.class));
        String pathOrUri = options.getOptionBean(CommonOptions.class).getStoreArg();
        ToolUtils.SegmentStoreType segmentStoreType = ToolUtils.storeTypeFromPathOrUri((String)pathOrUri);
        if (segmentStoreType == ToolUtils.SegmentStoreType.AZURE) {
            SegmentNodeStorePersistence segmentNodeStorePersistence = ToolUtils.newSegmentNodeStorePersistence((ToolUtils.SegmentStoreType)segmentStoreType, (String)pathOrUri);
            File tempDir = Files.createTempDirectory("azure-segment-store", new FileAttribute[0]).toFile();
            closer.register(() -> FileUtils.deleteQuietly((File)tempDir));
            builder = FileStoreBuilder.fileStoreBuilder((File)tempDir).withCustomPersistence(segmentNodeStorePersistence);
        } else {
            builder = FileStoreBuilder.fileStoreBuilder((File)new File(pathOrUri)).withMaxFileSize(256);
        }
        FileStoreTarBuilderCustomizer customizer = (FileStoreTarBuilderCustomizer)WhiteboardUtils.getService((Whiteboard)wb, FileStoreTarBuilderCustomizer.class);
        if (customizer != null) {
            customizer.customize(builder);
        }
        if (blobStore != null) {
            builder.withBlobStore(blobStore);
        }
        if (readOnly) {
            ReadOnlyFileStore fileStore = builder.withStatisticsProvider(statisticsProvider).buildReadOnly();
            closer.register((Closeable)fileStore);
            nodeStore = SegmentNodeStoreBuilders.builder((ReadOnlyFileStore)fileStore).build();
            wb.register(ReadOnlyFileStore.class, (Object)fileStore, Collections.emptyMap());
        } else {
            FileStore fileStore = builder.withStrictVersionCheck(true).withStatisticsProvider(statisticsProvider).build();
            closer.register((Closeable)fileStore);
            nodeStore = SegmentNodeStoreBuilders.builder((FileStore)fileStore).build();
            wb.register(FileStore.class, (Object)fileStore, Collections.emptyMap());
        }
        return nodeStore;
    }
}

