/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionSpec;
import joptsimple.internal.Strings;
import org.apache.jackrabbit.oak.run.cli.OptionsBean;
import org.jetbrains.annotations.Nullable;

public class OakHelpFormatter
implements HelpFormatter {
    private static final int COL_WIDTH = 120;
    private final List<OptionsBean> optionBeans;
    private final String commandName;
    private final String connectionString;
    private final String summary;

    public OakHelpFormatter(Iterable<OptionsBean> optionBeans, @Nullable String commandName, @Nullable String summary, @Nullable String connectionString) {
        this.optionBeans = Lists.newArrayList(optionBeans);
        this.commandName = commandName;
        this.summary = summary;
        this.connectionString = connectionString;
    }

    public String format(Map<String, ? extends OptionDescriptor> options) {
        HashMap clonedOptions = Maps.newHashMap(options);
        List<OptionCategory> optionCategories = this.categorise(clonedOptions);
        StringBuilder builder = new StringBuilder();
        builder.append(new MainSectionFormatter().format(options)).append(StandardSystemProperty.LINE_SEPARATOR.value());
        for (OptionCategory c : optionCategories) {
            builder.append(c.format()).append(StandardSystemProperty.LINE_SEPARATOR.value());
        }
        return builder.toString();
    }

    private List<OptionCategory> categorise(Map<String, ? extends OptionDescriptor> options) {
        ArrayList<OptionCategory> result = new ArrayList<OptionCategory>();
        for (OptionsBean bean : this.optionBeans) {
            HashMap<String, OptionDescriptor> optsForThisBean = new HashMap<String, OptionDescriptor>();
            HashMap<String, OptionDescriptor> operationsForThisBean = new HashMap<String, OptionDescriptor>();
            for (String name : OakHelpFormatter.getOptionNames(bean)) {
                OptionDescriptor desc = options.remove(name);
                if (desc == null) continue;
                if (bean.operationNames().contains(name)) {
                    operationsForThisBean.put(name, desc);
                    continue;
                }
                optsForThisBean.put(name, desc);
            }
            result.add(new OptionCategory(bean, optsForThisBean, operationsForThisBean));
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private static int getColWidth() {
        return 120;
    }

    private static Set<String> getOptionNames(OptionsBean bean) {
        HashSet<String> names = new HashSet<String>();
        try {
            for (Field field : bean.getClass().getDeclaredFields()) {
                if (!OptionSpec.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                OptionSpec spec = (OptionSpec)field.get(bean);
                names.addAll(spec.options());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return names;
    }

    private class MainSectionFormatter
    extends BuiltinHelpFormatter {
        public MainSectionFormatter() {
            super(OakHelpFormatter.getColWidth(), 2);
        }

        protected void addRows(Collection<? extends OptionDescriptor> options) {
            String firstLine;
            String string = firstLine = OakHelpFormatter.this.commandName != null ? OakHelpFormatter.this.commandName + " " : "";
            if (OakHelpFormatter.this.connectionString != null) {
                firstLine = firstLine + OakHelpFormatter.this.connectionString;
            }
            this.addNonOptionRow(firstLine);
            if (OakHelpFormatter.this.summary != null) {
                this.addNonOptionRow(OakHelpFormatter.this.summary);
            }
            this.fitRowsToWidth();
        }
    }

    private static class OperationsFormatter
    extends BuiltinHelpFormatter {
        public static final String OPERATIONS = "Operations";

        public OperationsFormatter() {
            super(OakHelpFormatter.getColWidth(), 2);
        }

        protected void addHeaders(Collection<? extends OptionDescriptor> options) {
            this.addOptionRow(OPERATIONS, this.message("description.header", new Object[0]));
            this.addOptionRow(Strings.repeat((char)'-', (int)OPERATIONS.length()), this.message("description.divider", new Object[0]));
        }

        protected void addNonOptionsDescription(Collection<? extends OptionDescriptor> options) {
        }
    }

    private static class CategoryFormatter
    extends BuiltinHelpFormatter {
        final OptionsBean bean;

        public CategoryFormatter(OptionsBean bean) {
            super(OakHelpFormatter.getColWidth(), 2);
            this.bean = bean;
        }

        protected void addRows(Collection<? extends OptionDescriptor> options) {
            this.addHeader();
            super.addRows(options);
        }

        protected void addNonOptionsDescription(Collection<? extends OptionDescriptor> options) {
        }

        private void addHeader() {
            String title = this.bean.title();
            if (title != null) {
                this.addNonOptionRow(title);
                this.addNonOptionRow(Strings.repeat((char)'=', (int)title.length()));
            }
            if (this.bean.description() != null) {
                this.addNonOptionRow(this.bean.description());
            }
        }
    }

    private static class OptionCategory
    implements Comparable<OptionCategory> {
        final OptionsBean bean;
        final Map<String, ? extends OptionDescriptor> options;
        final Map<String, ? extends OptionDescriptor> operations;

        public OptionCategory(OptionsBean bean, Map<String, ? extends OptionDescriptor> options, Map<String, OptionDescriptor> operations) {
            this.bean = bean;
            this.options = options;
            this.operations = operations;
        }

        public String format() {
            StringBuilder builder = new StringBuilder();
            builder.append(new CategoryFormatter(this.bean).format(this.options));
            if (!this.operations.isEmpty()) {
                builder.append(StandardSystemProperty.LINE_SEPARATOR.value());
                builder.append(new OperationsFormatter().format(this.operations));
            }
            return builder.toString();
        }

        @Override
        public int compareTo(OptionCategory that) {
            return Ints.compare((int)this.bean.order(), (int)that.bean.order());
        }
    }
}

