/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.jackrabbit.oak.run.cli.OptionsBean;

public class CommonOptions
implements OptionsBean {
    public static final String DEFAULT_CONNECTION_STRING = "{<path-to-repository> | <mongodb-uri>} | <rdb-uri> | memory}";
    private final OptionSpec<Void> help;
    private final OptionSpec<Void> readWriteOption;
    private final OptionSpec<String> nonOption;
    private final OptionSpec<Void> metrics;
    private final OptionSpec<Void> segment;
    private OptionSet options;

    public CommonOptions(OptionParser parser) {
        this.help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "Show help").forHelp();
        this.readWriteOption = parser.accepts("read-write", "Connect to repository in read-write mode");
        this.metrics = parser.accepts("metrics", "Enables metrics based statistics collection");
        this.segment = parser.accepts("segment", "Use older oak-segment support");
        this.nonOption = parser.nonOptions(DEFAULT_CONNECTION_STRING);
    }

    @Override
    public void configure(OptionSet options) {
        this.options = options;
    }

    public boolean isHelpRequested() {
        return this.options.has(this.help);
    }

    public boolean isReadWrite() {
        return this.options.has(this.readWriteOption);
    }

    public List<String> getNonOptions() {
        return this.nonOption.values(this.options);
    }

    public boolean isMongo() {
        return this.getStoreArg().startsWith("mongodb://");
    }

    public boolean isRDB() {
        return this.getStoreArg().startsWith("jdbc");
    }

    public boolean isOldSegment() {
        return this.options.has(this.segment);
    }

    public boolean isDocument() {
        return this.isMongo() || this.isRDB();
    }

    public boolean isMemory() {
        return this.getStoreArg().equalsIgnoreCase("memory");
    }

    public boolean isMetricsEnabled() {
        return this.options.has(this.metrics);
    }

    public String getStoreArg() {
        List nonOptions = this.nonOption.values(this.options);
        return nonOptions.size() > 0 ? (String)nonOptions.get(0) : "";
    }

    @Override
    public String title() {
        return "Global Options";
    }

    @Override
    public String description() {
        return null;
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public Set<String> operationNames() {
        return Collections.emptySet();
    }
}

