/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.jackrabbit.oak.run.cli.OptionsBean;

public class BlobStoreOptions
implements OptionsBean {
    private final OptionSpec<String> fdsOption;
    private final OptionSpec<String> s3Option;
    private final OptionSpec<String> azureOption;
    private final OptionSpec<String> fdsPathOption;
    private final OptionSpec<String> fakeDsPathOption;
    private final OptionSpec<Void> readWriteOption;
    private OptionSet options;

    public BlobStoreOptions(OptionParser parser) {
        this.fdsOption = parser.acceptsAll(Arrays.asList("fds"), "FileDataStore config path").withRequiredArg().ofType(String.class);
        this.fdsPathOption = parser.acceptsAll(Arrays.asList("fds-path"), "FileDataStore path").withRequiredArg().ofType(String.class);
        this.fakeDsPathOption = parser.acceptsAll(Arrays.asList("fake-ds-path"), "Path to be used to construct a Fake FileDataStore. It return an empty stream for any Blob but allows writes if used in read-write mode. (for testing purpose only)").withRequiredArg().ofType(String.class);
        this.s3Option = parser.acceptsAll(Arrays.asList("s3ds", "s3-config-path"), "S3DataStore config path").withRequiredArg().ofType(String.class);
        this.azureOption = parser.acceptsAll(Arrays.asList("azureblobds", "azureds"), "AzureBlobStorageDataStore config path").withRequiredArg().ofType(String.class);
        this.readWriteOption = parser.accepts("ds-read-write", "Connect to datastore in read-write mode. Use this option if only the datastore has to be opened  in read-write mode and not the node store (i.e. --read-write not to be specified)");
    }

    @Override
    public void configure(OptionSet options) {
        this.options = options;
    }

    @Override
    public String title() {
        return "BlobStore Options";
    }

    @Override
    public String description() {
        return "Options related to configuring a BlobStore. All config options here (except --fds-path) refer to the path of the config file. The file can be a '.config' file in the OSGi config admin format or properties file with '.cfg' and '.properties' extensions.";
    }

    @Override
    public int order() {
        return 10;
    }

    @Override
    public Set<String> operationNames() {
        return Collections.emptySet();
    }

    public String getFDSConfigPath() {
        return (String)this.fdsOption.value(this.options);
    }

    public String getFDSPath() {
        return (String)this.fdsPathOption.value(this.options);
    }

    public String getS3ConfigPath() {
        return (String)this.s3Option.value(this.options);
    }

    public String getAzureConfigPath() {
        return (String)this.azureOption.value(this.options);
    }

    public String getFakeDataStorePath() {
        return (String)this.fakeDsPathOption.value(this.options);
    }

    public Type getBlobStoreType() {
        if (this.options.has(this.fdsOption) || this.options.has(this.fdsPathOption)) {
            return Type.FDS;
        }
        if (this.options.has(this.s3Option)) {
            return Type.S3;
        }
        if (this.options.has(this.azureOption)) {
            return Type.AZURE;
        }
        if (this.options.has(this.fakeDsPathOption)) {
            return Type.FAKE;
        }
        return Type.NONE;
    }

    public boolean isReadWrite() {
        return this.options.has(this.readWriteOption);
    }

    public static enum Type {
        FDS,
        S3,
        AZURE,
        FAKE,
        NONE;

    }
}

