/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.mongodb.DBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.io.Closeable;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;

public class MongoDocumentTraverser {
    private final MongoDocumentStore mongoStore;
    private boolean disableReadOnlyCheck;

    public MongoDocumentTraverser(MongoDocumentStore mongoStore) {
        this.mongoStore = mongoStore;
    }

    public <T extends Document> CloseableIterable<T> getAllDocuments(Collection<T> collection, Predicate<String> filter) {
        if (!this.disableReadOnlyCheck) {
            Preconditions.checkState((boolean)this.mongoStore.isReadOnly(), (Object)"Traverser can only be used with readOnly store");
        }
        MongoCollection dbCollection = this.mongoStore.getDBCollection(collection);
        FindIterable cursor = dbCollection.withReadPreference(this.mongoStore.getConfiguredReadPreference(collection)).find();
        CloseableIterable closeableCursor = CloseableIterable.wrap((Iterable)cursor);
        cursor = closeableCursor;
        FluentIterable result = FluentIterable.from((Iterable)cursor).filter(o -> filter.test((String)o.get("_id"))).transform(o -> {
            Document doc = this.mongoStore.convertFromDBObject(collection, (DBObject)o);
            if (collection == Collection.NODES) {
                NodeDocument nodeDoc = (NodeDocument)doc;
                this.getNodeDocCache().put(nodeDoc);
            }
            return doc;
        });
        return CloseableIterable.wrap((Iterable)result, (Closeable)closeableCursor);
    }

    void disableReadOnlyCheck() {
        this.disableReadOnlyCheck = true;
    }

    private NodeDocumentCache getNodeDocCache() {
        return this.mongoStore.getNodeDocumentCache();
    }
}

