/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SimpleNodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.StateInBytesHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TraverseWithSortStrategy
implements SortStrategy {
    private static final String OAK_INDEXER_MIN_MEMORY = "oak.indexer.minMemoryForWork";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean sufficientMemory = new AtomicBoolean(true);
    private final Iterable<NodeStateEntry> nodeStates;
    private final NodeStateEntryWriter entryWriter;
    private final File storeDir;
    private final boolean compressionEnabled;
    private final Charset charset = Charsets.UTF_8;
    private final Comparator<NodeStateHolder> comparator;
    private NotificationEmitter emitter;
    private MemoryListener listener;
    private final int maxMemory = Integer.getInteger("oak.indexer.maxSortMemoryInGB", 2);
    private final long minMemory = Integer.getInteger("oak.indexer.minMemoryForWork", 2).intValue();
    private final long maxMemoryBytes = (long)this.maxMemory * 0x40000000L;
    private final long minMemoryBytes = this.minMemory * 0x40000000L;
    private boolean useMaxMemory;
    private long entryCount;
    private long memoryUsed;
    private File sortWorkDir;
    private List<File> sortedFiles = new ArrayList<File>();
    private ArrayList<NodeStateHolder> entryBatch = new ArrayList();

    TraverseWithSortStrategy(Iterable<NodeStateEntry> nodeStates, PathElementComparator pathComparator, NodeStateEntryWriter entryWriter, File storeDir, boolean compressionEnabled) {
        this.nodeStates = nodeStates;
        this.entryWriter = entryWriter;
        this.storeDir = storeDir;
        this.compressionEnabled = compressionEnabled;
        this.comparator = (e1, e2) -> pathComparator.compare((Iterable<String>)e1.getPathElements(), (Iterable<String>)e2.getPathElements());
    }

    @Override
    public File createSortedStoreFile() throws IOException {
        this.logFlags();
        this.configureMemoryListener();
        this.sortWorkDir = TraverseWithSortStrategy.createdSortWorkDir(this.storeDir);
        this.writeToSortedFiles();
        return this.sortStoreFile();
    }

    @Override
    public long getEntryCount() {
        return this.entryCount;
    }

    private File sortStoreFile() throws IOException {
        this.log.info("Proceeding to perform merge of {} sorted files", (Object)this.sortedFiles.size());
        Stopwatch w = Stopwatch.createStarted();
        File sortedFile = new File(this.storeDir, FlatFileStoreUtils.getSortedStoreFileName(this.compressionEnabled));
        try (BufferedWriter writer = FlatFileStoreUtils.createWriter(sortedFile, this.compressionEnabled);){
            Function<String, NodeStateHolder> func1 = line -> line == null ? null : new SimpleNodeStateHolder((String)line);
            Function<NodeStateHolder, String> func2 = holder -> holder == null ? null : holder.getLine();
            ExternalSort.mergeSortedFiles(this.sortedFiles, (BufferedWriter)writer, this.comparator, (Charset)this.charset, (boolean)true, (boolean)this.compressionEnabled, func2, func1);
        }
        this.log.info("Merging of sorted files completed in {}", (Object)w);
        return sortedFile;
    }

    private void writeToSortedFiles() throws IOException {
        Stopwatch w = Stopwatch.createStarted();
        for (NodeStateEntry e : this.nodeStates) {
            ++this.entryCount;
            this.addEntry(e);
        }
        this.sortAndSaveBatch();
        this.entryBatch.clear();
        this.entryBatch.trimToSize();
        this.log.info("Dumped {} nodestates in json format in {}", (Object)this.entryCount, (Object)w);
        this.log.info("Created {} sorted files of size {} to merge", (Object)this.sortedFiles.size(), (Object)IOUtils.humanReadableByteCount((long)FlatFileStoreUtils.sizeOf(this.sortedFiles)));
    }

    private void addEntry(NodeStateEntry e) throws IOException {
        if (this.isMemoryLow()) {
            this.sortAndSaveBatch();
            this.reset();
        }
        String jsonText = this.entryWriter.asJson(e.getNodeState());
        StateInBytesHolder h = new StateInBytesHolder(e.getPath(), jsonText);
        this.entryBatch.add(h);
        this.updateMemoryUsed(h);
    }

    private void reset() {
        this.entryBatch.clear();
        this.memoryUsed = 0L;
        this.sufficientMemory.set(true);
    }

    private void sortAndSaveBatch() throws IOException {
        if (this.entryBatch.isEmpty()) {
            return;
        }
        this.entryBatch.sort(this.comparator);
        Stopwatch w = Stopwatch.createStarted();
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", this.sortWorkDir);
        long textSize = 0L;
        try (BufferedWriter writer = FlatFileStoreUtils.createWriter(newtmpfile, this.compressionEnabled);){
            for (NodeStateHolder h : this.entryBatch) {
                String text = this.entryWriter.toString(h.getPathElements(), h.getLine());
                writer.write(text);
                writer.newLine();
                textSize += (long)(text.length() + 1);
            }
        }
        this.log.info("Sorted and stored batch of size {} (uncompressed {}) with {} entries in {}", new Object[]{IOUtils.humanReadableByteCount((long)newtmpfile.length()), IOUtils.humanReadableByteCount((long)textSize), this.entryBatch.size(), w});
        this.sortedFiles.add(newtmpfile);
    }

    private boolean isMemoryLow() {
        if (this.useMaxMemory) {
            return this.memoryUsed > this.maxMemoryBytes;
        }
        return !this.sufficientMemory.get();
    }

    private void updateMemoryUsed(NodeStateHolder h) {
        this.memoryUsed += (long)h.getMemorySize();
    }

    private static File createdSortWorkDir(File storeDir) throws IOException {
        File sortedFileDir = new File(storeDir, "sort-work-dir");
        FileUtils.forceMkdir((File)sortedFileDir);
        return sortedFileDir;
    }

    private void logFlags() {
        this.log.info("Min heap memory (GB) to be required : {} ({})", (Object)this.minMemory, (Object)OAK_INDEXER_MIN_MEMORY);
        this.log.info("Max heap memory (GB) to be used for merge sort : {} ({})", (Object)this.maxMemory, (Object)"oak.indexer.maxSortMemoryInGB");
    }

    private void configureMemoryListener() {
        MemoryPoolMXBean pool = TraverseWithSortStrategy.getMemoryPool();
        if (pool == null) {
            this.log.warn("Unable to setup monitoring of available memory. Would use configured maxMemory limit of {} GB", (Object)this.maxMemory);
            this.useMaxMemory = true;
            return;
        }
        this.emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        this.listener = new MemoryListener();
        this.emitter.addNotificationListener(this.listener, null, null);
        MemoryUsage usage = pool.getCollectionUsage();
        long maxMemory = usage.getMax();
        long warningThreshold = this.minMemory * 0x40000000L;
        if (warningThreshold > maxMemory) {
            this.log.warn("Configured minimum memory {} GB more than available memory ({}).Overriding configuration accordingly.", (Object)this.minMemory, (Object)IOUtils.humanReadableByteCount((long)maxMemory));
            warningThreshold = maxMemory;
        }
        this.log.info("Setting up a listener to monitor pool '{}' and trigger batch save if memory drop below {} GB (max {})", new Object[]{pool.getName(), this.minMemory, IOUtils.humanReadableByteCount((long)maxMemory)});
        pool.setCollectionUsageThreshold(warningThreshold);
        this.checkMemory(usage);
    }

    private void checkMemory(MemoryUsage usage) {
        long usedMemory;
        long maxMemory = usage.getMax();
        long avail = maxMemory - (usedMemory = usage.getUsed());
        if (avail > this.minMemoryBytes) {
            this.sufficientMemory.set(true);
            this.log.info("Available memory level {} is good. Current batch size {}", (Object)IOUtils.humanReadableByteCount((long)avail), (Object)this.entryBatch.size());
        } else {
            this.sufficientMemory.set(false);
            this.log.info("Available memory level {} (required {}) is low. Enabling flag to trigger batch save", (Object)IOUtils.humanReadableByteCount((long)avail), (Object)this.minMemory);
        }
    }

    private static MemoryPoolMXBean getMemoryPool() {
        long maxSize = 0L;
        MemoryPoolMXBean maxPool = null;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            long poolSize;
            if (MemoryType.HEAP != pool.getType() || !pool.isCollectionUsageThresholdSupported() || (poolSize = pool.getCollectionUsage().getMax()) <= maxSize) continue;
            maxPool = pool;
        }
        return maxPool;
    }

    private class MemoryListener
    implements NotificationListener {
        private MemoryListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals("java.management.memory.collection.threshold.exceeded") && TraverseWithSortStrategy.this.sufficientMemory.get()) {
                CompositeData cd = (CompositeData)notification.getUserData();
                MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
                TraverseWithSortStrategy.this.checkMemory(info.getUsage());
            }
        }
    }
}

