/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.json.BlobDeserializer;
import org.apache.jackrabbit.oak.json.JsonDeserializer;
import org.apache.jackrabbit.oak.plugins.blob.serializer.BlobIdSerializer;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStateEntryReader {
    private final BlobDeserializer blobDeserializer;

    public NodeStateEntryReader(BlobStore blobStore) {
        this.blobDeserializer = new BlobIdSerializer(blobStore);
    }

    public NodeStateEntry read(String line) {
        String[] parts = NodeStateEntryWriter.getParts(line);
        long memUsage = StringUtils.estimateMemoryUsage((String)parts[0]) + StringUtils.estimateMemoryUsage((String)parts[1]);
        return new NodeStateEntry(this.parseState(parts[1]), parts[0], memUsage);
    }

    private NodeState parseState(String part) {
        JsonDeserializer des = new JsonDeserializer(this.blobDeserializer);
        return des.deserialize(part);
    }
}

