/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStore;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryReader;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.StoreAndSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.TraverseWithSortStrategy;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileNodeStoreBuilder {
    public static final String OAK_INDEXER_USE_ZIP = "oak.indexer.useZip";
    private static final String OAK_INDEXER_TRAVERSE_WITH_SORT = "oak.indexer.traverseWithSortStrategy";
    private static final String OAK_INDEXER_SORTED_FILE_PATH = "oak.indexer.sortedFilePath";
    static final String OAK_INDEXER_MAX_SORT_MEMORY_IN_GB = "oak.indexer.maxSortMemoryInGB";
    static final int OAK_INDEXER_MAX_SORT_MEMORY_IN_GB_DEFAULT = 2;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Iterable<NodeStateEntry> nodeStates;
    private final File workDir;
    private Set<String> preferredPathElements = Collections.emptySet();
    private BlobStore blobStore;
    private PathElementComparator comparator;
    private NodeStateEntryWriter entryWriter;
    private long entryCount = 0L;
    private boolean useZip = Boolean.valueOf(System.getProperty("oak.indexer.useZip", "true"));
    private boolean useTraverseWithSort = Boolean.valueOf(System.getProperty("oak.indexer.traverseWithSortStrategy", "true"));

    public FlatFileNodeStoreBuilder(Iterable<NodeStateEntry> nodeStates, File workDir) {
        this.nodeStates = nodeStates;
        this.workDir = workDir;
    }

    public FlatFileNodeStoreBuilder withBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
        return this;
    }

    public FlatFileNodeStoreBuilder withPreferredPathElements(Set<String> preferredPathElements) {
        this.preferredPathElements = preferredPathElements;
        return this;
    }

    public FlatFileStore build() throws IOException {
        this.logFlags();
        this.comparator = new PathElementComparator(this.preferredPathElements);
        this.entryWriter = new NodeStateEntryWriter(this.blobStore);
        FlatFileStore store = new FlatFileStore(this.blobStore, this.createdSortedStoreFile(), new NodeStateEntryReader(this.blobStore), Collections.unmodifiableSet(this.preferredPathElements), this.useZip);
        if (this.entryCount > 0L) {
            store.setEntryCount(this.entryCount);
        }
        return store;
    }

    private File createdSortedStoreFile() throws IOException {
        String sortedFilePath = System.getProperty(OAK_INDEXER_SORTED_FILE_PATH);
        if (sortedFilePath != null) {
            File sortedFile = new File(sortedFilePath);
            if (sortedFile.exists() && sortedFile.isFile() && sortedFile.canRead()) {
                this.log.info("Reading from provided sorted file [{}] (via system property '{}')", (Object)sortedFile.getAbsolutePath(), (Object)OAK_INDEXER_SORTED_FILE_PATH);
                return sortedFile;
            }
            String msg = String.format("Cannot read sorted file at [%s] configured via system property '%s'", sortedFile.getAbsolutePath(), OAK_INDEXER_SORTED_FILE_PATH);
            throw new IllegalArgumentException(msg);
        }
        File flatFileStoreDir = this.createStoreDir();
        SortStrategy strategy = this.createSortStrategy(flatFileStoreDir);
        File result = strategy.createSortedStoreFile();
        this.entryCount = strategy.getEntryCount();
        return result;
    }

    private SortStrategy createSortStrategy(File dir) {
        if (this.useTraverseWithSort) {
            this.log.info("Using TraverseWithSortStrategy");
            return new TraverseWithSortStrategy(this.nodeStates, this.comparator, this.entryWriter, dir, this.useZip);
        }
        this.log.info("Using StoreAndSortStrategy");
        return new StoreAndSortStrategy(this.nodeStates, this.comparator, this.entryWriter, dir, this.useZip);
    }

    private void logFlags() {
        this.log.info("Preferred path elements are {}", (Object)Iterables.toString(this.preferredPathElements));
        this.log.info("Compression enabled while sorting : {} ({})", (Object)this.useZip, (Object)OAK_INDEXER_USE_ZIP);
        String strategy = this.useTraverseWithSort ? TraverseWithSortStrategy.class.getSimpleName() : StoreAndSortStrategy.class.getSimpleName();
        this.log.info("Sort strategy : {} ({})", (Object)strategy, (Object)OAK_INDEXER_TRAVERSE_WITH_SORT);
    }

    private File createStoreDir() throws IOException {
        File dir = new File(this.workDir, "flat-file-store");
        FileUtils.forceMkdir((File)dir);
        return dir;
    }
}

