/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentTraverser;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;

public class NodeStateEntryTraverser
implements Iterable<NodeStateEntry>,
Closeable {
    private final Closer closer = Closer.create();
    private final RevisionVector rootRevision;
    private final DocumentNodeStore documentNodeStore;
    private final MongoDocumentStore documentStore;
    private Consumer<String> progressReporter = id -> {};
    private Predicate<String> pathPredicate = path -> true;

    public NodeStateEntryTraverser(DocumentNodeStore documentNodeStore, MongoDocumentStore documentStore) {
        this(documentNodeStore.getHeadRevision(), documentNodeStore, documentStore);
    }

    public NodeStateEntryTraverser(RevisionVector rootRevision, DocumentNodeStore documentNodeStore, MongoDocumentStore documentStore) {
        this.rootRevision = rootRevision;
        this.documentNodeStore = documentNodeStore;
        this.documentStore = documentStore;
    }

    @Override
    @NotNull
    public Iterator<NodeStateEntry> iterator() {
        return this.getIncludedDocs().iterator();
    }

    public NodeStateEntryTraverser withProgressCallback(Consumer<String> progressReporter) {
        this.progressReporter = progressReporter;
        return this;
    }

    public NodeStateEntryTraverser withPathPredicate(Predicate<String> pathPredicate) {
        this.pathPredicate = pathPredicate;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private Iterable<NodeStateEntry> getIncludedDocs() {
        return FluentIterable.from(this.getDocsFilteredByPath()).filter(doc -> this.includeDoc((NodeDocument)doc)).transformAndConcat(doc -> this.getEntries((NodeDocument)doc));
    }

    private boolean includeDoc(NodeDocument doc) {
        String path = doc.getPath().toString();
        return !doc.isSplitDocument() && !NodeStateUtils.isHiddenPath((String)path) && this.pathPredicate.test(path);
    }

    private Iterable<NodeStateEntry> getEntries(NodeDocument doc) {
        Path path = doc.getPath();
        DocumentNodeState nodeState = this.documentNodeStore.getNode(path, this.rootRevision);
        if (nodeState == null || !nodeState.exists()) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)Iterables.concat(Collections.singleton(nodeState), (Iterable)nodeState.getAllBundledNodesStates()), dns -> new NodeStateEntry((NodeState)dns, dns.getPath().toString()));
    }

    private Iterable<NodeDocument> getDocsFilteredByPath() {
        CloseableIterable<NodeDocument> docs = this.findAllDocuments();
        this.closer.register(docs);
        return docs;
    }

    private CloseableIterable<NodeDocument> findAllDocuments() {
        return new MongoDocumentTraverser(this.documentStore).getAllDocuments(Collection.NODES, id -> this.includeId((String)id));
    }

    private boolean includeId(String id) {
        this.progressReporter.accept(id);
        if (Utils.isIdFromLongPath((String)id)) {
            return true;
        }
        if (Utils.isPreviousDocId((String)id)) {
            return true;
        }
        String path = Utils.getPathFromId((String)id);
        if (NodeStateUtils.isHiddenPath((String)path)) {
            return false;
        }
        return this.pathPredicate.test(path);
    }
}

