/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.index.IndexerSupport;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeIndexer;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverser;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateIndexer;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateIndexerProvider;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileNodeStoreBuilder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.plugins.index.progress.IndexingProgressReporter;
import org.apache.jackrabbit.oak.plugins.index.progress.MetricRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.TraversalRateEstimator;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentStoreIndexerBase
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Logger traversalLog = LoggerFactory.getLogger((String)(DocumentStoreIndexerBase.class.getName() + ".traversal"));
    protected final Closer closer = Closer.create();
    protected final IndexHelper indexHelper;
    protected List<NodeStateIndexerProvider> indexerProviders;
    protected final IndexerSupport indexerSupport;
    private final IndexingProgressReporter progressReporter = new IndexingProgressReporter(IndexUpdateCallback.NOOP, NodeTraversalCallback.NOOP);
    private final Set<String> indexerPaths = new HashSet<String>();

    public DocumentStoreIndexerBase(IndexHelper indexHelper, IndexerSupport indexerSupport) throws IOException {
        this.indexHelper = indexHelper;
        this.indexerSupport = indexerSupport;
    }

    protected void setProviders() throws IOException {
        this.indexerProviders = this.createProviders();
    }

    public void reindex() throws CommitFailedException, IOException {
        this.configureEstimators();
        NodeState checkpointedState = this.indexerSupport.retrieveNodeStateForCheckpoint();
        MemoryNodeStore copyOnWriteStore = new MemoryNodeStore(checkpointedState);
        this.indexerSupport.switchIndexLanesAndReindexFlag((NodeStore)copyOnWriteStore);
        NodeBuilder builder = copyOnWriteStore.getRoot().builder();
        CompositeIndexer indexer = this.prepareIndexers((NodeStore)copyOnWriteStore, builder);
        if (indexer.isEmpty()) {
            return;
        }
        this.closer.register((Closeable)indexer);
        DocumentNodeState rootDocumentState = (DocumentNodeState)checkpointedState;
        DocumentNodeStore nodeStore = (DocumentNodeStore)this.indexHelper.getNodeStore();
        NodeStateEntryTraverser nsep = new NodeStateEntryTraverser(rootDocumentState.getRootRevision(), nodeStore, this.getMongoDocumentStore()).withProgressCallback(this::reportDocumentRead).withPathPredicate(indexer::shouldInclude);
        this.closer.register((Closeable)nsep);
        this.progressReporter.setMessagePrefix("Dumping");
        FlatFileStore flatFileStore = new FlatFileNodeStoreBuilder(nsep, this.indexHelper.getWorkDir()).withBlobStore((BlobStore)this.indexHelper.getGCBlobStore()).withPreferredPathElements(indexer.getRelativeIndexedNodeNames()).build();
        this.closer.register((Closeable)flatFileStore);
        this.progressReporter.reset();
        if (flatFileStore.getEntryCount() > 0L) {
            this.progressReporter.setNodeCountEstimator((basePath, indexPaths) -> flatFileStore.getEntryCount());
        }
        this.progressReporter.reindexingTraversalStart("/");
        this.preIndexOpertaions(indexer.getIndexers());
        Stopwatch indexerWatch = Stopwatch.createStarted();
        for (NodeStateEntry entry : flatFileStore) {
            this.reportDocumentRead(entry.getPath());
            indexer.index(entry);
        }
        this.progressReporter.reindexingTraversalEnd();
        this.progressReporter.logReport();
        this.log.info("Completed the indexing in {}", (Object)indexerWatch);
        copyOnWriteStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.indexerSupport.postIndexWork((NodeStore)copyOnWriteStore);
    }

    private MongoDocumentStore getMongoDocumentStore() {
        return (MongoDocumentStore)Preconditions.checkNotNull((Object)this.indexHelper.getService(MongoDocumentStore.class));
    }

    private void configureEstimators() {
        long nodesCount;
        StatisticsProvider statsProvider = this.indexHelper.getStatisticsProvider();
        if (statsProvider instanceof MetricStatisticsProvider) {
            MetricRegistry registry = ((MetricStatisticsProvider)statsProvider).getRegistry();
            this.progressReporter.setTraversalRateEstimator((TraversalRateEstimator)new MetricRateEstimator("async", registry));
        }
        if ((nodesCount = this.getEstimatedDocumentCount()) > 0L) {
            this.progressReporter.setNodeCountEstimator((basePath, indexPaths) -> nodesCount);
            this.progressReporter.setEstimatedCount(nodesCount);
            this.log.info("Estimated number of documents in Mongo are {}", (Object)nodesCount);
        }
    }

    private long getEstimatedDocumentCount() {
        MongoConnection mongoConnection = this.indexHelper.getService(MongoConnection.class);
        if (mongoConnection != null) {
            return mongoConnection.getDatabase().getCollection("nodes").count();
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private void reportDocumentRead(String id) {
        try {
            this.progressReporter.traversedNode(() -> id);
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
        this.traversalLog.trace(id);
    }

    protected CompositeIndexer prepareIndexers(NodeStore copyOnWriteStore, NodeBuilder builder) {
        NodeState root = copyOnWriteStore.getRoot();
        ArrayList<NodeStateIndexer> indexers = new ArrayList<NodeStateIndexer>();
        for (String indexPath : this.indexHelper.getIndexPaths()) {
            NodeState indexState = NodeStateUtils.getNode((NodeState)root, (String)indexPath);
            NodeBuilder idxBuilder = IndexerSupport.childBuilder(builder, indexPath, false);
            String type = indexState.getString("type");
            if (type == null) {
                this.log.warn("No 'type' property found on indexPath [{}]. Skipping it", (Object)indexPath);
                continue;
            }
            this.removeIndexState(idxBuilder);
            idxBuilder.setProperty("reindex", (Object)false);
            for (NodeStateIndexerProvider indexerProvider : this.indexerProviders) {
                NodeStateIndexer indexer = indexerProvider.getIndexer(type, indexPath, idxBuilder, root, this.progressReporter);
                if (indexer == null) continue;
                indexers.add(indexer);
                this.closer.register((Closeable)indexer);
                this.progressReporter.registerIndex(indexPath, true, -1L);
                this.indexerPaths.add(indexPath);
            }
        }
        return new CompositeIndexer(indexers);
    }

    protected abstract List<NodeStateIndexerProvider> createProviders() throws IOException;

    protected abstract void preIndexOpertaions(List<NodeStateIndexer> var1);

    private void removeIndexState(NodeBuilder definition) {
        for (String rm : definition.getChildNodeNames()) {
            NodeBuilder childNode;
            if (!NodeStateUtils.isHidden((String)rm) || (childNode = definition.getChildNode(rm)).getBoolean("retainNodeInReindex")) continue;
            definition.getChildNode(rm).remove();
        }
    }
}

