/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.run.cli.OptionsBean;
import org.apache.jackrabbit.oak.run.cli.OptionsBeanFactory;

public class IndexOptions
implements OptionsBean {
    public static final OptionsBeanFactory FACTORY = IndexOptions::new;
    private final OptionSpec<File> workDirOpt;
    private final OptionSpec<File> outputDirOpt;
    private final OptionSpec<File> indexImportDir;
    private final OptionSpec<File> preExtractedTextOpt;
    private final OptionSpec<File> indexDefinitionsOpt;
    private final OptionSpec<Void> stats;
    private final OptionSpec<Void> definitions;
    private final OptionSpec<Void> dumpIndex;
    private final OptionSpec<Void> reindex;
    private final OptionSpec<Void> importIndex;
    private final OptionSpec<Void> docTraversal;
    private final OptionSpec<Integer> consistencyCheck;
    protected OptionSet options;
    protected final Set<OptionSpec> actionOpts;
    private final OptionSpec<String> indexPaths;
    private final OptionSpec<String> checkpoint;
    private final Set<String> operationNames;

    public IndexOptions(OptionParser parser) {
        this.workDirOpt = parser.accepts("index-temp-dir", "Directory used for storing temporary files").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("temp"), (Object[])new File[0]);
        this.outputDirOpt = parser.accepts("index-out-dir", "Directory used for output files").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("indexing-result"), (Object[])new File[0]);
        this.preExtractedTextOpt = parser.accepts("pre-extracted-text-dir", "Directory storing pre extracted text").withRequiredArg().ofType(File.class);
        this.indexDefinitionsOpt = parser.accepts("index-definitions-file", "index definition file which include new index definitions or changes to existing index definitions").withRequiredArg().ofType(File.class);
        this.stats = parser.accepts("index-info", "Collects and dumps various statistics related to the indexes");
        this.definitions = parser.accepts("index-definitions", "Collects and dumps index definitions");
        this.indexPaths = parser.accepts("index-paths", "Comma separated list of index paths for which the selected operations need to be performed").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.checkpoint = parser.accepts("checkpoint", "The checkpoint up to which the index is updated, when indexing in read only mode. For testing purpose, it can be set to 'head' to indicate that the head state should be used.").withRequiredArg().ofType(String.class);
        this.consistencyCheck = parser.accepts("index-consistency-check", "Performs consistency check for indexes as specified by --index-paths (if this not set, all indexes are checked). Currently only Lucene indexes are supported. Possible values 1 - Basic check, 2 - Full check (slower)").withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
        this.dumpIndex = parser.accepts("index-dump", "Dumps index content");
        this.reindex = parser.accepts("reindex", "Reindex the indexes specified by --index-paths or --index-definitions-file");
        this.importIndex = parser.accepts("index-import", "Imports index");
        this.docTraversal = parser.accepts("doc-traversal-mode", "Use Document traversal mode for reindex in DocumentNodeStore setups. This may provide better performance in some cases (experimental)");
        this.indexImportDir = parser.accepts("index-import-dir", "Directory containing index files. This is required when --index-import operation is selected").requiredIf(this.importIndex, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        this.actionOpts = ImmutableSet.of(this.stats, this.definitions, this.consistencyCheck, this.dumpIndex, this.reindex, this.importIndex, (Object[])new OptionSpec[0]);
        this.operationNames = IndexOptions.collectionOperationNames(this.actionOpts);
    }

    @Override
    public void configure(OptionSet options) {
        this.options = options;
    }

    @Override
    public String title() {
        return "";
    }

    @Override
    public String description() {
        return "The index command supports the following operations. Most operations are read only.\nBloStore related options must be provided, as operations access the binaries stored there.\nIf no explicit operation is selected, --index-info and --index-definitions operation are performed.\nUse --index-paths to restrict the set of indexes on which the operation needs to be run.";
    }

    @Override
    public int order() {
        return 50;
    }

    @Override
    public Set<String> operationNames() {
        return this.operationNames;
    }

    public File getWorkDir() throws IOException {
        File workDir = (File)this.workDirOpt.value(this.options);
        FileUtils.forceMkdir((File)workDir);
        return workDir;
    }

    public File getOutDir() {
        return (File)this.outputDirOpt.value(this.options);
    }

    public File getPreExtractedTextDir() {
        return (File)this.preExtractedTextOpt.value(this.options);
    }

    public File getIndexDefinitionsFile() {
        return (File)this.indexDefinitionsOpt.value(this.options);
    }

    public File getIndexImportDir() {
        return (File)this.indexImportDir.value(this.options);
    }

    public boolean dumpStats() {
        return this.options.has(this.stats) || !this.anyActionSelected();
    }

    public boolean dumpDefinitions() {
        return this.options.has(this.definitions) || !this.anyActionSelected();
    }

    public boolean dumpIndex() {
        return this.options.has(this.dumpIndex);
    }

    public boolean checkConsistency() {
        return this.options.has(this.consistencyCheck);
    }

    public int consistencyCheckLevel() {
        return (Integer)this.consistencyCheck.value(this.options);
    }

    public boolean isReindex() {
        return this.options.has(this.reindex);
    }

    public boolean isImportIndex() {
        return this.options.has(this.importIndex);
    }

    public boolean isDocTraversalMode() {
        return this.options.has(this.docTraversal);
    }

    public String getCheckpoint() {
        return (String)this.checkpoint.value(this.options);
    }

    public List<String> getIndexPaths() {
        return this.options.has(this.indexPaths) ? IndexOptions.trim(this.indexPaths.values(this.options)) : Collections.emptyList();
    }

    private boolean anyActionSelected() {
        for (OptionSpec spec : this.actionOpts) {
            if (!this.options.has(spec)) continue;
            return true;
        }
        return false;
    }

    private static List<String> trim(List<String> values) {
        HashSet paths = Sets.newHashSet();
        for (String v : values) {
            if ((v = Strings.emptyToNull((String)v)) == null) continue;
            paths.add(v.trim());
        }
        return new ArrayList<String>(paths);
    }

    private static Set<String> collectionOperationNames(Set<OptionSpec> actionOpts) {
        HashSet<String> result = new HashSet<String>();
        for (OptionSpec spec : actionOpts) {
            result.addAll(spec.options());
        }
        return result;
    }
}

