/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoServiceImpl;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoServiceImpl;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.plugins.index.IndexPathServiceImpl;
import org.apache.jackrabbit.oak.plugins.index.inventory.IndexDefinitionPrinter;
import org.apache.jackrabbit.oak.plugins.index.inventory.IndexPrinter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHelper
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final NodeStore store;
    protected final File outputDir;
    protected final File workDir;
    private IndexPathService indexPathService;
    private AsyncIndexInfoService asyncIndexInfoService;
    protected final List<String> indexPaths;
    private final Whiteboard whiteboard;
    private Executor executor;
    private final Closer closer = Closer.create();
    private final BlobStore blobStore;
    private final StatisticsProvider statisticsProvider;
    private IndexInfoServiceImpl indexInfoService;

    IndexHelper(NodeStore store, BlobStore blobStore, Whiteboard whiteboard, File outputDir, File workDir, List<String> indexPaths) {
        this.store = store;
        this.blobStore = blobStore;
        this.whiteboard = whiteboard;
        this.statisticsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)WhiteboardUtils.getService((Whiteboard)whiteboard, StatisticsProvider.class));
        this.outputDir = outputDir;
        this.workDir = workDir;
        this.indexPaths = ImmutableList.copyOf(indexPaths);
    }

    public NodeStore getNodeStore() {
        return this.store;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public IndexPrinter getIndexPrinter() {
        return new IndexPrinter(this.getIndexInfoService(), this.getAsyncIndexInfoService());
    }

    public IndexDefinitionPrinter getIndexDefnPrinter() {
        return new IndexDefinitionPrinter(this.store, this.getIndexPathService());
    }

    public IndexPathService getIndexPathService() {
        if (this.indexPathService == null) {
            this.indexPathService = this.indexPaths.isEmpty() ? new IndexPathServiceImpl(this.store) : () -> this.indexPaths;
        }
        return this.indexPathService;
    }

    public List<String> getIndexPaths() {
        return this.indexPaths;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            ThreadPoolExecutor executorService = this.createExecutor();
            this.closer.register((Closeable)new ExecutorCloser((ExecutorService)executorService));
            this.executor = executorService;
        }
        return this.executor;
    }

    public MountInfoProvider getMountInfoProvider() {
        return Mounts.defaultMountInfoProvider();
    }

    public StatisticsProvider getStatisticsProvider() {
        return this.statisticsProvider;
    }

    @Nullable
    public GarbageCollectableBlobStore getGCBlobStore() {
        return this.blobStore instanceof GarbageCollectableBlobStore ? (GarbageCollectableBlobStore)this.blobStore : null;
    }

    @Nullable
    public <T> T getService(@NotNull Class<T> type) {
        return (T)WhiteboardUtils.getService((Whiteboard)this.whiteboard, type);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    protected AsyncIndexInfoService getAsyncIndexInfoService() {
        if (this.asyncIndexInfoService == null) {
            this.asyncIndexInfoService = new AsyncIndexInfoServiceImpl(this.store);
        }
        return this.asyncIndexInfoService;
    }

    private IndexInfoService getIndexInfoService() {
        if (this.indexInfoService == null) {
            this.indexInfoService = new IndexInfoServiceImpl(this.store, this.getIndexPathService());
            this.bindIndexInfoProviders(this.indexInfoService);
        }
        return this.indexInfoService;
    }

    protected void bindIndexInfoProviders(IndexInfoServiceImpl indexInfoService) {
    }

    private ThreadPoolExecutor createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();
            private final Thread.UncaughtExceptionHandler handler = (t, e) -> IndexHelper.this.log.warn("Error occurred in asynchronous processing ", e);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                thread.setPriority(1);
                thread.setUncaughtExceptionHandler(this.handler);
                return thread;
            }

            private String createName() {
                return "oak-lucene-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }
}

