/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

class ReadOnlyBlobStoreWrapper {
    ReadOnlyBlobStoreWrapper() {
    }

    public static BlobStore wrap(BlobStore delegate) {
        Class<?>[] interfaces = delegate.getClass().getInterfaces();
        return (BlobStore)Proxy.newProxyInstance(ReadOnlyBlobStoreWrapper.class.getClassLoader(), interfaces, (InvocationHandler)new ReadOnlyHandler(delegate));
    }

    private static class ReadOnlyHandler
    implements InvocationHandler {
        private final Set<String> writableMethods = ImmutableSet.of((Object)"writeBlob", (Object)"deleteChunks", (Object)"countDeleteChunks");
        private final BlobStore delegate;

        ReadOnlyHandler(BlobStore delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (this.writableMethods.contains(methodName)) {
                throw new UnsupportedOperationException("Readonly BlobStore - Cannot invoked " + method);
            }
            return method.invoke((Object)this.delegate, args);
        }
    }
}

