/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import com.mongodb.MongoClientURI;
import java.io.IOException;
import java.util.Collections;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDataSourceFactory;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.run.cli.CommonOptions;
import org.apache.jackrabbit.oak.run.cli.DocumentBuilderCustomizer;
import org.apache.jackrabbit.oak.run.cli.DocumentNodeStoreOptions;
import org.apache.jackrabbit.oak.run.cli.Options;
import org.apache.jackrabbit.oak.run.cli.RDBStoreOptions;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

class DocumentFixtureProvider {
    DocumentFixtureProvider() {
    }

    static DocumentNodeStore configureDocumentMk(Options options, BlobStore blobStore, Whiteboard wb, Closer closer, boolean readOnly) throws IOException {
        DocumentNodeStore dns;
        MongoDocumentNodeStoreBuilder builder;
        CommonOptions commonOpts = options.getOptionBean(CommonOptions.class);
        if (commonOpts.isMongo()) {
            builder = MongoDocumentNodeStoreBuilder.newMongoDocumentNodeStoreBuilder();
        } else if (commonOpts.isRDB()) {
            builder = RDBDocumentNodeStoreBuilder.newRDBDocumentNodeStoreBuilder();
        } else {
            throw new IllegalStateException("Unknown DocumentStore");
        }
        StatisticsProvider statisticsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)WhiteboardUtils.getService((Whiteboard)wb, StatisticsProvider.class));
        DocumentBuilderCustomizer customizer = (DocumentBuilderCustomizer)WhiteboardUtils.getService((Whiteboard)wb, DocumentBuilderCustomizer.class);
        if (customizer != null) {
            customizer.customize((DocumentNodeStoreBuilder<?>)builder);
        }
        if (blobStore != null) {
            builder.setBlobStore(blobStore);
        }
        DocumentNodeStoreOptions docStoreOpts = options.getOptionBean(DocumentNodeStoreOptions.class);
        builder.setClusterId(docStoreOpts.getClusterId());
        builder.setStatisticsProvider(statisticsProvider);
        if (readOnly) {
            builder.setReadOnlyMode();
        }
        builder.setClusterInvisible(true);
        int cacheSize = docStoreOpts.getCacheSize();
        if (cacheSize != 0) {
            builder.memoryCacheSize((long)cacheSize * 0x100000L);
        }
        if (docStoreOpts.disableBranchesSpec()) {
            builder.disableBranches();
        }
        if (docStoreOpts.isCacheDistributionDefined()) {
            builder.memoryCacheDistribution(docStoreOpts.getNodeCachePercentage(), docStoreOpts.getPrevDocCachePercentage(), docStoreOpts.getChildrenCachePercentage(), docStoreOpts.getDiffCachePercentage());
        }
        if (commonOpts.isMongo()) {
            MongoClientURI uri = new MongoClientURI(commonOpts.getStoreArg());
            if (uri.getDatabase() == null) {
                System.err.println("Database missing in MongoDB URI: " + uri.getURI());
                System.exit(1);
            }
            MongoConnection mongo = new MongoConnection(uri.getURI());
            wb.register(MongoConnection.class, (Object)mongo, Collections.emptyMap());
            closer.register(() -> ((MongoConnection)mongo).close());
            builder.setMongoDB(mongo.getMongoClient(), mongo.getDBName());
            dns = builder.build();
            wb.register(MongoDocumentStore.class, (Object)((MongoDocumentStore)builder.getDocumentStore()), Collections.emptyMap());
        } else if (commonOpts.isRDB()) {
            RDBStoreOptions rdbOpts = options.getOptionBean(RDBStoreOptions.class);
            DataSource ds = RDBDataSourceFactory.forJdbcUrl((String)commonOpts.getStoreArg(), (String)rdbOpts.getUser(), (String)rdbOpts.getPassword());
            wb.register(DataSource.class, (Object)ds, Collections.emptyMap());
            ((RDBDocumentNodeStoreBuilder)builder).setRDBConnection(ds);
            dns = builder.build();
            wb.register(RDBDocumentStore.class, (Object)((RDBDocumentStore)builder.getDocumentStore()), Collections.emptyMap());
        } else {
            throw new IllegalStateException("Unknown DocumentStore");
        }
        closer.register(() -> ((DocumentNodeStore)dns).dispose());
        return dns;
    }
}

