/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import com.google.common.base.StandardSystemProperty;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.fixture.BlobStoreFixture;
import org.apache.jackrabbit.oak.fixture.OakFixture;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundExceptionListener;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.Configuration;
import org.apache.jackrabbit.oak.segment.azure.AzurePersistence;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClientSync;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyServerSync;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentTarFixture
extends OakFixture {
    private static final Logger log = LoggerFactory.getLogger(SegmentTarFixture.class);
    SegmentNotFoundExceptionListener IGNORE_SNFE = new SegmentNotFoundExceptionListener(){

        public void notify(@NotNull SegmentId id, @NotNull SegmentNotFoundException snfe) {
        }
    };
    private static final int MB = 0x100000;
    private static final int DEFAULT_TIMEOUT = 60000;
    private final File base;
    private final int maxFileSize;
    private final int segmentCacheSize;
    private final boolean memoryMapping;
    private final boolean useBlobStore;
    private final int dsCacheSize;
    private final boolean withColdStandby;
    private final int syncInterval;
    private final boolean shareBlobStore;
    private final boolean oneShotRun;
    private final boolean secure;
    private final String awsBucketName;
    private final String awsRootPath;
    private final String awsJournalTableName;
    private final String awsLockTableName;
    private final String azureConnectionString;
    private final String azureContainerName;
    private final String azureRootPath;
    private final File parentPath;
    private FileStore[] stores;
    private BlobStoreFixture[] blobStoreFixtures;
    private StandbyServerSync[] serverSyncs;
    private StandbyClientSync[] clientSyncs;
    private ScheduledExecutorService[] executors;
    private CloudBlobContainer[] containers;

    public SegmentTarFixture(SegmentTarFixtureBuilder builder) {
        this(builder, false, -1);
    }

    public SegmentTarFixture(SegmentTarFixtureBuilder builder, boolean withColdStandby, int syncInterval) {
        this(builder, withColdStandby, syncInterval, false, false, false);
    }

    public SegmentTarFixture(SegmentTarFixtureBuilder builder, boolean withColdStandby, int syncInterval, boolean shareBlobStore, boolean oneShotRun, boolean secure) {
        super(builder.name);
        this.base = builder.base;
        this.parentPath = new File(this.base, this.unique);
        this.maxFileSize = builder.maxFileSize;
        this.segmentCacheSize = builder.segmentCacheSize;
        this.memoryMapping = builder.memoryMapping;
        this.useBlobStore = builder.useBlobStore;
        this.dsCacheSize = builder.dsCacheSize;
        this.awsBucketName = builder.awsBucketName;
        this.awsRootPath = builder.awsRootPath;
        this.awsJournalTableName = builder.awsJournalTableName;
        this.awsLockTableName = builder.awsLockTableName;
        this.azureConnectionString = builder.azureConnectionString;
        this.azureContainerName = builder.azureContainerName;
        this.azureRootPath = builder.azureRootPath;
        this.withColdStandby = withColdStandby;
        this.syncInterval = syncInterval;
        this.shareBlobStore = shareBlobStore;
        this.oneShotRun = oneShotRun;
        this.secure = secure;
    }

    private static Configuration getAwsConfig(final String awsBucketName, final String awsRootPath, final String awsJournalTableName, final String awsLockTableName) {
        return new Configuration(){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String sessionToken() {
                return null;
            }

            public String secretKey() {
                return null;
            }

            public String rootDirectory() {
                return awsRootPath;
            }

            public String region() {
                return null;
            }

            public String lockTableName() {
                return awsLockTableName;
            }

            public String journalTableName() {
                return awsJournalTableName;
            }

            public String bucketName() {
                return awsBucketName;
            }

            public String accessKey() {
                return null;
            }
        };
    }

    @Override
    public Oak getOak(int clusterId) throws Exception {
        FileStoreBuilder fileStoreBuilder = FileStoreBuilder.fileStoreBuilder((File)this.parentPath).withMaxFileSize(this.maxFileSize).withSegmentCacheSize(this.segmentCacheSize).withMemoryMapping(this.memoryMapping);
        if (this.awsBucketName != null) {
            Configuration config = SegmentTarFixture.getAwsConfig(this.awsBucketName, this.awsRootPath, this.awsJournalTableName, this.awsLockTableName);
            AwsContext awsContext = AwsContext.create((Configuration)config);
            fileStoreBuilder.withCustomPersistence((SegmentNodeStorePersistence)new AwsPersistence(awsContext));
        }
        if (this.azureConnectionString != null) {
            CloudStorageAccount cloud = CloudStorageAccount.parse((String)this.azureConnectionString);
            CloudBlobContainer container = cloud.createCloudBlobClient().getContainerReference(this.azureContainerName);
            container.createIfNotExists();
            CloudBlobDirectory directory = container.getDirectoryReference(this.azureRootPath);
            fileStoreBuilder.withCustomPersistence((SegmentNodeStorePersistence)new AzurePersistence(directory));
        }
        DataStoreBlobStore blobStore = null;
        if (this.useBlobStore) {
            FileDataStore fds = new FileDataStore();
            fds.setMinRecordLength(4092);
            fds.init(this.parentPath.getAbsolutePath());
            blobStore = new DataStoreBlobStore((DataStore)fds);
            fileStoreBuilder.withBlobStore((BlobStore)blobStore);
        }
        FileStore fs = fileStoreBuilder.build();
        Oak oak = SegmentTarFixture.newOak((NodeStore)SegmentNodeStoreBuilders.builder((FileStore)fs).build());
        if (blobStore != null) {
            oak.getWhiteboard().register(BlobAccessProvider.class, (Object)((BlobAccessProvider)blobStore), Collections.EMPTY_MAP);
        }
        return oak;
    }

    @Override
    public Oak[] setUpCluster(int n, StatisticsProvider statsProvider) throws Exception {
        this.init(n);
        Oak[] cluster = new Oak[n];
        for (int i = 0; i < cluster.length; ++i) {
            BlobStore blobStore = null;
            if (this.useBlobStore) {
                this.blobStoreFixtures[i] = BlobStoreFixture.create(this.parentPath, true, this.dsCacheSize, statsProvider);
                blobStore = this.blobStoreFixtures[i].setUp();
            }
            FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder((File)new File(this.parentPath, "primary-" + i));
            if (this.awsBucketName != null) {
                Configuration config = SegmentTarFixture.getAwsConfig(this.awsBucketName + "-" + i, this.awsRootPath, this.awsJournalTableName + "-" + i, this.awsLockTableName + "-" + i);
                AwsContext awsContext = AwsContext.create((Configuration)config);
                builder.withCustomPersistence((SegmentNodeStorePersistence)new AwsPersistence(awsContext));
            }
            if (this.azureConnectionString != null) {
                CloudStorageAccount cloud = CloudStorageAccount.parse((String)this.azureConnectionString);
                CloudBlobContainer container = cloud.createCloudBlobClient().getContainerReference(this.azureContainerName);
                container.createIfNotExists();
                this.containers[i] = container;
                CloudBlobDirectory directory = container.getDirectoryReference(this.azureRootPath + "/primary-" + i);
                builder.withCustomPersistence((SegmentNodeStorePersistence)new AzurePersistence(directory));
            }
            if (blobStore != null) {
                builder.withBlobStore(blobStore);
            }
            this.stores[i] = builder.withMaxFileSize(this.maxFileSize).withStatisticsProvider(statsProvider).withSegmentCacheSize(this.segmentCacheSize).withMemoryMapping(this.memoryMapping).withStrictVersionCheck(true).build();
            if (this.withColdStandby) {
                this.attachStandby(i, n, statsProvider, blobStore);
            }
            cluster[i] = SegmentTarFixture.newOak((NodeStore)SegmentNodeStoreBuilders.builder((FileStore)this.stores[i]).build());
            if (blobStore == null) continue;
            cluster[i].getWhiteboard().register(BlobAccessProvider.class, (Object)((BlobAccessProvider)blobStore), Collections.EMPTY_MAP);
        }
        return cluster;
    }

    private void attachStandby(int i, int n, StatisticsProvider statsProvider, BlobStore blobStore) throws InvalidFileStoreVersionException, IOException {
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder((File)new File(this.parentPath, "standby-" + i));
        if (this.useBlobStore) {
            if (this.shareBlobStore) {
                builder.withBlobStore(blobStore);
            } else {
                this.blobStoreFixtures[n + i] = BlobStoreFixture.create(this.parentPath, true, this.dsCacheSize, statsProvider);
                builder.withBlobStore(this.blobStoreFixtures[n + i].setUp());
            }
        }
        SegmentGCOptions gcOptions = SegmentGCOptions.defaultGCOptions().setRetainedGenerations(1);
        this.stores[n + i] = builder.withGCOptions(gcOptions).withMaxFileSize(this.maxFileSize).withStatisticsProvider(statsProvider).withSegmentCacheSize(this.segmentCacheSize).withMemoryMapping(this.memoryMapping).withSnfeListener(this.IGNORE_SNFE).build();
        int port = 0;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
        }
        this.serverSyncs[i] = StandbyServerSync.builder().withPort(port).withFileStore(this.stores[i]).withBlobChunkSize(0x100000).withSecureConnection(this.secure).build();
        this.clientSyncs[i] = new StandbyClientSync("127.0.0.1", port, this.stores[n + i], this.secure, 60000, false, new File(StandardSystemProperty.JAVA_IO_TMPDIR.value()));
        if (!this.oneShotRun) {
            this.serverSyncs[i].start();
            this.clientSyncs[i].start();
            this.executors[i] = Executors.newScheduledThreadPool(1);
            this.executors[i].scheduleAtFixedRate((Runnable)this.clientSyncs[i], 0L, this.syncInterval, TimeUnit.SECONDS);
        }
    }

    private void init(int n) {
        int fileStoresLength = n;
        int blobStoresLength = 0;
        if (this.withColdStandby) {
            fileStoresLength = 2 * n;
            if (this.useBlobStore) {
                blobStoresLength = this.shareBlobStore ? n : 2 * n;
            }
            this.serverSyncs = new StandbyServerSync[n];
            this.clientSyncs = new StandbyClientSync[n];
            if (!this.oneShotRun) {
                this.executors = new ScheduledExecutorService[n];
            }
        } else if (this.useBlobStore) {
            blobStoresLength = n;
        }
        this.stores = new FileStore[fileStoresLength];
        this.blobStoreFixtures = new BlobStoreFixture[blobStoresLength];
        if (this.azureConnectionString != null) {
            this.containers = new CloudBlobContainer[n];
        }
    }

    @Override
    public void tearDownCluster() {
        if (this.withColdStandby) {
            for (StandbyClientSync standbyClientSync : this.clientSyncs) {
                standbyClientSync.close();
            }
            for (StandbyServerSync standbyServerSync : this.serverSyncs) {
                standbyServerSync.close();
            }
            if (!this.oneShotRun) {
                for (ScheduledExecutorService scheduledExecutorService : this.executors) {
                    scheduledExecutorService.shutdownNow();
                }
            }
        }
        for (FileStore fileStore : this.stores) {
            fileStore.close();
        }
        if (this.blobStoreFixtures != null) {
            for (BlobStoreFixture blobStoreFixture : this.blobStoreFixtures) {
                blobStoreFixture.tearDown();
            }
        }
        if (this.containers != null) {
            for (CloudBlobContainer cloudBlobContainer : this.containers) {
                if (cloudBlobContainer == null) continue;
                try {
                    cloudBlobContainer.deleteIfExists();
                }
                catch (StorageException e) {
                    log.error("Can't remove container", (Throwable)e);
                }
            }
        }
        FileUtils.deleteQuietly((File)this.parentPath);
    }

    public BlobStoreFixture[] getBlobStoreFixtures() {
        return this.blobStoreFixtures;
    }

    public FileStore[] getStores() {
        return this.stores;
    }

    public StandbyServerSync[] getServerSyncs() {
        return this.serverSyncs;
    }

    public StandbyClientSync[] getClientSyncs() {
        return this.clientSyncs;
    }

    static class SegmentTarFixtureBuilder {
        private final String name;
        private final File base;
        private int maxFileSize;
        private int segmentCacheSize;
        private boolean memoryMapping;
        private boolean useBlobStore;
        private int dsCacheSize;
        private String awsBucketName;
        private String awsRootPath;
        private String awsJournalTableName;
        private String awsLockTableName;
        private String azureConnectionString;
        private String azureContainerName;
        private String azureRootPath;

        public static SegmentTarFixtureBuilder segmentTarFixtureBuilder(String name, File directory) {
            return new SegmentTarFixtureBuilder(name, directory);
        }

        private SegmentTarFixtureBuilder(String name, File base) {
            this.name = name;
            this.base = base;
        }

        public SegmentTarFixtureBuilder withMaxFileSize(int maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public SegmentTarFixtureBuilder withSegmentCacheSize(int segmentCacheSize) {
            this.segmentCacheSize = segmentCacheSize;
            return this;
        }

        public SegmentTarFixtureBuilder withMemoryMapping(boolean memoryMapping) {
            this.memoryMapping = memoryMapping;
            return this;
        }

        public SegmentTarFixtureBuilder withBlobStore(boolean useBlobStore) {
            this.useBlobStore = useBlobStore;
            return this;
        }

        public SegmentTarFixtureBuilder withDSCacheSize(int dsCacheSize) {
            this.dsCacheSize = dsCacheSize;
            return this;
        }

        public SegmentTarFixtureBuilder withAws(String awsBucketName, String awsRootPath, String awsJournalTableName, String awsLockTableName) {
            this.awsBucketName = awsBucketName;
            this.awsRootPath = awsRootPath;
            this.awsJournalTableName = awsJournalTableName;
            this.awsLockTableName = awsLockTableName;
            return this;
        }

        public SegmentTarFixtureBuilder withAzure(String azureConnectionString, String azureContainerName, String azureRootPath) {
            this.azureConnectionString = azureConnectionString;
            this.azureContainerName = azureContainerName;
            this.azureRootPath = azureRootPath;
            return this;
        }

        public SegmentTarFixture build() {
            return new SegmentTarFixture(this);
        }
    }
}

