/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.commons;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

public class Utils {
    private Utils() {
    }

    public static String getProductInfo(InputStream pom) {
        String version = Utils.getProductVersion(pom);
        if (version == null) {
            return "Apache Jackrabbit Oak";
        }
        return "Apache Jackrabbit Oak " + version;
    }

    public static String getProductVersion(InputStream pom) {
        if (pom == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(pom);
        }
        catch (IOException e) {
            return null;
        }
        return properties.getProperty("version");
    }

    public static void printProductInfo(String[] args, InputStream pom) {
        if (!Arrays.asList(args).contains("--quiet")) {
            System.out.println(Utils.getProductInfo(pom));
        }
    }
}

