/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import java.util.Collections;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.jackrabbit.oak.run.cli.OptionsBean;

public class RDBStoreOptions
implements OptionsBean {
    private final OptionSpec<String> rdbjdbcuser;
    private final OptionSpec<String> rdbjdbcpasswd;
    private OptionSet options;

    public RDBStoreOptions(OptionParser parser) {
        this.rdbjdbcuser = parser.accepts("rdbjdbcuser", "RDB JDBC user").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        this.rdbjdbcpasswd = parser.accepts("rdbjdbcpasswd", "RDB JDBC password").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
    }

    @Override
    public void configure(OptionSet options) {
        this.options = options;
    }

    @Override
    public String title() {
        return "RDBDocumentStore Options";
    }

    @Override
    public int order() {
        return 15;
    }

    @Override
    public String description() {
        return "Options related to configuring a RDBDocumentStore for DocumentNodeStore based setups.";
    }

    @Override
    public Set<String> operationNames() {
        return Collections.emptySet();
    }

    public String getUser() {
        return (String)this.rdbjdbcuser.value(this.options);
    }

    public String getPassword() {
        return (String)this.rdbjdbcpasswd.value(this.options);
    }
}

