/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import java.util.Collections;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.jackrabbit.oak.run.cli.OptionsBean;

public class DocumentNodeStoreOptions
implements OptionsBean {
    private final OptionSpec<Integer> clusterId;
    private final OptionSpec<Void> disableBranchesSpec;
    private final OptionSpec<Integer> cacheSizeSpec;
    private final OptionSpec<Integer> nodeCachePercentage;
    private final OptionSpec<Integer> prevDocCachePercentage;
    private final OptionSpec<Integer> childrenCachePercentage;
    private final OptionSpec<Integer> diffCachePercentage;
    private OptionSet options;

    public DocumentNodeStoreOptions(OptionParser parser) {
        this.clusterId = parser.accepts("clusterId", "Cluster node instance id").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
        this.disableBranchesSpec = parser.accepts("disableBranches", "Disable branches");
        this.cacheSizeSpec = parser.accepts("cacheSize", "The cache size").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
        this.nodeCachePercentage = parser.accepts("nodeCachePercentage", "Percentage of cache to be allocated towards Node cache").withRequiredArg().ofType(Integer.class).defaultsTo((Object)35, (Object[])new Integer[0]);
        this.prevDocCachePercentage = parser.accepts("prevDocCachePercentage", "Percentage of cache to be allocated towards Previous Document cache").withRequiredArg().ofType(Integer.class).defaultsTo((Object)4, (Object[])new Integer[0]);
        this.childrenCachePercentage = parser.accepts("childrenCachePercentage", "Percentage of cache to be allocated towards Children cache").withRequiredArg().ofType(Integer.class).defaultsTo((Object)15, (Object[])new Integer[0]);
        this.diffCachePercentage = parser.accepts("diffCachePercentage", "Percentage of cache to be allocated towards Diff cache").withRequiredArg().ofType(Integer.class).defaultsTo((Object)30, (Object[])new Integer[0]);
    }

    @Override
    public void configure(OptionSet options) {
        this.options = options;
    }

    @Override
    public String title() {
        return "DocumentNodeStore Options";
    }

    @Override
    public String description() {
        return "Options related to constructing a DocumentNodeStore. \nNote that left over of sum of all cache ratio defined is allocated to documentCache.";
    }

    @Override
    public int order() {
        return 20;
    }

    @Override
    public Set<String> operationNames() {
        return Collections.emptySet();
    }

    public int getClusterId() {
        return (Integer)this.clusterId.value(this.options);
    }

    public int getCacheSize() {
        return (Integer)this.cacheSizeSpec.value(this.options);
    }

    public boolean disableBranchesSpec() {
        return this.options.has(this.disableBranchesSpec);
    }

    public int getNodeCachePercentage() {
        return (Integer)this.nodeCachePercentage.value(this.options);
    }

    public int getPrevDocCachePercentage() {
        return (Integer)this.prevDocCachePercentage.value(this.options);
    }

    public int getChildrenCachePercentage() {
        return (Integer)this.childrenCachePercentage.value(this.options);
    }

    public int getDiffCachePercentage() {
        return (Integer)this.diffCachePercentage.value(this.options);
    }

    public boolean isCacheDistributionDefined() {
        return this.options.has(this.nodeCachePercentage) || this.options.has(this.prevDocCachePercentage) || this.options.has(this.childrenCachePercentage) || this.options.has(this.diffCachePercentage);
    }
}

