/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import java.io.File;
import java.io.InputStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.jcr.Repository;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.xml.sax.InputSource;

public class JackrabbitRepositoryFixture
implements RepositoryFixture {
    private final File base;
    private final int bundleCacheSize;
    private RepositoryImpl[] cluster;

    public JackrabbitRepositoryFixture(File base, int bundleCacheSize) {
        this.base = base;
        this.bundleCacheSize = bundleCacheSize;
    }

    @Override
    public boolean isAvailable(int n) {
        return n == 1;
    }

    @Override
    public Repository[] setUpCluster(int n) throws Exception {
        if (n == 1) {
            String name = "Jackrabbit-" + System.currentTimeMillis();
            File directory = new File(this.base, name);
            Properties variables = new Properties(System.getProperties());
            variables.setProperty("rep.home", directory.getPath());
            variables.setProperty("bundleCacheSize", Integer.toString(this.bundleCacheSize));
            InputStream xml = this.getClass().getResourceAsStream("repository.xml");
            RepositoryConfig config = RepositoryConfig.create((InputSource)new InputSource(xml), (Properties)variables);
            System.setProperty("derby.stream.error.file", new File(directory, "derby.log").getPath());
            RepositoryImpl repository = RepositoryImpl.create((RepositoryConfig)config);
            this.cluster = new RepositoryImpl[]{repository};
            return new Repository[]{repository};
        }
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void syncRepositoryCluster(Repository ... nodes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void tearDownCluster() {
        for (RepositoryImpl repository : this.cluster) {
            File directory = new File(repository.getConfig().getHomeDir());
            repository.shutdown();
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            FileUtils.deleteQuietly((File)directory);
        }
    }

    public String toString() {
        return "Jackrabbit";
    }
}

