/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.codecs.lucene46.Lucene46Codec;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.sorter.Sorter;
import org.apache.lucene.index.sorter.SortingAtomicReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;

public class AnalyzingInfixSuggester
extends Lookup
implements Closeable {
    protected static final String TEXT_FIELD_NAME = "text";
    protected final Analyzer queryAnalyzer;
    protected final Analyzer indexAnalyzer;
    final Version matchVersion;
    private final File indexPath;
    final int minPrefixChars;
    private Directory dir;
    private long count = 0L;
    protected IndexSearcher searcher;
    protected BinaryDocValues payloadsDV;
    protected BinaryDocValues textDV;
    protected NumericDocValues weightsDV;
    public static final int DEFAULT_MIN_PREFIX_CHARS = 4;

    public AnalyzingInfixSuggester(Version matchVersion, File indexPath, Analyzer analyzer) throws IOException {
        this(matchVersion, indexPath, analyzer, analyzer, 4);
    }

    public AnalyzingInfixSuggester(Version matchVersion, File indexPath, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars) throws IOException {
        if (minPrefixChars < 0) {
            throw new IllegalArgumentException("minPrefixChars must be >= 0; got: " + minPrefixChars);
        }
        this.queryAnalyzer = queryAnalyzer;
        this.indexAnalyzer = indexAnalyzer;
        this.matchVersion = matchVersion;
        this.indexPath = indexPath;
        this.minPrefixChars = minPrefixChars;
        this.dir = this.getDirectory(indexPath);
        if (DirectoryReader.indexExists(this.dir)) {
            DirectoryReader reader = DirectoryReader.open(this.dir);
            this.searcher = new IndexSearcher(reader);
            this.payloadsDV = MultiDocValues.getBinaryValues(this.searcher.getIndexReader(), "payloads");
            this.weightsDV = MultiDocValues.getNumericValues(this.searcher.getIndexReader(), "weight");
            this.textDV = MultiDocValues.getBinaryValues(this.searcher.getIndexReader(), TEXT_FIELD_NAME);
            this.count = ((IndexReader)reader).numDocs();
            assert (this.textDV != null);
        }
    }

    protected IndexWriterConfig getIndexWriterConfig(Version matchVersion, Analyzer indexAnalyzer) {
        IndexWriterConfig iwc = new IndexWriterConfig(matchVersion, indexAnalyzer);
        iwc.setCodec(new Lucene46Codec());
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        return iwc;
    }

    protected Directory getDirectory(File path) throws IOException {
        return FSDirectory.open(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(InputIterator iter) throws IOException {
        block11: {
            AtomicReader r;
            IndexWriter w2;
            IndexWriter w;
            Directory dirTmp;
            block10: {
                if (this.searcher != null) {
                    this.searcher.getIndexReader().close();
                    this.searcher = null;
                }
                dirTmp = this.getDirectory(new File(this.indexPath.toString() + ".tmp"));
                w = null;
                w2 = null;
                r = null;
                boolean success = false;
                this.count = 0L;
                try {
                    BytesRef text;
                    BinaryDocValuesField payloadField;
                    AnalyzerWrapper gramAnalyzer = new AnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

                        @Override
                        protected Analyzer getWrappedAnalyzer(String fieldName) {
                            return AnalyzingInfixSuggester.this.indexAnalyzer;
                        }

                        @Override
                        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                            if (fieldName.equals("textgrams") && AnalyzingInfixSuggester.this.minPrefixChars > 0) {
                                return new Analyzer.TokenStreamComponents(components.getTokenizer(), new EdgeNGramTokenFilter(AnalyzingInfixSuggester.this.matchVersion, components.getTokenStream(), 1, AnalyzingInfixSuggester.this.minPrefixChars));
                            }
                            return components;
                        }
                    };
                    w = new IndexWriter(dirTmp, this.getIndexWriterConfig(this.matchVersion, gramAnalyzer));
                    Document doc = new Document();
                    FieldType ft = this.getTextFieldType();
                    Field textField = new Field(TEXT_FIELD_NAME, "", ft);
                    doc.add(textField);
                    Field textGramField = new Field("textgrams", "", ft);
                    doc.add(textGramField);
                    BinaryDocValuesField textDVField = new BinaryDocValuesField(TEXT_FIELD_NAME, new BytesRef());
                    doc.add(textDVField);
                    NumericDocValuesField weightField = new NumericDocValuesField("weight", 0L);
                    doc.add(weightField);
                    if (iter.hasPayloads()) {
                        payloadField = new BinaryDocValuesField("payloads", new BytesRef());
                        doc.add(payloadField);
                    } else {
                        payloadField = null;
                    }
                    while ((text = iter.next()) != null) {
                        String textString = text.utf8ToString();
                        textField.setStringValue(textString);
                        textGramField.setStringValue(textString);
                        textDVField.setBytesValue(text);
                        weightField.setLongValue(iter.weight());
                        if (iter.hasPayloads()) {
                            payloadField.setBytesValue(iter.payload());
                        }
                        w.addDocument(doc);
                        ++this.count;
                    }
                    r = SlowCompositeReaderWrapper.wrap(DirectoryReader.open(w, false));
                    w.rollback();
                    final int maxDoc = r.maxDoc();
                    final NumericDocValues weights = r.getNumericDocValues("weight");
                    final Sorter.DocComparator comparator = new Sorter.DocComparator(){

                        public int compare(int docID1, int docID2) {
                            long v2;
                            long v1 = weights.get(docID1);
                            if (v1 > (v2 = weights.get(docID2))) {
                                return -1;
                            }
                            if (v1 < v2) {
                                return 1;
                            }
                            return 0;
                        }
                    };
                    r = SortingAtomicReader.wrap((AtomicReader)r, (Sorter)new Sorter(){

                        public Sorter.DocMap sort(AtomicReader reader) throws IOException {
                            return Sorter.sort((int)maxDoc, (Sorter.DocComparator)comparator);
                        }

                        public String getID() {
                            return "Weight";
                        }
                    });
                    w2 = new IndexWriter(this.dir, this.getIndexWriterConfig(this.matchVersion, this.indexAnalyzer));
                    w2.addIndexes(r);
                    r.close();
                    this.searcher = new IndexSearcher(DirectoryReader.open(w2, false));
                    w2.close();
                    this.payloadsDV = MultiDocValues.getBinaryValues(this.searcher.getIndexReader(), "payloads");
                    this.weightsDV = MultiDocValues.getNumericValues(this.searcher.getIndexReader(), "weight");
                    this.textDV = MultiDocValues.getBinaryValues(this.searcher.getIndexReader(), TEXT_FIELD_NAME);
                    assert (this.textDV != null);
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(w, w2, r, dirTmp);
                    } else {
                        IOUtils.closeWhileHandlingException(w, w2, r, dirTmp);
                    }
                    throw throwable;
                }
                IOUtils.close(w, w2, r, dirTmp);
                break block11;
            }
            IOUtils.closeWhileHandlingException(w, w2, r, dirTmp);
        }
    }

    protected FieldType getTextFieldType() {
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        ft.setOmitNorms(true);
        return ft;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        return this.lookup(key, num, true, true);
    }

    protected Query getLastTokenQuery(String token) throws IOException {
        if (token.length() < this.minPrefixChars) {
            return new TermQuery(new Term("textgrams", token));
        }
        return new PrefixQuery(new Term(TEXT_FIELD_NAME, token));
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, int num, boolean allTermsRequired, boolean doHighlight) {
        List<Lookup.LookupResult> list;
        if (this.searcher == null) {
            throw new IllegalStateException("suggester was not built");
        }
        BooleanClause.Occur occur = allTermsRequired ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        TokenStream ts = null;
        try {
            List<Lookup.LookupResult> results;
            ts = this.queryAnalyzer.tokenStream("", new StringReader(((Object)key).toString()));
            ts.reset();
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = ts.addAttribute(OffsetAttribute.class);
            String lastToken = null;
            BooleanQuery query = new BooleanQuery();
            int maxEndOffset = -1;
            HashSet<String> matchedTokens = new HashSet<String>();
            while (ts.incrementToken()) {
                if (lastToken != null) {
                    matchedTokens.add(lastToken);
                    query.add(new TermQuery(new Term(TEXT_FIELD_NAME, lastToken)), occur);
                }
                if ((lastToken = termAtt.toString()) == null) continue;
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
            }
            ts.end();
            String prefixToken = null;
            if (lastToken != null) {
                Query lastQuery;
                if (maxEndOffset == offsetAtt.endOffset()) {
                    lastQuery = this.getLastTokenQuery(lastToken);
                    prefixToken = lastToken;
                } else {
                    matchedTokens.add(lastToken);
                    lastQuery = new TermQuery(new Term(TEXT_FIELD_NAME, lastToken));
                }
                if (lastQuery != null) {
                    query.add(lastQuery, occur);
                }
            }
            ts.close();
            Query finalQuery = this.finishQuery(query, allTermsRequired);
            FirstNDocsCollector c = new FirstNDocsCollector(num);
            try {
                this.searcher.search(finalQuery, c);
            }
            catch (FirstNDocsCollector.DoneException done) {
                // empty catch block
            }
            TopDocs hits = c.getHits();
            list = results = this.createResults(hits, num, key, doHighlight, matchedTokens, prefixToken);
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(ts);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(ts);
        return list;
    }

    protected List<Lookup.LookupResult> createResults(TopDocs hits, int num, CharSequence charSequence, boolean doHighlight, Set<String> matchedTokens, String prefixToken) throws IOException {
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Lookup.LookupResult result;
            BytesRef payload;
            ScoreDoc sd = hits.scoreDocs[i];
            this.textDV.get(sd.doc, scratch);
            String text = scratch.utf8ToString();
            long score = this.weightsDV.get(sd.doc);
            if (this.payloadsDV != null) {
                payload = new BytesRef();
                this.payloadsDV.get(sd.doc, payload);
            } else {
                payload = null;
            }
            if (doHighlight) {
                Object highlightKey = this.highlight(text, matchedTokens, prefixToken);
                result = new Lookup.LookupResult(highlightKey.toString(), highlightKey, score, payload);
            } else {
                result = new Lookup.LookupResult(text, score, payload);
            }
            results.add(result);
        }
        return results;
    }

    protected Query finishQuery(BooleanQuery in, boolean allTermsRequired) {
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object highlight(String text, Set<String> matchedTokens, String prefixToken) throws IOException {
        String string;
        TokenStream ts = this.queryAnalyzer.tokenStream(TEXT_FIELD_NAME, new StringReader(text));
        try {
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = ts.addAttribute(OffsetAttribute.class);
            ts.reset();
            StringBuilder sb = new StringBuilder();
            int upto = 0;
            while (ts.incrementToken()) {
                String token = termAtt.toString();
                int startOffset = offsetAtt.startOffset();
                int endOffset = offsetAtt.endOffset();
                if (upto < startOffset) {
                    this.addNonMatch(sb, text.substring(upto, startOffset));
                    upto = startOffset;
                } else if (upto > startOffset) continue;
                if (matchedTokens.contains(token)) {
                    this.addWholeMatch(sb, text.substring(startOffset, endOffset), token);
                    upto = endOffset;
                    continue;
                }
                if (prefixToken == null || !token.startsWith(prefixToken)) continue;
                this.addPrefixMatch(sb, text.substring(startOffset, endOffset), token, prefixToken);
                upto = endOffset;
            }
            ts.end();
            int endOffset = offsetAtt.endOffset();
            if (upto < endOffset) {
                this.addNonMatch(sb, text.substring(upto));
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(ts);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(ts);
        return string;
    }

    protected void addNonMatch(StringBuilder sb, String text) {
        sb.append(text);
    }

    protected void addWholeMatch(StringBuilder sb, String surface, String analyzed) {
        sb.append("<b>");
        sb.append(surface);
        sb.append("</b>");
    }

    protected void addPrefixMatch(StringBuilder sb, String surface, String analyzed, String prefixToken) {
        sb.append("<b>");
        sb.append(surface.substring(0, prefixToken.length()));
        sb.append("</b>");
        if (prefixToken.length() < surface.length()) {
            sb.append(surface.substring(prefixToken.length()));
        }
    }

    @Override
    public boolean store(DataOutput in) throws IOException {
        return false;
    }

    @Override
    public boolean load(DataInput out) throws IOException {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.searcher != null) {
            this.searcher.getIndexReader().close();
            this.searcher = null;
        }
        if (this.dir != null) {
            this.dir.close();
            this.dir = null;
        }
    }

    @Override
    public long sizeInBytes() {
        return RamUsageEstimator.sizeOf(this);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    private static class FirstNDocsCollector
    extends Collector {
        private int docBase;
        private final int[] hits;
        private int hitCount;

        public TopDocs getHits() {
            ScoreDoc[] scoreDocs = new ScoreDoc[this.hitCount];
            for (int i = 0; i < this.hitCount; ++i) {
                scoreDocs[i] = new ScoreDoc(this.hits[i], Float.NaN);
            }
            return new TopDocs(this.hitCount, scoreDocs, Float.NaN);
        }

        public FirstNDocsCollector(int topN) {
            this.hits = new int[topN];
        }

        @Override
        public void collect(int doc) {
            this.hits[this.hitCount++] = doc;
            if (this.hitCount == this.hits.length) {
                throw new DoneException();
            }
        }

        @Override
        public void setScorer(Scorer scorer) {
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        @Override
        public void setNextReader(AtomicReaderContext cxt) {
            this.docBase = cxt.docBase;
        }

        private static class DoneException
        extends RuntimeException {
            private DoneException() {
            }
        }
    }
}

