/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.io.Reader;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;

public final class TokenizerChain
extends Analyzer {
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] filters;

    public TokenizerChain(TokenizerFactory tokenizer) {
        this(null, tokenizer, null);
    }

    public TokenizerChain(TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this(null, tokenizer, filters);
    }

    public TokenizerChain(CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this.charFilters = charFilters;
        this.tokenizer = tokenizer;
        this.filters = filters == null ? new TokenFilterFactory[]{} : filters;
    }

    @Override
    public Reader initReader(String fieldName, Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            Reader cs = reader;
            for (CharFilterFactory charFilter : this.charFilters) {
                cs = charFilter.create(cs);
            }
            reader = cs;
        }
        return reader;
    }

    public CharFilterFactory[] getCharFilters() {
        return Arrays.copyOf(this.charFilters, this.charFilters.length);
    }

    public TokenizerFactory getTokenizer() {
        return this.tokenizer;
    }

    public TokenFilterFactory[] getFilters() {
        return Arrays.copyOf(this.filters, this.filters.length);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        Tokenizer tk;
        TokenStream ts = tk = this.tokenizer.create(reader);
        for (TokenFilterFactory filter : this.filters) {
            ts = filter.create(ts);
        }
        return new Analyzer.TokenStreamComponents(tk, ts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TokenizerChain(");
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory);
            sb.append(", ");
        }
        sb.append(this.tokenizer);
        for (AbstractAnalysisFactory abstractAnalysisFactory : this.filters) {
            sb.append(", ");
            sb.append(abstractAnalysisFactory);
        }
        sb.append(')');
        return sb.toString();
    }
}

