/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.CRTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.suggest.DocumentDictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.FreeTextSuggester;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestHelper {
    private static final Logger log = LoggerFactory.getLogger(SuggestHelper.class);
    private static final Analyzer analyzer = new Analyzer(){

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            return new Analyzer.TokenStreamComponents(new CRTokenizer(Version.LUCENE_47, reader));
        }
    };
    private static final Lookup suggester = new FreeTextSuggester(analyzer);

    public static void updateSuggester(IndexReader reader) throws IOException {
        try {
            suggester.build(new DocumentDictionary(reader, ":suggest", ":depth"));
        }
        catch (RuntimeException e) {
            log.debug("could not update the suggester", (Throwable)e);
        }
    }

    public static List<Lookup.LookupResult> getSuggestions(SuggestQuery suggestQuery) {
        try {
            long count = suggester.getCount();
            if (count > 0L) {
                return suggester.lookup(suggestQuery.getText(), false, 10);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException("could not handle Suggest query " + suggestQuery, e);
        }
    }

    public static SuggestQuery getSuggestQuery(String suggestQueryString) {
        try {
            String text = null;
            for (String param : suggestQueryString.split("&")) {
                String[] keyValuePair = param.split("=");
                if (keyValuePair.length != 2 || keyValuePair[0] == null || keyValuePair[1] == null) {
                    throw new RuntimeException("Unparsable native Lucene Suggest query: " + suggestQueryString);
                }
                if (!"term".equals(keyValuePair[0])) continue;
                text = keyValuePair[1];
            }
            if (text != null) {
                return new SuggestQuery(text);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("could not build SuggestQuery " + suggestQueryString, e);
        }
    }

    public static class SuggestQuery {
        private final String text;

        public SuggestQuery(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "SuggestQuery{text='" + this.text + '\'' + '}';
        }
    }
}

