/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexPlanner;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexLookup;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneRequestFacade;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.SizeEstimator;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.score.ScorerProviderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.MoreLikeThisHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SpellcheckHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.CustomScoreQuery;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePropertyIndex
implements QueryIndex.AdvancedQueryIndex,
QueryIndex,
QueryIndex.NativeQueryIndex,
QueryIndex.AdvanceFulltextQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(LucenePropertyIndex.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(LucenePropertyIndex.class.getName() + ".perf")));
    static final String ATTR_PLAN_RESULT = "oak.lucene.planResult";
    static final int LUCENE_QUERY_BATCH_SIZE = 50;
    protected final IndexTracker tracker;
    private final ScorerProviderFactory scorerProviderFactory;

    public LucenePropertyIndex(IndexTracker tracker) {
        this.tracker = tracker;
        this.scorerProviderFactory = ScorerProviderFactory.DEFAULT;
    }

    public LucenePropertyIndex(IndexTracker tracker, ScorerProviderFactory factory) {
        this.tracker = tracker;
        this.scorerProviderFactory = factory;
    }

    public String getIndexName() {
        return "lucene-property";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        Collection<String> indexPaths = new LuceneIndexLookup(rootState).collectIndexNodePaths(filter);
        ArrayList plans = Lists.newArrayListWithCapacity((int)indexPaths.size());
        IndexNode indexNode = null;
        for (String path : indexPaths) {
            try {
                QueryIndex.IndexPlan plan;
                indexNode = this.tracker.acquireIndexNode(path);
                if (indexNode == null || (plan = new IndexPlanner(indexNode, path, filter, sortOrder).getPlan()) == null) continue;
                plans.add(plan);
            }
            finally {
                if (indexNode == null) continue;
                indexNode.release();
            }
        }
        return plans;
    }

    public double getCost(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    public String getPlan(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        Filter filter = plan.getFilter();
        IndexNode index = this.tracker.acquireIndexNode(LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
        Preconditions.checkState((index != null ? 1 : 0) != 0, (Object)"The Lucene index is not available");
        try {
            FullTextExpression ft = filter.getFullTextConstraint();
            StringBuilder sb = new StringBuilder("lucene:");
            String path = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath;
            sb.append(LucenePropertyIndex.getIndexName(plan)).append("(").append(path).append(") ");
            sb.append(LucenePropertyIndex.getLuceneRequest(plan, null));
            if (plan.getSortOrder() != null && !plan.getSortOrder().isEmpty()) {
                sb.append(" ordering:").append(plan.getSortOrder());
            }
            if (ft != null) {
                sb.append(" ft:(").append(ft).append(")");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            index.release();
        }
    }

    public Cursor query(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    public Cursor query(final QueryIndex.IndexPlan plan, NodeState rootState) {
        final Filter filter = plan.getFilter();
        final Sort sort = LucenePropertyIndex.getSort(plan);
        final IndexPlanner.PlanResult pr = LucenePropertyIndex.getPlanResult(plan);
        QueryEngineSettings settings = filter.getQueryEngineSettings();
        AbstractIterator<LuceneResultRow> itr = new AbstractIterator<LuceneResultRow>(){
            private final Deque<LuceneResultRow> queue = Queues.newArrayDeque();
            private final Set<String> seenPaths = Sets.newHashSet();
            private ScoreDoc lastDoc;
            private int nextBatchSize = 50;
            private boolean noDocs = false;
            private long lastSearchIndexerVersion;

            protected LuceneResultRow computeNext() {
                if (!this.queue.isEmpty() || this.loadDocs()) {
                    return this.queue.remove();
                }
                return (LuceneResultRow)this.endOfData();
            }

            private LuceneResultRow convertToRow(ScoreDoc doc, IndexSearcher searcher) throws IOException {
                IndexReader reader = searcher.getIndexReader();
                PathStoredFieldVisitor visitor = new PathStoredFieldVisitor();
                reader.document(doc.doc, visitor);
                String path = visitor.getPath();
                if (path != null) {
                    if ("".equals(path)) {
                        path = "/";
                    }
                    if (pr.isPathTransformed()) {
                        String originalPath = path;
                        if ((path = pr.transformPath(path)) == null) {
                            LOG.trace("Ignoring path {} : Transformation returned null", (Object)originalPath);
                            return null;
                        }
                        if (this.seenPaths.contains(path)) {
                            LOG.trace("Ignoring path {} : Duplicate post transformation", (Object)originalPath);
                            return null;
                        }
                        this.seenPaths.add(path);
                    }
                    LOG.trace("Matched path {}", (Object)path);
                    return new LuceneResultRow(path, doc.score);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadDocs() {
                if (this.noDocs) {
                    return false;
                }
                ScoreDoc lastDocToRecord = null;
                IndexNode indexNode = LucenePropertyIndex.this.acquireIndexNode(plan);
                Preconditions.checkState((indexNode != null ? 1 : 0) != 0);
                try {
                    IndexSearcher searcher = indexNode.getSearcher();
                    LuceneRequestFacade luceneRequestFacade = LucenePropertyIndex.getLuceneRequest(plan, searcher.getIndexReader());
                    if (luceneRequestFacade.getLuceneRequest() instanceof Query) {
                        Query query = (Query)luceneRequestFacade.getLuceneRequest();
                        CustomScoreQuery customScoreQuery = LucenePropertyIndex.this.getCustomScoreQuery(plan, query);
                        if (customScoreQuery != null) {
                            query = customScoreQuery;
                        }
                        this.checkForIndexVersionChange(searcher);
                        long start = PERF_LOGGER.start();
                        while (true) {
                            TopDocs docs;
                            if (this.lastDoc != null) {
                                LOG.debug("loading the next {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                                docs = sort == null ? searcher.searchAfter(this.lastDoc, query, this.nextBatchSize) : searcher.searchAfter(this.lastDoc, query, this.nextBatchSize, sort);
                            } else {
                                LOG.debug("loading the first {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                                docs = sort == null ? searcher.search(query, this.nextBatchSize) : searcher.search(query, this.nextBatchSize, sort);
                            }
                            PERF_LOGGER.end(start, -1L, "{} ...", (Object)docs.scoreDocs.length);
                            this.nextBatchSize = (int)Math.min((long)this.nextBatchSize * 2L, 100000L);
                            for (ScoreDoc doc : docs.scoreDocs) {
                                LuceneResultRow row = this.convertToRow(doc, searcher);
                                if (row != null) {
                                    this.queue.add(row);
                                }
                                lastDocToRecord = doc;
                            }
                            if (this.queue.isEmpty() && docs.scoreDocs.length > 0) {
                                this.lastDoc = lastDocToRecord;
                                continue;
                            }
                            break;
                        }
                    } else if (luceneRequestFacade.getLuceneRequest() instanceof SpellcheckHelper.SpellcheckQuery) {
                        SpellcheckHelper.SpellcheckQuery spellcheckQuery = (SpellcheckHelper.SpellcheckQuery)luceneRequestFacade.getLuceneRequest();
                        SuggestWord[] suggestWords = SpellcheckHelper.getSpellcheck(spellcheckQuery);
                        ArrayList<String> suggestedWords = new ArrayList<String>(suggestWords.length);
                        QueryParser qp = new QueryParser(Version.LUCENE_47, ":fulltext", indexNode.getDefinition().getAnalyzer());
                        block7: for (SuggestWord suggestion : suggestWords) {
                            Query query = qp.createPhraseQuery(":fulltext", suggestion.string);
                            TopDocs topDocs = searcher.search(query, 100);
                            if (topDocs.totalHits <= 0) continue;
                            for (ScoreDoc doc : topDocs.scoreDocs) {
                                Document retrievedDoc = searcher.doc(doc.doc);
                                if (!filter.isAccessible(retrievedDoc.get(":path"))) continue;
                                suggestedWords.add(suggestion.string);
                                continue block7;
                            }
                        }
                        this.queue.add(new LuceneResultRow(suggestedWords));
                        this.noDocs = true;
                    } else if (luceneRequestFacade.getLuceneRequest() instanceof SuggestHelper.SuggestQuery) {
                        SuggestHelper.SuggestQuery suggestQuery = (SuggestHelper.SuggestQuery)luceneRequestFacade.getLuceneRequest();
                        List<Lookup.LookupResult> lookupResults = SuggestHelper.getSuggestions(suggestQuery);
                        ArrayList<String> suggestedWords = new ArrayList<String>(lookupResults.size());
                        QueryParser qp = new QueryParser(Version.LUCENE_47, ":suggest", indexNode.getDefinition().getAnalyzer());
                        block9: for (Lookup.LookupResult suggestion : lookupResults) {
                            Query query = qp.createPhraseQuery(":suggest", suggestion.key.toString());
                            TopDocs topDocs = searcher.search(query, 100);
                            if (topDocs.totalHits <= 0) continue;
                            for (ScoreDoc doc : topDocs.scoreDocs) {
                                Document retrievedDoc = searcher.doc(doc.doc);
                                if (!filter.isAccessible(retrievedDoc.get(":path"))) continue;
                                suggestedWords.add("{term=" + suggestion.key + ",weight=" + suggestion.value + "}");
                                continue block9;
                            }
                        }
                        this.queue.add(new LuceneResultRow(suggestedWords));
                        this.noDocs = true;
                    }
                }
                catch (IOException e) {
                    LOG.warn("query via {} failed.", (Object)LucenePropertyIndex.this, (Object)e);
                }
                finally {
                    indexNode.release();
                }
                if (lastDocToRecord != null) {
                    this.lastDoc = lastDocToRecord;
                }
                return !this.queue.isEmpty();
            }

            private void checkForIndexVersionChange(IndexSearcher searcher) {
                long currentVersion = LucenePropertyIndex.getVersion(searcher);
                if (currentVersion != this.lastSearchIndexerVersion && this.lastDoc != null) {
                    this.lastDoc = null;
                    LOG.debug("Change in index version detected {} => {}. Query would be performed without offset", (Object)currentVersion, (Object)this.lastSearchIndexerVersion);
                }
                this.lastSearchIndexerVersion = currentVersion;
            }
        };
        SizeEstimator sizeEstimator = new SizeEstimator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSize() {
                IndexNode indexNode = LucenePropertyIndex.this.acquireIndexNode(plan);
                Preconditions.checkState((indexNode != null ? 1 : 0) != 0);
                try {
                    IndexSearcher searcher = indexNode.getSearcher();
                    LuceneRequestFacade luceneRequestFacade = LucenePropertyIndex.getLuceneRequest(plan, searcher.getIndexReader());
                    if (luceneRequestFacade.getLuceneRequest() instanceof Query) {
                        Query query = (Query)luceneRequestFacade.getLuceneRequest();
                        TotalHitCountCollector collector = new TotalHitCountCollector();
                        searcher.search(query, collector);
                        int totalHits = collector.getTotalHits();
                        LOG.debug("Estimated size for query {} is {}", (Object)query, (Object)totalHits);
                        long l = totalHits;
                        return l;
                    }
                    LOG.debug("estimate size: not a Query: {}", luceneRequestFacade.getLuceneRequest());
                }
                catch (IOException e) {
                    LOG.warn("query via {} failed.", (Object)LucenePropertyIndex.this, (Object)e);
                }
                finally {
                    indexNode.release();
                }
                return -1L;
            }
        };
        return new LucenePathCursor((Iterator<LuceneResultRow>)itr, plan, settings, sizeEstimator);
    }

    public NodeAggregator getNodeAggregator() {
        return null;
    }

    public static boolean isNodePath(String fulltextTermPath) {
        return fulltextTermPath.endsWith("/*");
    }

    private IndexNode acquireIndexNode(QueryIndex.IndexPlan plan) {
        return this.tracker.acquireIndexNode(LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
    }

    private static Sort getSort(QueryIndex.IndexPlan plan) {
        List sortOrder = plan.getSortOrder();
        if (sortOrder == null || sortOrder.isEmpty()) {
            return null;
        }
        ArrayList fieldsList = Lists.newArrayListWithCapacity((int)sortOrder.size());
        IndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult(plan);
        for (int i = 0; i < sortOrder.size(); ++i) {
            QueryIndex.OrderEntry oe = (QueryIndex.OrderEntry)sortOrder.get(i);
            if (LucenePropertyIndex.isNativeSort(oe)) continue;
            PropertyDefinition pd = planResult.getOrderedProperty(i);
            boolean reverse = oe.getOrder() != QueryIndex.OrderEntry.Order.ASCENDING;
            String propName = oe.getPropertyName();
            propName = FieldNames.createDocValFieldName(propName);
            fieldsList.add(new SortField(propName, LucenePropertyIndex.toLuceneSortType(oe, pd), reverse));
        }
        if (fieldsList.isEmpty()) {
            return null;
        }
        return new Sort(fieldsList.toArray(new SortField[0]));
    }

    private static boolean isNativeSort(QueryIndex.OrderEntry oe) {
        return oe.getPropertyName().equals(IndexDefinition.NATIVE_SORT_ORDER.getPropertyName());
    }

    private static SortField.Type toLuceneSortType(QueryIndex.OrderEntry oe, PropertyDefinition defn) {
        Type t = oe.getPropertyType();
        Preconditions.checkState((t != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkState((!t.isArray() ? 1 : 0) != 0, (Object)"Array types are not supported");
        int type = LucenePropertyIndex.getPropertyType(defn, oe.getPropertyName(), t.tag());
        switch (type) {
            case 3: 
            case 5: {
                return SortField.Type.LONG;
            }
            case 4: {
                return SortField.Type.DOUBLE;
            }
        }
        return SortField.Type.STRING;
    }

    private static String getIndexName(QueryIndex.IndexPlan plan) {
        return PathUtils.getName((String)LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
    }

    private static LuceneRequestFacade getLuceneRequest(QueryIndex.IndexPlan plan, IndexReader reader) {
        ArrayList<Query> qs = new ArrayList<Query>();
        Filter filter = plan.getFilter();
        FullTextExpression ft = filter.getFullTextConstraint();
        IndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult(plan);
        IndexDefinition defn = planResult.indexDefinition;
        Analyzer analyzer = defn.getAnalyzer();
        if (ft != null) {
            qs.add(LucenePropertyIndex.getFullTextQuery(plan, ft, analyzer));
        }
        Filter.PropertyRestriction pr = null;
        if (defn.hasFunctionDefined()) {
            pr = filter.getPropertyRestriction(defn.getFunctionName());
        }
        if (pr != null) {
            String query = String.valueOf(pr.first.getValue(pr.first.getType()));
            QueryParser queryParser = new QueryParser(LuceneIndexConstants.VERSION, "", analyzer);
            if (query.startsWith("mlt?")) {
                Query moreLikeThis;
                String mltQueryString = query.replace("mlt?", "");
                if (reader != null && (moreLikeThis = MoreLikeThisHelper.getMoreLikeThis(reader, analyzer, mltQueryString)) != null) {
                    qs.add(moreLikeThis);
                }
            } else if (query.startsWith("spellcheck?")) {
                String spellcheckQueryString = query.replace("spellcheck?", "");
                if (reader != null) {
                    return new LuceneRequestFacade<SpellcheckHelper.SpellcheckQuery>(SpellcheckHelper.getSpellcheckQuery(spellcheckQueryString, reader));
                }
            } else if (query.startsWith("suggest?")) {
                String suggestQueryString = query.replace("suggest?", "");
                if (reader != null) {
                    return new LuceneRequestFacade<SuggestHelper.SuggestQuery>(SuggestHelper.getSuggestQuery(suggestQueryString));
                }
            } else {
                try {
                    qs.add(queryParser.parse(query));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (planResult.evaluateNonFullTextConstraints()) {
            LucenePropertyIndex.addNonFullTextConstraints(qs, plan, reader);
        }
        if (qs.size() == 0 && plan.getSortOrder() != null) {
            List orders = plan.getSortOrder();
            for (int i = 0; i < orders.size(); ++i) {
                QueryIndex.OrderEntry oe = (QueryIndex.OrderEntry)orders.get(i);
                if (LucenePropertyIndex.isNativeSort(oe)) continue;
                PropertyDefinition pd = planResult.getOrderedProperty(i);
                Filter.PropertyRestriction orderRest = new Filter.PropertyRestriction();
                orderRest.propertyName = oe.getPropertyName();
                Query q = LucenePropertyIndex.createQuery(orderRest, pd);
                if (q == null) continue;
                qs.add(q);
            }
        }
        if (qs.size() == 0) {
            if (reader == null) {
                return new LuceneRequestFacade<MatchAllDocsQuery>(new MatchAllDocsQuery());
            }
            if (planResult.evaluateNodeTypeRestriction()) {
                return new LuceneRequestFacade<MatchAllDocsQuery>(new MatchAllDocsQuery());
            }
            throw new IllegalStateException("No query created for filter " + filter);
        }
        if (qs.size() == 1) {
            return new LuceneRequestFacade(qs.get(0));
        }
        BooleanQuery bq = new BooleanQuery();
        for (Query q : qs) {
            bq.add(q, BooleanClause.Occur.MUST);
        }
        return new LuceneRequestFacade<BooleanQuery>(bq);
    }

    private CustomScoreQuery getCustomScoreQuery(QueryIndex.IndexPlan plan, Query subQuery) {
        IndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult(plan);
        IndexDefinition idxDef = planResult.indexDefinition;
        String providerName = idxDef.getScorerProviderName();
        if (this.scorerProviderFactory != null && providerName != null) {
            return this.scorerProviderFactory.getScorerProvider(providerName).createCustomScoreQuery(subQuery);
        }
        return null;
    }

    private static void addNonFullTextConstraints(List<Query> qs, QueryIndex.IndexPlan plan, IndexReader reader) {
        Filter filter = plan.getFilter();
        IndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult(plan);
        IndexDefinition defn = planResult.indexDefinition;
        if (!filter.matchesAllTypes()) {
            LucenePropertyIndex.addNodeTypeConstraints(planResult.indexingRule, qs, filter);
        }
        String path = LucenePropertyIndex.getPathRestriction(plan);
        switch (filter.getPathRestriction()) {
            case ALL_CHILDREN: {
                if (!defn.evaluatePathRestrictions() || "/".equals(path)) break;
                qs.add(new TermQuery(TermFactory.newAncestorTerm(path)));
                break;
            }
            case DIRECT_CHILDREN: {
                if (!defn.evaluatePathRestrictions()) break;
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause(new TermQuery(TermFactory.newAncestorTerm(path)), BooleanClause.Occur.MUST));
                bq.add(new BooleanClause(LucenePropertyIndex.newDepthQuery(path), BooleanClause.Occur.MUST));
                qs.add(bq);
                break;
            }
            case EXACT: {
                qs.add(new TermQuery(TermFactory.newPathTerm(path)));
                break;
            }
            case PARENT: {
                if (PathUtils.denotesRoot((String)path)) {
                    qs.add(new TermQuery(new Term(":path", "///")));
                    break;
                }
                qs.add(new TermQuery(TermFactory.newPathTerm(PathUtils.getParentPath((String)path))));
                break;
            }
        }
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            Query q;
            PropertyDefinition pd;
            String name = pr.propertyName;
            if ("rep:excerpt".equals(name)) continue;
            if (":localname".equals(name)) {
                Query q2;
                if (!planResult.evaluateNodeNameRestriction() || (q2 = LucenePropertyIndex.createNodeNameQuery(pr)) == null) continue;
                qs.add(q2);
                continue;
            }
            if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                String first = (String)pr.first.getValue(Type.STRING);
                first = first.replace("\\", "");
                if ("jcr:path".equals(name)) {
                    qs.add(new TermQuery(TermFactory.newPathTerm(first)));
                    continue;
                }
                if ("*".equals(name)) {
                    LucenePropertyIndex.addReferenceConstraint(first, qs, reader);
                    continue;
                }
            }
            if ((pd = planResult.getPropDefn(pr)) == null || (q = LucenePropertyIndex.createQuery(pr, pd)) == null) continue;
            qs.add(q);
        }
    }

    private static int determinePropertyType(PropertyDefinition defn, Filter.PropertyRestriction pr) {
        int typeFromRestriction = pr.propertyType;
        if (typeFromRestriction == 0) {
            if (pr.first != null && pr.first.getType() != Type.UNDEFINED) {
                typeFromRestriction = pr.first.getType().tag();
            } else if (pr.last != null && pr.last.getType() != Type.UNDEFINED) {
                typeFromRestriction = pr.last.getType().tag();
            } else if (pr.list != null && !pr.list.isEmpty()) {
                typeFromRestriction = ((PropertyValue)pr.list.get(0)).getType().tag();
            }
        }
        return LucenePropertyIndex.getPropertyType(defn, pr.propertyName, typeFromRestriction);
    }

    private static int getPropertyType(PropertyDefinition defn, String name, int defaultVal) {
        if (defn.isTypeDefined()) {
            return defn.getType();
        }
        return defaultVal;
    }

    private static IndexPlanner.PlanResult getPlanResult(QueryIndex.IndexPlan plan) {
        return (IndexPlanner.PlanResult)plan.getAttribute(ATTR_PLAN_RESULT);
    }

    private static Query createLikeQuery(String name, String first) {
        first = first.replace('%', '*');
        first = first.replace('_', '?');
        int indexOfWS = first.indexOf(42);
        int indexOfWC = first.indexOf(63);
        int len = first.length();
        if (indexOfWS == len || indexOfWC == len) {
            first = first.substring(0, first.length() - 1);
            if ("jcr:path".equals(name)) {
                return new PrefixQuery(TermFactory.newPathTerm(first));
            }
            return new PrefixQuery(new Term(name, first));
        }
        if ("jcr:path".equals(name)) {
            return new WildcardQuery(TermFactory.newPathTerm(first));
        }
        return new WildcardQuery(new Term(name, first));
    }

    @CheckForNull
    private static Query createQuery(Filter.PropertyRestriction pr, PropertyDefinition defn) {
        int propType = LucenePropertyIndex.determinePropertyType(defn, pr);
        if (pr.isNullRestriction()) {
            return new TermQuery(new Term(":nullProps", defn.name));
        }
        if (pr.isNotNullRestriction() && defn.notNullCheckEnabled) {
            return new TermQuery(new Term(":notNullProps", defn.name));
        }
        switch (propType) {
            case 5: {
                Long last;
                Long first = pr.first != null ? FieldFactory.dateToLong((String)pr.first.getValue(Type.DATE)) : null;
                Long l = last = pr.last != null ? FieldFactory.dateToLong((String)pr.last.getValue(Type.DATE)) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, first, first, true, true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Long dateVal = FieldFactory.dateToLong((String)value.getValue(Type.DATE));
                        in.add(NumericRangeQuery.newLongRange(pr.propertyName, dateVal, dateVal, true, true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return NumericRangeQuery.newLongRange(pr.propertyName, 0L, Long.MAX_VALUE, true, true);
            }
            case 4: {
                Double last;
                Double first = pr.first != null ? (Double)pr.first.getValue(Type.DOUBLE) : null;
                Double d = last = pr.last != null ? (Double)pr.last.getValue(Type.DOUBLE) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newDoubleRange(pr.propertyName, first, first, true, true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newDoubleRange(pr.propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newDoubleRange(pr.propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newDoubleRange(pr.propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Double doubleVal = (Double)value.getValue(Type.DOUBLE);
                        in.add(NumericRangeQuery.newDoubleRange(pr.propertyName, doubleVal, doubleVal, true, true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return NumericRangeQuery.newDoubleRange(pr.propertyName, Double.MIN_VALUE, Double.MAX_VALUE, true, true);
            }
            case 3: {
                Long last;
                Long first = pr.first != null ? (Long)pr.first.getValue(Type.LONG) : null;
                Long l = last = pr.last != null ? (Long)pr.last.getValue(Type.LONG) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, first, first, true, true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newLongRange(pr.propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Long longVal = (Long)value.getValue(Type.LONG);
                        in.add(NumericRangeQuery.newLongRange(pr.propertyName, longVal, longVal, true, true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return NumericRangeQuery.newLongRange(pr.propertyName, Long.MIN_VALUE, Long.MAX_VALUE, true, true);
            }
            default: {
                String last;
                if (pr.isLike) {
                    return LucenePropertyIndex.createLikeQuery(pr.propertyName, (String)pr.first.getValue(Type.STRING));
                }
                String first = pr.first != null ? (String)pr.first.getValue(Type.STRING) : null;
                String string = last = pr.last != null ? (String)pr.last.getValue(Type.STRING) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return new TermQuery(new Term(pr.propertyName, first));
                }
                if (pr.first != null && pr.last != null) {
                    return TermRangeQuery.newStringRange(pr.propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return TermRangeQuery.newStringRange(pr.propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return TermRangeQuery.newStringRange(pr.propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        String strVal = (String)value.getValue(Type.STRING);
                        in.add(new TermQuery(new Term(pr.propertyName, strVal)), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return new TermRangeQuery(pr.propertyName, null, null, true, true);
            }
        }
        throw new IllegalStateException("PropertyRestriction not handled " + pr + " for index " + defn);
    }

    static long getVersion(IndexSearcher indexSearcher) {
        IndexReader reader = indexSearcher.getIndexReader();
        if (reader instanceof DirectoryReader) {
            return ((DirectoryReader)reader).getVersion();
        }
        return -1L;
    }

    private static Query createNodeNameQuery(Filter.PropertyRestriction pr) {
        String first;
        String string = first = pr.first != null ? (String)pr.first.getValue(Type.STRING) : null;
        if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
            return new TermQuery(new Term(":nodeName", first));
        }
        if (pr.isLike) {
            return LucenePropertyIndex.createLikeQuery(":nodeName", first);
        }
        throw new IllegalStateException("For nodeName queries only EQUALS and LIKE are supported " + pr);
    }

    private static void addReferenceConstraint(String uuid, List<Query> qs, IndexReader reader) {
        if (reader == null) {
            qs.add(new TermQuery(new Term("*", uuid)));
            return;
        }
        BooleanQuery bq = new BooleanQuery();
        Collection<String> fields = MultiFields.getIndexedFields(reader);
        for (String f : fields) {
            bq.add(new TermQuery(new Term(f, uuid)), BooleanClause.Occur.SHOULD);
        }
        qs.add(bq);
    }

    private static void addNodeTypeConstraints(IndexDefinition.IndexingRule defn, List<Query> qs, Filter filter) {
        PropertyDefinition mixinType;
        BooleanQuery bq = new BooleanQuery();
        PropertyDefinition primaryType = defn.getConfig("jcr:primaryType");
        if (primaryType != null && primaryType.propertyIndex) {
            for (String type : filter.getPrimaryTypes()) {
                bq.add(new TermQuery(new Term("jcr:primaryType", type)), BooleanClause.Occur.SHOULD);
            }
        }
        if ((mixinType = defn.getConfig("jcr:mixinTypes")) != null && mixinType.propertyIndex) {
            for (String type : filter.getMixinTypes()) {
                bq.add(new TermQuery(new Term("jcr:mixinTypes", type)), BooleanClause.Occur.SHOULD);
            }
        }
        if (bq.clauses().size() != 0) {
            qs.add(bq);
        }
    }

    static Query getFullTextQuery(final QueryIndex.IndexPlan plan, FullTextExpression ft, final Analyzer analyzer) {
        final IndexPlanner.PlanResult pr = LucenePropertyIndex.getPlanResult(plan);
        final AtomicReference result = new AtomicReference();
        ft.accept(new FullTextVisitor(){

            public boolean visit(FullTextContains contains) {
                this.visitTerm(contains.getPropertyName(), contains.getRawText(), null, false);
                return true;
            }

            public boolean visit(FullTextOr or) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : or.list) {
                    Query x = LucenePropertyIndex.getFullTextQuery(plan, e, analyzer);
                    q.add(x, BooleanClause.Occur.SHOULD);
                }
                result.set(q);
                return true;
            }

            public boolean visit(FullTextAnd and) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : and.list) {
                    BooleanQuery bq;
                    Query x = LucenePropertyIndex.getFullTextQuery(plan, e, analyzer);
                    boolean hasMustNot = false;
                    if (x instanceof BooleanQuery && (bq = (BooleanQuery)x).getClauses().length == 1 && bq.getClauses()[0].getOccur() == BooleanClause.Occur.MUST_NOT) {
                        hasMustNot = true;
                        q.add(bq.getClauses()[0]);
                    }
                    if (hasMustNot) continue;
                    q.add(x, BooleanClause.Occur.MUST);
                }
                result.set(q);
                return true;
            }

            public boolean visit(FullTextTerm term) {
                return this.visitTerm(term.getPropertyName(), term.getText(), term.getBoost(), term.isNot());
            }

            private boolean visitTerm(String propertyName, String text, String boost, boolean not) {
                String p = LucenePropertyIndex.getLuceneFieldName(propertyName, pr);
                Query q = LucenePropertyIndex.tokenToQuery(text, p, pr.indexingRule, analyzer);
                if (q == null) {
                    return false;
                }
                if (boost != null) {
                    q.setBoost(Float.parseFloat(boost));
                }
                if (not) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(q, BooleanClause.Occur.MUST_NOT);
                    result.set(bq);
                } else {
                    result.set(q);
                }
                return true;
            }
        });
        return (Query)result.get();
    }

    static String getLuceneFieldName(@Nullable String p, IndexPlanner.PlanResult pr) {
        if (p == null) {
            return ":fulltext";
        }
        if (LucenePropertyIndex.isNodePath(p)) {
            p = pr.isPathTransformed() ? PathUtils.getName((String)p) : FieldNames.createFulltextFieldName(PathUtils.getParentPath((String)p));
        } else {
            if (pr.isPathTransformed()) {
                p = PathUtils.getName((String)p);
            }
            p = FieldNames.createAnalyzedFieldName(p);
        }
        if ("*".equals(p)) {
            p = ":fulltext";
        }
        return p;
    }

    private static Query tokenToQuery(String text, String fieldName, IndexDefinition.IndexingRule indexingRule, Analyzer analyzer) {
        if (":fulltext".equals(fieldName) && !indexingRule.getNodeScopeAnalyzedProps().isEmpty()) {
            BooleanQuery in = new BooleanQuery();
            for (PropertyDefinition pd : indexingRule.getNodeScopeAnalyzedProps()) {
                Query q = LucenePropertyIndex.tokenToQuery(text, FieldNames.createAnalyzedFieldName(pd.name), analyzer);
                q.setBoost(pd.boost);
                in.add(q, BooleanClause.Occur.SHOULD);
            }
            in.add(LucenePropertyIndex.tokenToQuery(text, fieldName, analyzer), BooleanClause.Occur.SHOULD);
            return in;
        }
        return LucenePropertyIndex.tokenToQuery(text, fieldName, analyzer);
    }

    static Query tokenToQuery(String text, String fieldName, Analyzer analyzer) {
        if (analyzer == null) {
            return null;
        }
        StandardQueryParser parserHelper = new StandardQueryParser(analyzer);
        parserHelper.setAllowLeadingWildcard(true);
        parserHelper.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        text = LucenePropertyIndex.rewriteQueryText(text);
        try {
            return parserHelper.parse(text, fieldName);
        }
        catch (QueryNodeException e) {
            throw new RuntimeException(e);
        }
    }

    private static String rewriteQueryText(String textsearch) {
        StringBuilder rewritten = new StringBuilder();
        textsearch = textsearch.replaceAll("AND", "and");
        textsearch = textsearch.replaceAll("NOT", "not");
        boolean escaped = false;
        for (int i = 0; i < textsearch.length(); ++i) {
            if (textsearch.charAt(i) == '\\') {
                if (escaped) {
                    rewritten.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (textsearch.charAt(i) == '\'') {
                if (escaped) {
                    escaped = false;
                }
                rewritten.append(textsearch.charAt(i));
                continue;
            }
            if (textsearch.charAt(i) == ':') {
                rewritten.append("\\:");
                continue;
            }
            if (escaped) {
                rewritten.append('\\');
                escaped = false;
            }
            rewritten.append(textsearch.charAt(i));
        }
        return rewritten.toString();
    }

    private static String getPathRestriction(QueryIndex.IndexPlan plan) {
        Filter f = plan.getFilter();
        String pathPrefix = plan.getPathPrefix();
        if (pathPrefix.isEmpty()) {
            return f.getPath();
        }
        String relativePath = PathUtils.relativize((String)pathPrefix, (String)f.getPath());
        return "/" + relativePath;
    }

    private static Query newDepthQuery(String path) {
        int depth = PathUtils.getDepth((String)path) + 1;
        return NumericRangeQuery.newIntRange(":depth", depth, depth, true, true);
    }

    private static class PathStoredFieldVisitor
    extends StoredFieldVisitor {
        private String path;
        private boolean pathVisited;

        private PathStoredFieldVisitor() {
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            if (":path".equals(fieldInfo.name)) {
                return StoredFieldVisitor.Status.YES;
            }
            return this.pathVisited ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
        }

        @Override
        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            if (":path".equals(fieldInfo.name)) {
                this.path = value;
                this.pathVisited = true;
            }
        }

        public String getPath() {
            return this.path;
        }
    }

    static class LucenePathCursor
    implements Cursor {
        private final Cursor pathCursor;
        private final String pathPrefix;
        LuceneResultRow currentRow;
        private final SizeEstimator sizeEstimator;
        private long estimatedSize;

        LucenePathCursor(final Iterator<LuceneResultRow> it, QueryIndex.IndexPlan plan, QueryEngineSettings settings, SizeEstimator sizeEstimator) {
            this.pathPrefix = plan.getPathPrefix();
            this.sizeEstimator = sizeEstimator;
            Iterator<String> pathIterator = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    LucenePathCursor.this.currentRow = (LuceneResultRow)it.next();
                    return LucenePathCursor.this.currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.pathCursor = new Cursors.PathCursor((Iterator)pathIterator, false, settings);
        }

        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        public void remove() {
            this.pathCursor.remove();
        }

        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                public boolean isVirtualRow() {
                    return this.getPath() == null;
                }

                public String getPath() {
                    String sub = pathRow.getPath();
                    if (PathUtils.isAbsolute((String)sub)) {
                        return LucenePathCursor.this.pathPrefix + sub;
                    }
                    return PathUtils.concat((String)LucenePathCursor.this.pathPrefix, (String)sub);
                }

                public PropertyValue getValue(String columnName) {
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble((Double)LucenePathCursor.this.currentRow.score);
                    }
                    if ("rep:spellcheck()".equals(columnName) || "rep:suggest()".equals(columnName)) {
                        return PropertyValues.newString((String)Iterables.toString(LucenePathCursor.this.currentRow.suggestWords));
                    }
                    return pathRow.getValue(columnName);
                }
            };
        }

        public long getSize(Result.SizePrecision precision, long max) {
            if (this.estimatedSize != 0L) {
                return this.estimatedSize;
            }
            this.estimatedSize = this.sizeEstimator.getSize();
            return this.estimatedSize;
        }
    }

    static class LuceneResultRow {
        final String path;
        final double score;
        final Iterable<String> suggestWords;

        LuceneResultRow(String path, double score) {
            this.path = path;
            this.score = score;
            this.suggestWords = Collections.emptySet();
        }

        LuceneResultRow(Iterable<String> suggestWords) {
            this.path = "/";
            this.score = 1.0;
            this.suggestWords = suggestWords;
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

