/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.shingle.ShingleAnalyzerWrapper;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditorContext {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditorContext.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(LuceneIndexEditorContext.class.getName() + ".perf")));
    private static final Parser defaultParser = LuceneIndexEditorContext.createDefaultParser();
    private final IndexDefinition definition;
    private final NodeBuilder definitionBuilder;
    private IndexWriter writer = null;
    private long indexedNodes;
    private final IndexUpdateCallback updateCallback;
    private boolean reindex;
    private Parser parser;
    @Nullable
    private final IndexCopier indexCopier;
    private Directory directory;
    private final TextExtractionStats textExtractionStats = new TextExtractionStats();
    private final ExtractedTextCache extractedTextCache;
    private Set<MediaType> supportedMediaTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IndexWriterConfig getIndexWriterConfig(IndexDefinition definition, boolean remoteDir) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(IndexWriterConfig.class.getClassLoader());
        try {
            Analyzer definitionAnalyzer = definition.getAnalyzer();
            HashMap<String, Analyzer> analyzers = new HashMap<String, Analyzer>();
            analyzers.put(":spellcheck", new ShingleAnalyzerWrapper(LuceneIndexConstants.ANALYZER, 3));
            PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper(definitionAnalyzer, analyzers);
            IndexWriterConfig config = new IndexWriterConfig(LuceneIndexConstants.VERSION, analyzer);
            if (remoteDir) {
                config.setMergeScheduler(new SerialMergeScheduler());
            }
            if (definition.getCodec() != null) {
                config.setCodec(definition.getCodec());
            }
            IndexWriterConfig indexWriterConfig = config;
            return indexWriterConfig;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    static Directory newIndexDirectory(IndexDefinition indexDefinition, NodeBuilder definition) throws IOException {
        String path = definition.getString("path");
        if (path == null) {
            return new OakDirectory(definition.child(":data"), indexDefinition, false);
        }
        File file = new File(path);
        file.mkdirs();
        return FSDirectory.open(file, NoLockFactory.getNoLockFactory());
    }

    LuceneIndexEditorContext(NodeState root, NodeBuilder definition, IndexUpdateCallback updateCallback, @Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache) {
        this.definitionBuilder = definition;
        this.indexCopier = indexCopier;
        this.definition = new IndexDefinition(root, definition);
        this.indexedNodes = 0L;
        this.updateCallback = updateCallback;
        this.extractedTextCache = extractedTextCache;
        if (this.definition.isOfOldFormat()) {
            IndexDefinition.updateDefinition(definition);
        }
    }

    Parser getParser() {
        if (this.parser == null) {
            this.parser = LuceneIndexEditorContext.initializeTikaParser(this.definition);
        }
        return this.parser;
    }

    IndexWriter getWriter() throws IOException {
        if (this.writer == null) {
            IndexWriterConfig config;
            long start = PERF_LOGGER.start();
            this.directory = LuceneIndexEditorContext.newIndexDirectory(this.definition, this.definitionBuilder);
            if (this.indexCopier != null) {
                this.directory = this.indexCopier.wrapForWrite(this.definition, this.directory, this.reindex);
                config = LuceneIndexEditorContext.getIndexWriterConfig(this.definition, false);
            } else {
                config = LuceneIndexEditorContext.getIndexWriterConfig(this.definition, true);
            }
            this.writer = new IndexWriter(this.directory, config);
            PERF_LOGGER.end(start, -1L, "Created IndexWriter for directory {}", (Object)this.definition);
        }
        return this.writer;
    }

    void closeWriter() throws IOException {
        if (this.reindex && this.writer == null) {
            this.getWriter();
        }
        if (this.writer != null) {
            long start = PERF_LOGGER.start();
            this.updateSuggester();
            this.writer.close();
            this.directory.close();
            NodeBuilder status = this.definitionBuilder.child(":status");
            status.setProperty("lastUpdated", (Object)ISO8601.format((Calendar)Calendar.getInstance()), Type.DATE);
            status.setProperty("indexedNodes", (Object)this.indexedNodes);
            PERF_LOGGER.end(start, -1L, "Closed IndexWriter for directory {}", (Object)this.definition);
            this.textExtractionStats.log(this.reindex);
            this.textExtractionStats.collectStats(this.extractedTextCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSuggester() throws IOException {
        if (this.definition.isSuggestEnabled()) {
            boolean updateSuggester = false;
            NodeBuilder suggesterStatus = this.definitionBuilder.child(":suggesterStatus");
            if (suggesterStatus.hasProperty("lastUpdated")) {
                PropertyState suggesterLastUpdatedValue = suggesterStatus.getProperty("lastUpdated");
                Calendar suggesterLastUpdatedTime = ISO8601.parse((String)((String)suggesterLastUpdatedValue.getValue(Type.DATE)));
                int updateFrequency = this.definition.getSuggesterUpdateFrequencyMinutes();
                suggesterLastUpdatedTime.add(12, updateFrequency);
                if (Calendar.getInstance().after(suggesterLastUpdatedTime)) {
                    updateSuggester = true;
                }
            } else {
                updateSuggester = true;
            }
            if (updateSuggester) {
                DirectoryReader reader = DirectoryReader.open(this.writer, false);
                try {
                    SuggestHelper.updateSuggester(reader);
                    suggesterStatus.setProperty("lastUpdated", (Object)ISO8601.format((Calendar)Calendar.getInstance()), Type.DATE);
                }
                catch (Throwable e) {
                    log.warn("could not update suggester", e);
                }
                finally {
                    reader.close();
                }
            }
        }
    }

    public void enableReindexMode() {
        this.reindex = true;
        IndexFormatVersion version = IndexDefinition.determineVersionForFreshIndex(this.definitionBuilder);
        this.definitionBuilder.setProperty(":version", (Object)version.getVersion());
    }

    public long incIndexedNodes() {
        ++this.indexedNodes;
        return this.indexedNodes;
    }

    public long getIndexedNodes() {
        return this.indexedNodes;
    }

    public boolean isSupportedMediaType(String type) {
        if (this.supportedMediaTypes == null) {
            this.supportedMediaTypes = this.getParser().getSupportedTypes(new ParseContext());
        }
        return this.supportedMediaTypes.contains(MediaType.parse((String)type));
    }

    void indexUpdate() throws CommitFailedException {
        this.updateCallback.indexUpdate();
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    @Deprecated
    public void recordTextExtractionStats(long timeInMillis, long bytesRead) {
        this.recordTextExtractionStats(timeInMillis, bytesRead, 0);
    }

    public void recordTextExtractionStats(long timeInMillis, long bytesRead, int textLength) {
        this.textExtractionStats.addStats(timeInMillis, bytesRead, textLength);
    }

    ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }

    public boolean isReindex() {
        return this.reindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Parser initializeTikaParser(IndexDefinition definition) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            if (definition.hasCustomTikaConfig()) {
                AutoDetectParser autoDetectParser;
                Thread.currentThread().setContextClassLoader(LuceneIndexEditorContext.class.getClassLoader());
                InputStream is = definition.getTikaConfig();
                try {
                    autoDetectParser = new AutoDetectParser(LuceneIndexEditorContext.getTikaConfig(is, definition));
                }
                catch (Throwable throwable) {
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                return autoDetectParser;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
        return defaultParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AutoDetectParser createDefaultParser() {
        block5: {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            URL configUrl = LuceneIndexEditorContext.class.getResource("tika-config.xml");
            InputStream is = null;
            if (configUrl != null) {
                AutoDetectParser autoDetectParser;
                try {
                    Thread.currentThread().setContextClassLoader(LuceneIndexEditorContext.class.getClassLoader());
                    is = configUrl.openStream();
                    TikaConfig config = new TikaConfig(is);
                    log.info("Loaded default Tika Config from classpath {}", (Object)configUrl);
                    autoDetectParser = new AutoDetectParser(config);
                }
                catch (Exception e) {
                    try {
                        log.warn("Tika configuration not available : " + configUrl, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        org.apache.commons.io.IOUtils.closeQuietly(is);
                        Thread.currentThread().setContextClassLoader(current);
                        throw throwable;
                    }
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                    Thread.currentThread().setContextClassLoader(current);
                    break block5;
                }
                org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                Thread.currentThread().setContextClassLoader(current);
                return autoDetectParser;
            }
            log.warn("Default Tika configuration not found from {}", (Object)configUrl);
        }
        return new AutoDetectParser();
    }

    private static TikaConfig getTikaConfig(InputStream configStream, Object source) {
        try {
            return new TikaConfig(configStream);
        }
        catch (Exception e) {
            log.warn("Tika configuration not available : " + source, (Throwable)e);
            return TikaConfig.getDefaultConfig();
        }
    }

    static class TextExtractionStats {
        private static final long LOGGING_THRESHOLD = TimeUnit.MINUTES.toMillis(1L);
        private int count;
        private long totalBytesRead;
        private long totalTime;
        private long totalTextLength;

        TextExtractionStats() {
        }

        public void addStats(long timeInMillis, long bytesRead, int textLength) {
            ++this.count;
            this.totalBytesRead += bytesRead;
            this.totalTime += timeInMillis;
            this.totalTextLength += (long)textLength;
        }

        public void log(boolean reindex) {
            if (log.isDebugEnabled()) {
                log.debug("Text extraction stats {}", (Object)this);
            } else if (this.anyParsingDone() && (reindex || this.isTakingLotsOfTime())) {
                log.info("Text extraction stats {}", (Object)this);
            }
        }

        public void collectStats(ExtractedTextCache cache) {
            cache.addStats(this.count, this.totalTime, this.totalBytesRead, this.totalTextLength);
        }

        private boolean isTakingLotsOfTime() {
            return this.totalTime > LOGGING_THRESHOLD;
        }

        private boolean anyParsingDone() {
            return this.count > 0;
        }

        public String toString() {
            return String.format(" %d (Time Taken %s, Bytes Read %s, Extracted text size %s)", this.count, TextExtractionStats.timeInWords(this.totalTime), IOUtils.humanReadableByteCount((long)this.totalBytesRead), IOUtils.humanReadableByteCount((long)this.totalTextLength));
        }

        private static String timeInWords(long millis) {
            return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        }
    }
}

