/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import org.apache.lucene.util.InfoStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInfoStream
extends InfoStream {
    static final String PREFIX = "oak.lucene";
    public static final LoggingInfoStream INSTANCE = new LoggingInfoStream();

    private LoggingInfoStream() {
    }

    @Override
    public void message(String component, String message) {
        LoggingInfoStream.getLog(component).debug("[{}] {}", (Object)component, (Object)message);
    }

    @Override
    public boolean isEnabled(String component) {
        return LoggingInfoStream.getLog(component).isDebugEnabled();
    }

    @Override
    public void close() throws IOException {
    }

    private static Logger getLog(String component) {
        return LoggerFactory.getLogger((String)("oak.lucene." + component));
    }
}

