/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakDirectory;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

class IndexNode {
    private final String name;
    private final IndexDefinition definition;
    private final Directory directory;
    private final IndexReader reader;
    private final IndexSearcher searcher;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IndexNode open(String indexPath, NodeState root, NodeState defnNodeState, @Nullable IndexCopier cloner) throws IOException {
        String path;
        Directory directory = null;
        IndexDefinition definition = new IndexDefinition(root, defnNodeState, indexPath);
        NodeState data = defnNodeState.getChildNode(":data");
        if (data.exists()) {
            directory = new OakDirectory((NodeBuilder)new ReadOnlyBuilder(data), definition, true);
            if (cloner != null) {
                directory = cloner.wrapForRead(indexPath, definition, directory);
            }
        } else if ("file".equalsIgnoreCase(defnNodeState.getString("persistence")) && (path = defnNodeState.getString("path")) != null && new File(path).exists()) {
            directory = FSDirectory.open(new File(path));
        }
        if (directory != null) {
            try {
                IndexNode index = new IndexNode(PathUtils.getName((String)indexPath), definition, directory);
                directory = null;
                IndexNode indexNode = index;
                return indexNode;
            }
            finally {
                if (directory != null) {
                    directory.close();
                }
            }
        }
        return null;
    }

    IndexNode(String name, IndexDefinition definition, Directory directory) throws IOException {
        this.name = name;
        this.definition = definition;
        this.directory = directory;
        this.reader = DirectoryReader.open(directory);
        this.searcher = new IndexSearcher(this.reader);
    }

    String getName() {
        return this.name;
    }

    IndexDefinition getDefinition() {
        return this.definition;
    }

    IndexSearcher getSearcher() {
        return this.searcher;
    }

    boolean acquire() {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return false;
        }
        return true;
    }

    void release() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try {
            this.reader.close();
        }
        finally {
            this.directory.close();
        }
    }
}

