/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.fulltext.ExtractedText;
import org.apache.jackrabbit.oak.plugins.index.fulltext.PreExtractedTextProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.TextExtractionStatsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtractedTextCache {
    private static final String EMPTY_STRING = "";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile PreExtractedTextProvider extractedTextProvider;
    private int textExtractionCount;
    private long totalBytesRead;
    private long totalTextSize;
    private long totalTime;
    private int preFetchedCount;

    ExtractedTextCache() {
    }

    @CheckForNull
    public String get(String nodePath, String propertyName, Blob blob, boolean reindexMode) {
        String result = null;
        if (reindexMode && this.extractedTextProvider != null) {
            String propertyPath = PathUtils.concat((String)nodePath, (String)propertyName);
            try {
                ExtractedText text = this.extractedTextProvider.getText(propertyPath, blob);
                if (text != null) {
                    ++this.preFetchedCount;
                    switch (text.getExtractionResult()) {
                        case SUCCESS: {
                            result = text.getExtractedText().toString();
                            break;
                        }
                        case ERROR: {
                            result = "TextExtractionError";
                            break;
                        }
                        case EMPTY: {
                            result = EMPTY_STRING;
                        }
                    }
                }
            }
            catch (IOException e) {
                this.log.warn("Error occurred while fetching pre extracted text for {}", (Object)propertyPath, (Object)e);
            }
        }
        return result;
    }

    public void put(Blob blob, ExtractedText extractedText) {
    }

    public void addStats(int count, long timeInMillis, long bytesRead, long textLength) {
        this.textExtractionCount += count;
        this.totalTime += timeInMillis;
        this.totalBytesRead += bytesRead;
        this.totalTextSize += textLength;
    }

    public TextExtractionStatsMBean getStatsMBean() {
        return new TextExtractionStatsMBean(){

            @Override
            public boolean isPreExtractedTextProviderConfigured() {
                return ExtractedTextCache.this.extractedTextProvider != null;
            }

            @Override
            public int getTextExtractionCount() {
                return ExtractedTextCache.this.textExtractionCount;
            }

            @Override
            public long getTotalTime() {
                return ExtractedTextCache.this.totalTime;
            }

            @Override
            public int getPreFetchedCount() {
                return ExtractedTextCache.this.preFetchedCount;
            }

            @Override
            public String getExtractedTextSize() {
                return IOUtils.humanReadableByteCount((long)ExtractedTextCache.this.totalTextSize);
            }

            @Override
            public String getBytesRead() {
                return IOUtils.humanReadableByteCount((long)ExtractedTextCache.this.totalBytesRead);
            }
        };
    }

    public void setExtractedTextProvider(PreExtractedTextProvider extractedTextProvider) {
        this.extractedTextProvider = extractedTextProvider;
    }

    public PreExtractedTextProvider getExtractedTextProvider() {
        return this.extractedTextProvider;
    }
}

