/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;

public interface InputIterator
extends BytesRefIterator {
    public static final InputIterator EMPTY = new InputIteratorWrapper(BytesRefIterator.EMPTY);

    public long weight();

    public BytesRef payload();

    public boolean hasPayloads();

    public static class InputIteratorWrapper
    implements InputIterator {
        private final BytesRefIterator wrapped;

        public InputIteratorWrapper(BytesRefIterator wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public long weight() {
            return 1L;
        }

        @Override
        public BytesRef next() throws IOException {
            return this.wrapped.next();
        }

        @Override
        public BytesRef payload() {
            return null;
        }

        @Override
        public boolean hasPayloads() {
            return false;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return this.wrapped.getComparator();
        }
    }
}

