/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.score.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.lucene.score.ScorerProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.score.ScorerProviderFactory;

@Component(metatype=false, immediate=true)
@Service(value={ScorerProviderFactory.class})
@Reference(name="ScorerProvider", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=ScorerProvider.class, bind="bindScorerProvider", unbind="unbindScorerProvider")
public class ScorerProviderFactoryImpl
implements ScorerProviderFactory {
    private Map<String, ScorerProvider> scorerProviderMap = new ConcurrentHashMap<String, ScorerProvider>();

    @Deactivate
    private void deactivate() {
        this.scorerProviderMap.clear();
    }

    @Override
    public ScorerProvider getScorerProvider(String scorerName) {
        return this.scorerProviderMap.get(scorerName);
    }

    private void bindScorerProvider(ScorerProvider provider) {
        this.scorerProviderMap.put(provider.getName(), provider);
    }

    private void unbindScorerProvider(ScorerProvider provider) {
        this.scorerProviderMap.remove(provider.getName());
    }
}

