/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.util.Version;

public class OakAnalyzer
extends Analyzer {
    private final Version matchVersion;

    public OakAnalyzer(Version matchVersion) {
        this.matchVersion = matchVersion;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        ClassicTokenizer src = new ClassicTokenizer(this.matchVersion, reader);
        TokenFilter tok = new LowerCaseFilter(this.matchVersion, src);
        tok = new WordDelimiterFilter(tok, 259, null);
        return new Analyzer.TokenStreamComponents(src, tok);
    }
}

