/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexTracker {
    private static final Logger log = LoggerFactory.getLogger(IndexTracker.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(IndexTracker.class.getName() + ".perf")));
    private final IndexCopier cloner;
    private NodeState root = EmptyNodeState.EMPTY_NODE;
    private volatile Map<String, IndexNode> indices = Collections.emptyMap();
    private volatile boolean refresh;

    IndexTracker() {
        this(null);
    }

    IndexTracker(IndexCopier cloner) {
        this.cloner = cloner;
    }

    synchronized void close() {
        Map<String, IndexNode> indices = this.indices;
        this.indices = Collections.emptyMap();
        for (Map.Entry<String, IndexNode> entry : indices.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Failed to close the Lucene index at " + entry.getKey(), (Throwable)e);
            }
        }
    }

    synchronized void update(NodeState root) {
        if (this.refresh) {
            this.root = root;
            this.close();
            this.refresh = false;
            log.info("Refreshed the opened indexes");
        } else {
            this.diffAndUpdate(root);
        }
    }

    private synchronized void diffAndUpdate(final NodeState root) {
        Map<String, IndexNode> original = this.indices;
        final HashMap updates = Maps.newHashMap();
        ArrayList editors = Lists.newArrayListWithCapacity((int)original.size());
        for (Map.Entry<String, IndexNode> entry : original.entrySet()) {
            final String path = entry.getKey();
            editors.add(new SubtreeEditor((Editor)new DefaultEditor(){

                public void leave(NodeState before, NodeState after) {
                    try {
                        long start = PERF_LOGGER.start();
                        IndexNode index = IndexNode.open(path, root, after, IndexTracker.this.cloner);
                        PERF_LOGGER.end(start, -1L, "[{}] Index found to be updated. Reopening the IndexNode", (Object)path);
                        updates.put(path, index);
                    }
                    catch (IOException e) {
                        log.error("Failed to open Lucene index at " + path, (Throwable)e);
                    }
                }
            }, (String[])Iterables.toArray((Iterable)PathUtils.elements((String)path), String.class)));
        }
        EditorDiff.process((Editor)CompositeEditor.compose((Collection)editors), (NodeState)this.root, (NodeState)root);
        this.root = root;
        if (!updates.isEmpty()) {
            this.indices = ImmutableMap.builder().putAll(Maps.filterKeys(original, (Predicate)Predicates.not((Predicate)Predicates.in(updates.keySet())))).putAll(Maps.filterValues((Map)updates, (Predicate)Predicates.notNull())).build();
            for (String path : updates.keySet()) {
                IndexNode index = original.get(path);
                try {
                    index.close();
                }
                catch (IOException e) {
                    log.error("Failed to close Lucene index at " + path, (Throwable)e);
                }
            }
        }
    }

    void refresh() {
        this.refresh = true;
    }

    IndexNode acquireIndexNode(String path) {
        IndexNode index = this.indices.get(path);
        if (index != null && index.acquire()) {
            return index;
        }
        return this.findIndexNode(path);
    }

    Set<String> getIndexNodePaths() {
        return this.indices.keySet();
    }

    private synchronized IndexNode findIndexNode(String path) {
        IndexNode index = this.indices.get(path);
        if (index != null) {
            Preconditions.checkState((boolean)index.acquire());
            return index;
        }
        NodeState node = this.root;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        try {
            if (LuceneIndexHelper.isLuceneIndexNode(node)) {
                index = IndexNode.open(path, this.root, node, this.cloner);
                if (index != null) {
                    Preconditions.checkState((boolean)index.acquire());
                    this.indices = ImmutableMap.builder().putAll(this.indices).put((Object)path, (Object)index).build();
                    return index;
                }
            } else if (node.exists()) {
                log.warn("Cannot open Lucene Index at path {} as the index is not of type {}", (Object)path, (Object)"lucene");
            }
        }
        catch (IOException e) {
            log.error("Could not access the Lucene index at " + path, (Throwable)e);
        }
        return null;
    }
}

