/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

public enum IndexFormatVersion {
    V1(1),
    V2(2);

    private final int version;

    private IndexFormatVersion(int version) {
        this.version = version;
    }

    public boolean isAtLeast(IndexFormatVersion version) {
        return this.version >= version.getVersion();
    }

    public int getVersion() {
        return this.version;
    }

    public static IndexFormatVersion getVersion(int version) {
        switch (version) {
            case 1: {
                return V1;
            }
            case 2: {
                return V2;
            }
        }
        throw new IllegalArgumentException("Unknown version : " + version);
    }

    public static IndexFormatVersion getDefault() {
        return V1;
    }

    public static IndexFormatVersion max(IndexFormatVersion o1, IndexFormatVersion o2) {
        return o1.version > o2.version ? o1 : o2;
    }
}

