/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.concurrent.NotifyingFutureTask;
import org.apache.jackrabbit.oak.plugins.index.lucene.CopyOnReadStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopierClosedException;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NoLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCopier
implements CopyOnReadStatsMBean,
Closeable {
    private static final Set<String> REMOTE_ONLY = ImmutableSet.of((Object)"segments.gen");
    private static final int MAX_FAILURE_ENTRIES = 10000;
    private static final AtomicInteger UNIQUE_COUNTER = new AtomicInteger();
    private static final String WORK_DIR_NAME = "indexWriterDir";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(this.log.getName() + ".perf")));
    private final Executor executor;
    private final File indexRootDir;
    private final File indexWorkDir;
    private final AtomicInteger readerLocalReadCount = new AtomicInteger();
    private final AtomicInteger writerLocalReadCount = new AtomicInteger();
    private final AtomicInteger readerRemoteReadCount = new AtomicInteger();
    private final AtomicInteger writerRemoteReadCount = new AtomicInteger();
    private final AtomicInteger invalidFileCount = new AtomicInteger();
    private final AtomicInteger deletedFileCount = new AtomicInteger();
    private final AtomicInteger scheduledForCopyCount = new AtomicInteger();
    private final AtomicInteger copyInProgressCount = new AtomicInteger();
    private final AtomicInteger maxCopyInProgressCount = new AtomicInteger();
    private final AtomicInteger maxScheduledForCopyCount = new AtomicInteger();
    private final AtomicInteger uploadCount = new AtomicInteger();
    private final AtomicInteger downloadCount = new AtomicInteger();
    private final AtomicLong copyInProgressSize = new AtomicLong();
    private final AtomicLong downloadSize = new AtomicLong();
    private final AtomicLong uploadSize = new AtomicLong();
    private final AtomicLong garbageCollectedSize = new AtomicLong();
    private final AtomicLong skippedFromUploadSize = new AtomicLong();
    private final AtomicLong downloadTime = new AtomicLong();
    private final AtomicLong uploadTime = new AtomicLong();
    private final Map<String, String> indexPathMapping = Maps.newConcurrentMap();
    private final Map<String, Set<String>> sharedWorkingSetMap = Maps.newHashMap();
    private final Map<String, String> indexPathVersionMapping = Maps.newConcurrentMap();
    private final ConcurrentMap<String, LocalIndexFile> failedToDeleteFiles = Maps.newConcurrentMap();
    private final Set<LocalIndexFile> copyInProgressFiles = Collections.newSetFromMap(new ConcurrentHashMap());
    private final boolean prefetchEnabled;
    private volatile boolean closed;

    public IndexCopier(Executor executor, File indexRootDir) throws IOException {
        this(executor, indexRootDir, false);
    }

    public IndexCopier(Executor executor, File indexRootDir, boolean prefetchEnabled) throws IOException {
        this.executor = executor;
        this.indexRootDir = indexRootDir;
        this.prefetchEnabled = prefetchEnabled;
        this.indexWorkDir = IndexCopier.initializerWorkDir(indexRootDir);
    }

    public Directory wrapForRead(String indexPath, IndexDefinition definition, Directory remote) throws IOException {
        Directory local = this.createLocalDirForIndexReader(indexPath, definition);
        return new CopyOnReadDirectory(remote, local, this.prefetchEnabled, indexPath, this.getSharedWorkingSet(definition));
    }

    public Directory wrapForWrite(IndexDefinition definition, Directory remote, boolean reindexMode) throws IOException {
        Directory local = this.createLocalDirForIndexWriter(definition);
        return new CopyOnWriteDirectory(remote, local, reindexMode, IndexCopier.getIndexPathForLogging(definition), this.getSharedWorkingSet(definition));
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    File getIndexWorkDir() {
        return this.indexWorkDir;
    }

    File getIndexRootDir() {
        return this.indexRootDir;
    }

    protected Directory createLocalDirForIndexWriter(IndexDefinition definition) throws IOException {
        File indexWriterDir;
        String indexPath = definition.getIndexPathFromConfig();
        if (indexPath == null) {
            indexWriterDir = new File(this.indexWorkDir, String.valueOf(UNIQUE_COUNTER.incrementAndGet()));
        } else {
            File indexDir = this.getIndexDir(indexPath);
            String newVersion = String.valueOf(definition.getReindexCount());
            indexWriterDir = this.getVersionedDir(indexPath, indexDir, newVersion);
        }
        Directory dir = FSDirectory.open(indexWriterDir, NoLockFactory.getNoLockFactory());
        this.log.debug("IndexWriter would use {}", (Object)indexWriterDir);
        if (indexPath == null) {
            dir = new DeleteOldDirOnClose(dir, indexWriterDir);
            this.log.debug("IndexPath [{}] not configured in index definition {}. Writer would create index files in temporary dir {} which would be deleted upon close. For better performance do configure the 'indexPath' as part of your index definition", new Object[]{"indexPath", definition, indexWriterDir});
        }
        return dir;
    }

    protected Directory createLocalDirForIndexReader(String indexPath, IndexDefinition definition) throws IOException {
        File indexDir = this.getIndexDir(indexPath);
        String newVersion = String.valueOf(definition.getReindexCount());
        File versionedIndexDir = this.getVersionedDir(indexPath, indexDir, newVersion);
        Directory result = FSDirectory.open(versionedIndexDir);
        String oldVersion = this.indexPathVersionMapping.put(indexPath, newVersion);
        if (!newVersion.equals(oldVersion) && oldVersion != null) {
            result = new DeleteOldDirOnClose(result, new File(indexDir, oldVersion));
        }
        return result;
    }

    private File getVersionedDir(String indexPath, File indexDir, String newVersion) {
        File versionedIndexDir = new File(indexDir, newVersion);
        if (!versionedIndexDir.exists()) {
            Preconditions.checkState((boolean)versionedIndexDir.mkdirs(), (String)"Cannot create directory %s", (Object[])new Object[]{versionedIndexDir});
        }
        this.indexPathMapping.put(indexPath, indexDir.getAbsolutePath());
        return versionedIndexDir;
    }

    public File getIndexDir(String indexPath) {
        String subDir = Hashing.sha256().hashString((CharSequence)indexPath, Charsets.UTF_8).toString();
        return new File(this.indexRootDir, subDir);
    }

    Map<String, LocalIndexFile> getFailedToDeleteFiles() {
        return Collections.unmodifiableMap(this.failedToDeleteFiles);
    }

    private void failedToDelete(LocalIndexFile file) {
        if (this.failedToDeleteFiles.size() < 10000) {
            LocalIndexFile failedToDeleteFile = this.failedToDeleteFiles.putIfAbsent(file.getKey(), file);
            if (failedToDeleteFile == null) {
                failedToDeleteFile = file;
            }
            failedToDeleteFile.incrementAttemptToDelete();
        } else {
            this.log.warn("Not able to delete {}. Currently more than {} file with total size {} are pending delete.", new Object[]{file.deleteLog(), this.failedToDeleteFiles.size(), this.getGarbageSize()});
        }
    }

    private void successfullyDeleted(LocalIndexFile file, boolean fileExisted) {
        LocalIndexFile failedToDeleteFile = (LocalIndexFile)this.failedToDeleteFiles.remove(file.getKey());
        if (failedToDeleteFile != null) {
            this.log.debug("Deleted : {}", (Object)failedToDeleteFile.deleteLog());
        }
        if (fileExisted) {
            this.garbageCollectedSize.addAndGet(file.size);
            this.deletedFileCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getSharedWorkingSet(IndexDefinition defn) {
        Set sharedSet;
        String indexPath = defn.getIndexPathFromConfig();
        if (indexPath == null) {
            return new HashSet<String>();
        }
        Map<String, Set<String>> map = this.sharedWorkingSetMap;
        synchronized (map) {
            sharedSet = this.sharedWorkingSetMap.get(indexPath);
            if (sharedSet == null) {
                sharedSet = Sets.newConcurrentHashSet();
                this.sharedWorkingSetMap.put(indexPath, sharedSet);
            }
        }
        return sharedSet;
    }

    private static File initializerWorkDir(File indexRootDir) throws IOException {
        File workDir = new File(indexRootDir, WORK_DIR_NAME);
        FileUtils.deleteDirectory((File)workDir);
        Preconditions.checkState((boolean)workDir.mkdirs(), (String)"Cannot create directory %s", (Object[])new Object[]{workDir});
        return workDir;
    }

    private static String getIndexPathForLogging(IndexDefinition defn) {
        String indexPath = defn.getIndexPathFromConfig();
        if (indexPath == null) {
            return "UNKNOWN";
        }
        return indexPath;
    }

    private boolean deleteFile(Directory dir, String fileName, boolean copiedFromRemote) {
        LocalIndexFile file = new LocalIndexFile(dir, fileName, IndexCopier.getFileLength(dir, fileName), copiedFromRemote);
        boolean successFullyDeleted = false;
        try {
            boolean fileExisted = false;
            if (dir.fileExists(fileName)) {
                fileExisted = true;
                dir.deleteFile(fileName);
            }
            this.successfullyDeleted(file, fileExisted);
            successFullyDeleted = true;
        }
        catch (IOException e) {
            this.failedToDelete(file);
            this.log.debug("Error occurred while removing deleted file {} from Local {}. Attempt would be made to delete it on next run ", new Object[]{fileName, dir, e});
        }
        return successFullyDeleted;
    }

    private long startCopy(LocalIndexFile file) {
        this.updateMaxInProgress(this.copyInProgressCount.incrementAndGet());
        this.copyInProgressSize.addAndGet(file.size);
        this.copyInProgressFiles.add(file);
        return System.currentTimeMillis();
    }

    private void doneCopy(LocalIndexFile file, long start) {
        this.copyInProgressFiles.remove(file);
        this.copyInProgressCount.decrementAndGet();
        this.copyInProgressSize.addAndGet(-file.size);
        if (file.copyFromRemote) {
            this.downloadTime.addAndGet(System.currentTimeMillis() - start);
            this.downloadSize.addAndGet(file.size);
            this.downloadCount.incrementAndGet();
        } else {
            this.uploadSize.addAndGet(file.size);
            this.uploadTime.addAndGet(System.currentTimeMillis() - start);
            this.uploadCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxScheduled(int val) {
        AtomicInteger atomicInteger = this.maxScheduledForCopyCount;
        synchronized (atomicInteger) {
            int current = this.maxScheduledForCopyCount.get();
            if (val > current) {
                this.maxScheduledForCopyCount.set(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxInProgress(int val) {
        AtomicInteger atomicInteger = this.maxCopyInProgressCount;
        synchronized (atomicInteger) {
            int current = this.maxCopyInProgressCount.get();
            if (val > current) {
                this.maxCopyInProgressCount.set(val);
            }
        }
    }

    static File getFSDir(Directory dir) {
        if (dir instanceof FilterDirectory) {
            dir = ((FilterDirectory)dir).getDelegate();
        }
        if (dir instanceof FSDirectory) {
            return ((FSDirectory)dir).getDirectory();
        }
        return null;
    }

    private static long getFileLength(Directory dir, String fileName) {
        try {
            return dir.fileLength(fileName);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public TabularData getIndexPathMapping() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(IndexMappingData.class.getName(), "Lucene Index Stats", IndexMappingData.TYPE, new String[]{"jcrPath"});
            tds = new TabularDataSupport(tt);
            for (Map.Entry<String, String> e : this.indexPathMapping.entrySet()) {
                String size = IOUtils.humanReadableByteCount((long)FileUtils.sizeOfDirectory((File)new File(e.getValue())));
                tds.put(new CompositeDataSupport(IndexMappingData.TYPE, IndexMappingData.FIELD_NAMES, new String[]{e.getKey(), e.getValue(), size}));
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public boolean isPrefetchEnabled() {
        return this.prefetchEnabled;
    }

    @Override
    public int getReaderLocalReadCount() {
        return this.readerLocalReadCount.get();
    }

    @Override
    public int getReaderRemoteReadCount() {
        return this.readerRemoteReadCount.get();
    }

    @Override
    public int getWriterLocalReadCount() {
        return this.writerLocalReadCount.get();
    }

    @Override
    public int getWriterRemoteReadCount() {
        return this.writerRemoteReadCount.get();
    }

    public int getInvalidFileCount() {
        return this.invalidFileCount.get();
    }

    @Override
    public String getDownloadSize() {
        return IOUtils.humanReadableByteCount((long)this.downloadSize.get());
    }

    @Override
    public long getDownloadTime() {
        return this.downloadTime.get();
    }

    @Override
    public int getDownloadCount() {
        return this.downloadCount.get();
    }

    @Override
    public int getUploadCount() {
        return this.uploadCount.get();
    }

    @Override
    public String getUploadSize() {
        return IOUtils.humanReadableByteCount((long)this.uploadSize.get());
    }

    @Override
    public long getUploadTime() {
        return this.uploadTime.get();
    }

    @Override
    public String getLocalIndexSize() {
        return IOUtils.humanReadableByteCount((long)FileUtils.sizeOfDirectory((File)this.indexRootDir));
    }

    @Override
    public String[] getGarbageDetails() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform(this.failedToDeleteFiles.values(), (Function)new Function<LocalIndexFile, String>(){

            public String apply(LocalIndexFile input) {
                return input.deleteLog();
            }
        }), String.class);
    }

    @Override
    public String getGarbageSize() {
        long garbageSize = 0L;
        for (LocalIndexFile failedToDeleteFile : this.failedToDeleteFiles.values()) {
            garbageSize += failedToDeleteFile.size;
        }
        return IOUtils.humanReadableByteCount((long)garbageSize);
    }

    @Override
    public int getScheduledForCopyCount() {
        return this.scheduledForCopyCount.get();
    }

    @Override
    public int getCopyInProgressCount() {
        return this.copyInProgressCount.get();
    }

    @Override
    public String getCopyInProgressSize() {
        return IOUtils.humanReadableByteCount((long)this.copyInProgressSize.get());
    }

    @Override
    public int getMaxCopyInProgressCount() {
        return this.maxCopyInProgressCount.get();
    }

    @Override
    public int getMaxScheduledForCopyCount() {
        return this.maxScheduledForCopyCount.get();
    }

    @Override
    public String getSkippedFromUploadSize() {
        return IOUtils.humanReadableByteCount((long)this.skippedFromUploadSize.get());
    }

    @Override
    public String[] getCopyInProgressDetails() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform(this.copyInProgressFiles, (Function)new Function<LocalIndexFile, String>(){

            public String apply(LocalIndexFile input) {
                return input.copyLog();
            }
        }), String.class);
    }

    @Override
    public int getDeletedFilesCount() {
        return this.deletedFileCount.get();
    }

    @Override
    public String getGarbageCollectedSize() {
        return IOUtils.humanReadableByteCount((long)this.garbageCollectedSize.get());
    }

    private static class IndexMappingData {
        static final String[] FIELD_NAMES = new String[]{"jcrPath", "fsPath", "size"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"JCR Path", "Filesystem Path", "Size"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        static final CompositeType TYPE = IndexMappingData.createCompositeType();

        private IndexMappingData() {
        }

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(IndexMappingData.class.getName(), "Composite data type for Index Mapping Data", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static final class LocalIndexFile {
        final File dir;
        final String name;
        final long size;
        final boolean copyFromRemote;
        private volatile int deleteAttemptCount;
        final long creationTime = System.currentTimeMillis();

        public LocalIndexFile(Directory dir, String fileName, long size, boolean copyFromRemote) {
            this.copyFromRemote = copyFromRemote;
            this.dir = IndexCopier.getFSDir(dir);
            this.name = fileName;
            this.size = size;
        }

        public LocalIndexFile(Directory dir, String fileName) {
            this(dir, fileName, IndexCopier.getFileLength(dir, fileName), true);
        }

        public String getKey() {
            if (this.dir != null) {
                return new File(this.dir, this.name).getAbsolutePath();
            }
            return this.name;
        }

        public void incrementAttemptToDelete() {
            ++this.deleteAttemptCount;
        }

        public int getDeleteAttemptCount() {
            return this.deleteAttemptCount;
        }

        public String deleteLog() {
            return String.format("%s (%s, %d attempts, %d s)", this.name, IOUtils.humanReadableByteCount((long)this.size), this.deleteAttemptCount, this.timeTaken());
        }

        public String copyLog() {
            return String.format("%s (%s, %1.1f%%, %s, %d s)", this.name, IOUtils.humanReadableByteCount((long)this.actualSize()), Float.valueOf(this.copyProgress()), IOUtils.humanReadableByteCount((long)this.size), this.timeTaken());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalIndexFile localIndexFile = (LocalIndexFile)o;
            if (this.dir != null ? !this.dir.equals(localIndexFile.dir) : localIndexFile.dir != null) {
                return false;
            }
            return this.name.equals(localIndexFile.name);
        }

        public int hashCode() {
            int result = this.dir != null ? this.dir.hashCode() : 0;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        private long timeTaken() {
            return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.creationTime);
        }

        private float copyProgress() {
            return (float)this.actualSize() * 1.0f / (float)this.size * 100.0f;
        }

        private long actualSize() {
            return this.dir != null ? new File(this.dir, this.name).length() : 0L;
        }
    }

    private class DeleteOldDirOnClose
    extends FilterDirectory {
        private final File oldIndexDir;

        protected DeleteOldDirOnClose(Directory in, File oldIndexDir) {
            super(in);
            this.oldIndexDir = oldIndexDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)this.oldIndexDir);
                    IndexCopier.this.log.debug("Removed old index content from {} ", (Object)this.oldIndexDir);
                }
                catch (IOException e) {
                    IndexCopier.this.log.warn("Not able to remove old version of copied index at {}", (Object)this.oldIndexDir, (Object)e);
                }
            }
        }

        @Override
        public String toString() {
            return "DeleteOldDirOnClose wrapper for " + this.getDelegate();
        }
    }

    private class CopyOnWriteDirectory
    extends FilterDirectory {
        private final Callable<Void> STOP;
        private final Directory remote;
        private final Directory local;
        private final ConcurrentMap<String, COWFileReference> fileMap;
        private final Set<String> deletedFilesLocal;
        private final Set<String> skippedFiles;
        private final BlockingQueue<Callable<Void>> queue;
        private final AtomicReference<Throwable> errorInCopy;
        private final CountDownLatch copyDone;
        private final boolean reindexMode;
        private final String indexPathForLogging;
        private final Set<String> sharedWorkingSet;
        private volatile NotifyingFutureTask currentTask;
        private final Runnable completionHandler;

        public CopyOnWriteDirectory(Directory remote, Directory local, boolean reindexMode, String indexPathForLogging, Set<String> sharedWorkingSet) throws IOException {
            super(local);
            this.STOP = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    return null;
                }
            };
            this.fileMap = Maps.newConcurrentMap();
            this.deletedFilesLocal = Sets.newConcurrentHashSet();
            this.skippedFiles = Sets.newConcurrentHashSet();
            this.queue = new LinkedBlockingQueue<Callable<Void>>();
            this.errorInCopy = new AtomicReference();
            this.copyDone = new CountDownLatch(1);
            this.currentTask = NotifyingFutureTask.completed();
            this.completionHandler = new Runnable(){
                Callable<Void> task = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            Callable task = (Callable)CopyOnWriteDirectory.this.queue.poll();
                            if (task != null && task != CopyOnWriteDirectory.this.STOP) {
                                if (CopyOnWriteDirectory.this.errorInCopy.get() != null) {
                                    IndexCopier.this.log.trace("[COW][{}] Skipping task {} as some exception occurred in previous run", (Object)CopyOnWriteDirectory.this.indexPathForLogging, (Object)task);
                                } else {
                                    task.call();
                                }
                                CopyOnWriteDirectory.this.currentTask.onComplete(CopyOnWriteDirectory.this.completionHandler);
                            }
                            if (task == CopyOnWriteDirectory.this.STOP) {
                                CopyOnWriteDirectory.this.copyDone.countDown();
                            }
                        }
                        catch (Throwable t) {
                            CopyOnWriteDirectory.this.errorInCopy.set(t);
                            IndexCopier.this.log.debug("[COW][{}] Error occurred while copying files. Further processing would be skipped", (Object)CopyOnWriteDirectory.this.indexPathForLogging, (Object)t);
                            CopyOnWriteDirectory.this.currentTask.onComplete(CopyOnWriteDirectory.this.completionHandler);
                        }
                        return null;
                    }
                };

                @Override
                public void run() {
                    CopyOnWriteDirectory.this.currentTask = new NotifyingFutureTask(this.task);
                    try {
                        IndexCopier.this.executor.execute((Runnable)CopyOnWriteDirectory.this.currentTask);
                    }
                    catch (RejectedExecutionException e) {
                        CopyOnWriteDirectory.this.checkIfClosed(false);
                        throw e;
                    }
                }
            };
            this.remote = remote;
            this.local = local;
            this.indexPathForLogging = indexPathForLogging;
            this.reindexMode = reindexMode;
            this.sharedWorkingSet = sharedWorkingSet;
            this.initialize();
        }

        @Override
        public String[] listAll() throws IOException {
            return (String[])Iterables.toArray(this.fileMap.keySet(), String.class);
        }

        @Override
        public boolean fileExists(String name) throws IOException {
            return this.fileMap.containsKey(name);
        }

        @Override
        public void deleteFile(String name) throws IOException {
            IndexCopier.this.log.trace("[COW][{}] Deleted file {}", (Object)this.indexPathForLogging, (Object)name);
            COWFileReference ref = (COWFileReference)this.fileMap.remove(name);
            if (ref != null) {
                ref.delete();
            }
        }

        @Override
        public long fileLength(String name) throws IOException {
            COWFileReference ref = (COWFileReference)this.fileMap.get(name);
            if (ref == null) {
                throw new FileNotFoundException(name);
            }
            return ref.fileLength();
        }

        @Override
        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            COWFileReference ref = (COWFileReference)this.fileMap.remove(name);
            if (ref != null) {
                ref.delete();
            }
            ref = new COWLocalFileReference(name);
            this.fileMap.put(name, ref);
            this.sharedWorkingSet.add(name);
            return ref.createOutput(context);
        }

        @Override
        public void sync(Collection<String> names) throws IOException {
            for (String name : names) {
                COWFileReference file = (COWFileReference)this.fileMap.get(name);
                if (file == null) continue;
                file.sync();
            }
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            COWFileReference ref = (COWFileReference)this.fileMap.get(name);
            if (ref == null) {
                throw new FileNotFoundException(name);
            }
            return ref.openInput(context);
        }

        @Override
        public void close() throws IOException {
            int pendingCopies = this.queue.size();
            this.addTask(this.STOP);
            try {
                long start = IndexCopier.this.PERF_LOGGER.start();
                while (!this.copyDone.await(10L, TimeUnit.SECONDS)) {
                    if (!IndexCopier.this.closed) continue;
                    throw new IndexCopierClosedException("IndexCopier found to be closed while processing copy task for" + this.remote.toString());
                }
                IndexCopier.this.PERF_LOGGER.end(start, -1L, "[COW][{}] Completed pending copying task {}", (Object)this.indexPathForLogging, (Object)pendingCopies);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            Throwable t = this.errorInCopy.get();
            if (t != null) {
                throw new IOException("Error occurred while copying files for " + this.indexPathForLogging, t);
            }
            Preconditions.checkArgument((boolean)this.queue.isEmpty(), (String)"Copy queue still has pending task left [%d]. %s", (Object[])new Object[]{this.queue.size(), this.queue});
            long skippedFilesSize = this.getSkippedFilesSize();
            for (String fileName : this.deletedFilesLocal) {
                this.deleteLocalFile(fileName);
            }
            IndexCopier.this.skippedFromUploadSize.addAndGet(skippedFilesSize);
            String msg = "[COW][{}] CopyOnWrite stats : Skipped copying {} files with total size {}";
            if (this.reindexMode || skippedFilesSize > 0xA00000L) {
                IndexCopier.this.log.info(msg, new Object[]{this.indexPathForLogging, this.skippedFiles.size(), IOUtils.humanReadableByteCount((long)skippedFilesSize)});
            } else {
                IndexCopier.this.log.debug(msg, new Object[]{this.indexPathForLogging, this.skippedFiles.size(), IOUtils.humanReadableByteCount((long)skippedFilesSize)});
            }
            if (IndexCopier.this.log.isTraceEnabled()) {
                IndexCopier.this.log.trace("[COW][{}] File listing - Upon completion {}", (Object)this.indexPathForLogging, (Object)Arrays.toString(this.remote.listAll()));
            }
            this.local.close();
            this.remote.close();
            this.sharedWorkingSet.clear();
        }

        @Override
        public String toString() {
            return String.format("[COW][%s] Local %s, Remote %s", this.indexPathForLogging, this.local, this.remote);
        }

        private long getSkippedFilesSize() {
            long size = 0L;
            for (String name : this.skippedFiles) {
                try {
                    if (!this.local.fileExists(name)) continue;
                    size += this.local.fileLength(name);
                }
                catch (Exception ignore) {}
            }
            return size;
        }

        private void deleteLocalFile(String fileName) {
            IndexCopier.this.deleteFile(this.local, fileName, false);
        }

        private void initialize() throws IOException {
            for (String name : this.remote.listAll()) {
                this.fileMap.put(name, new COWRemoteFileReference(name));
            }
            if (IndexCopier.this.log.isTraceEnabled()) {
                IndexCopier.this.log.trace("[COW][{}] File listing - At start {}", (Object)this.indexPathForLogging, (Object)Arrays.toString(this.remote.listAll()));
            }
        }

        private void addCopyTask(final String name) {
            IndexCopier.this.updateMaxScheduled(IndexCopier.this.scheduledForCopyCount.incrementAndGet());
            this.addTask(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IndexCopier.this.scheduledForCopyCount.decrementAndGet();
                    if (CopyOnWriteDirectory.this.deletedFilesLocal.contains(name)) {
                        CopyOnWriteDirectory.this.skippedFiles.add(name);
                        IndexCopier.this.log.trace("[COW][{}] Skip copying of deleted file {}", (Object)CopyOnWriteDirectory.this.indexPathForLogging, (Object)name);
                        return null;
                    }
                    long fileSize = CopyOnWriteDirectory.this.local.fileLength(name);
                    LocalIndexFile file = new LocalIndexFile(CopyOnWriteDirectory.this.local, name, fileSize, false);
                    long perfStart = IndexCopier.this.PERF_LOGGER.start();
                    long start = IndexCopier.this.startCopy(file);
                    CopyOnWriteDirectory.this.local.copy(CopyOnWriteDirectory.this.remote, name, name, IOContext.DEFAULT);
                    IndexCopier.this.doneCopy(file, start);
                    IndexCopier.this.PERF_LOGGER.end(perfStart, 0L, "[COW][{}] Copied to remote {} -- size: {}", new Object[]{CopyOnWriteDirectory.this.indexPathForLogging, name, IOUtils.humanReadableByteCount((long)fileSize)});
                    return null;
                }

                public String toString() {
                    return "Copy: " + name;
                }
            });
        }

        private void addDeleteTask(final String name) {
            this.addTask(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (!CopyOnWriteDirectory.this.skippedFiles.contains(name)) {
                        IndexCopier.this.log.trace("[COW][{}] Marking as deleted {}", (Object)CopyOnWriteDirectory.this.indexPathForLogging, (Object)name);
                        CopyOnWriteDirectory.this.remote.deleteFile(name);
                    }
                    return null;
                }

                public String toString() {
                    return "Delete : " + name;
                }
            });
        }

        private void addTask(Callable<Void> task) {
            this.checkIfClosed(true);
            this.queue.add(task);
            this.currentTask.onComplete(this.completionHandler);
        }

        private void checkIfClosed(boolean throwException) {
            if (IndexCopier.this.closed) {
                IndexCopierClosedException e = new IndexCopierClosedException("IndexCopier found to be closed while processing" + this.remote.toString());
                this.errorInCopy.set(e);
                this.copyDone.countDown();
                if (throwException) {
                    throw e;
                }
            }
        }

        private class COWLocalFileReference
        extends COWFileReference {
            public COWLocalFileReference(String name) {
                super(name);
            }

            @Override
            public long fileLength() throws IOException {
                return CopyOnWriteDirectory.this.local.fileLength(this.name);
            }

            @Override
            public IndexInput openInput(IOContext context) throws IOException {
                return CopyOnWriteDirectory.this.local.openInput(this.name, context);
            }

            @Override
            public IndexOutput createOutput(IOContext context) throws IOException {
                IndexCopier.this.log.debug("[COW][{}] Creating output {}", (Object)CopyOnWriteDirectory.this.indexPathForLogging, (Object)this.name);
                return new CopyOnCloseIndexOutput(CopyOnWriteDirectory.this.local.createOutput(this.name, context));
            }

            @Override
            public void delete() throws IOException {
                CopyOnWriteDirectory.this.addDeleteTask(this.name);
                CopyOnWriteDirectory.this.deletedFilesLocal.add(this.name);
            }

            @Override
            public void sync() throws IOException {
                CopyOnWriteDirectory.this.local.sync(Collections.singleton(this.name));
            }

            private class CopyOnCloseIndexOutput
            extends IndexOutput {
                private final IndexOutput delegate;

                public CopyOnCloseIndexOutput(IndexOutput delegate) {
                    this.delegate = delegate;
                }

                @Override
                public void flush() throws IOException {
                    this.delegate.flush();
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    CopyOnWriteDirectory.this.addCopyTask(COWLocalFileReference.this.name);
                }

                @Override
                public long getFilePointer() {
                    return this.delegate.getFilePointer();
                }

                @Override
                public void seek(long pos) throws IOException {
                    this.delegate.seek(pos);
                }

                @Override
                public long length() throws IOException {
                    return this.delegate.length();
                }

                @Override
                public void writeByte(byte b) throws IOException {
                    this.delegate.writeByte(b);
                }

                @Override
                public void writeBytes(byte[] b, int offset, int length) throws IOException {
                    this.delegate.writeBytes(b, offset, length);
                }

                @Override
                public void setLength(long length) throws IOException {
                    this.delegate.setLength(length);
                }
            }
        }

        private class COWRemoteFileReference
        extends COWFileReference {
            private boolean validLocalCopyPresent;
            private final long length;

            public COWRemoteFileReference(String name) throws IOException {
                super(name);
                this.length = CopyOnWriteDirectory.this.remote.fileLength(name);
            }

            @Override
            public long fileLength() throws IOException {
                return this.length;
            }

            @Override
            public IndexInput openInput(IOContext context) throws IOException {
                this.checkIfLocalValid();
                if (this.validLocalCopyPresent && !REMOTE_ONLY.contains(this.name)) {
                    IndexCopier.this.writerLocalReadCount.incrementAndGet();
                    return CopyOnWriteDirectory.this.local.openInput(this.name, context);
                }
                IndexCopier.this.writerRemoteReadCount.incrementAndGet();
                return CopyOnWriteDirectory.this.remote.openInput(this.name, context);
            }

            @Override
            public IndexOutput createOutput(IOContext context) throws IOException {
                throw new UnsupportedOperationException("Cannot create output for existing remote file " + this.name);
            }

            @Override
            public void delete() throws IOException {
                CopyOnWriteDirectory.this.addDeleteTask(this.name);
            }

            private void checkIfLocalValid() throws IOException {
                this.validLocalCopyPresent = CopyOnWriteDirectory.this.local.fileExists(this.name) && CopyOnWriteDirectory.this.local.fileLength(this.name) == CopyOnWriteDirectory.this.remote.fileLength(this.name);
            }
        }

        private abstract class COWFileReference {
            protected final String name;

            public COWFileReference(String name) {
                this.name = name;
            }

            public abstract long fileLength() throws IOException;

            public abstract IndexInput openInput(IOContext var1) throws IOException;

            public abstract IndexOutput createOutput(IOContext var1) throws IOException;

            public abstract void delete() throws IOException;

            public void sync() throws IOException {
            }
        }
    }

    class CopyOnReadDirectory
    extends FilterDirectory {
        private final Directory remote;
        private final Directory local;
        private final String indexPath;
        private final ConcurrentMap<String, CORFileReference> files;
        private final Set<String> localFileNames;

        public CopyOnReadDirectory(Directory remote, Directory local, boolean prefetch, String indexPath, Set<String> sharedWorkingSet) throws IOException {
            super(remote);
            this.files = Maps.newConcurrentMap();
            this.localFileNames = Sets.newConcurrentHashSet();
            this.remote = remote;
            this.local = local;
            this.indexPath = indexPath;
            this.localFileNames.addAll(Arrays.asList(local.listAll()));
            this.localFileNames.removeAll(sharedWorkingSet);
            if (prefetch) {
                this.prefetchIndexFiles();
            }
        }

        @Override
        public void deleteFile(String name) throws IOException {
            throw new UnsupportedOperationException("Cannot delete in a ReadOnly directory");
        }

        @Override
        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            throw new UnsupportedOperationException("Cannot write in a ReadOnly directory");
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (REMOTE_ONLY.contains(name)) {
                IndexCopier.this.log.trace("[{}] opening remote only file {}", (Object)this.indexPath, (Object)name);
                return this.remote.openInput(name, context);
            }
            CORFileReference ref = (CORFileReference)this.files.get(name);
            if (ref != null) {
                if (ref.isLocalValid()) {
                    IndexCopier.this.log.trace("[{}] opening existing local file {}", (Object)this.indexPath, (Object)name);
                    return ((CORFileReference)this.files.get(name)).openLocalInput(context);
                }
                IndexCopier.this.readerRemoteReadCount.incrementAndGet();
                IndexCopier.this.log.trace("[{}] opening existing remote file as local version is not valid {}", (Object)this.indexPath, (Object)name);
                return this.remote.openInput(name, context);
            }
            if (!this.remote.fileExists(name)) {
                if (IndexCopier.this.log.isDebugEnabled()) {
                    IndexCopier.this.log.debug("[{}] Looking for non existent file {}. Current known files {}", new Object[]{this.indexPath, name, Arrays.toString(this.remote.listAll())});
                }
                return this.remote.openInput(name, context);
            }
            CORFileReference toPut = new CORFileReference(name);
            CORFileReference old = this.files.putIfAbsent(name, toPut);
            if (old == null) {
                IndexCopier.this.log.trace("[{}] scheduled local copy for {}", (Object)this.indexPath, (Object)name);
                this.copy(toPut);
            }
            if (toPut.isLocalValid()) {
                IndexCopier.this.log.trace("[{}] opening new local file {}", (Object)this.indexPath, (Object)name);
                return toPut.openLocalInput(context);
            }
            IndexCopier.this.log.trace("[{}] opening new remote file {}", (Object)this.indexPath, (Object)name);
            IndexCopier.this.readerRemoteReadCount.incrementAndGet();
            return this.remote.openInput(name, context);
        }

        Directory getLocal() {
            return this.local;
        }

        private void copy(final CORFileReference reference) {
            IndexCopier.this.updateMaxScheduled(IndexCopier.this.scheduledForCopyCount.incrementAndGet());
            IndexCopier.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    IndexCopier.this.scheduledForCopyCount.decrementAndGet();
                    CopyOnReadDirectory.this.copyFilesToLocal(reference, true);
                }
            });
        }

        private void prefetchIndexFiles() throws IOException {
            long start = IndexCopier.this.PERF_LOGGER.start();
            long totalSize = 0L;
            int copyCount = 0;
            for (String name : this.remote.listAll()) {
                if (REMOTE_ONLY.contains(name)) continue;
                CORFileReference fileRef = new CORFileReference(name);
                this.files.putIfAbsent(name, fileRef);
                long fileSize = this.copyFilesToLocal(fileRef, false);
                if (fileSize <= 0L) continue;
                ++copyCount;
                totalSize += fileSize;
            }
            IndexCopier.this.PERF_LOGGER.end(start, -1L, "[{}] Copied {} files totaling {}", new Object[]{this.indexPath, copyCount, IOUtils.humanReadableByteCount((long)totalSize)});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private long copyFilesToLocal(CORFileReference reference, boolean logDuration) {
            long fileSize;
            block20: {
                String name = reference.name;
                boolean success = false;
                boolean copyAttempted = false;
                fileSize = 0L;
                if (!this.local.fileExists(name)) {
                    long perfStart = -1L;
                    if (logDuration) {
                        perfStart = IndexCopier.this.PERF_LOGGER.start();
                    }
                    fileSize = this.remote.fileLength(name);
                    LocalIndexFile file = new LocalIndexFile(this.local, name, fileSize, true);
                    long start = IndexCopier.this.startCopy(file);
                    copyAttempted = true;
                    this.remote.copy(this.local, name, name, IOContext.READ);
                    reference.markValid();
                    IndexCopier.this.doneCopy(file, start);
                    if (logDuration) {
                        IndexCopier.this.PERF_LOGGER.end(perfStart, 0L, "[{}] Copied file {} of size {}", new Object[]{this.indexPath, name, IOUtils.humanReadableByteCount((long)fileSize)});
                    }
                } else {
                    long remoteLength;
                    long localLength = this.local.fileLength(name);
                    if (localLength != (remoteLength = this.remote.fileLength(name))) {
                        IndexCopier.this.log.warn("[{}] Found local copy for {} in {} but size of local {} differs from remote {}. Content would be read from remote file only", new Object[]{this.indexPath, name, this.local, localLength, remoteLength});
                        IndexCopier.this.invalidFileCount.incrementAndGet();
                    } else {
                        reference.markValid();
                        IndexCopier.this.log.trace("[{}] found local copy of file {}", (Object)this.indexPath, (Object)name);
                    }
                }
                success = true;
                if (!copyAttempted || success) break block20;
                try {
                    if (this.local.fileExists(name)) {
                        this.local.deleteFile(name);
                    }
                    break block20;
                }
                catch (IOException e) {
                    IndexCopier.this.log.warn("[{}] Error occurred while deleting corrupted file [{}] from [{}]", new Object[]{this.indexPath, name, this.local, e});
                }
                break block20;
                catch (IOException e) {
                    try {
                        IndexCopier.this.log.warn("[{}] Error occurred while copying file [{}] from {} to {}", new Object[]{this.indexPath, name, this.remote, this.local, e});
                        if (!copyAttempted || success) break block20;
                    }
                    catch (Throwable throwable) {
                        if (copyAttempted && !success) {
                            try {
                                if (this.local.fileExists(name)) {
                                    this.local.deleteFile(name);
                                }
                            }
                            catch (IOException e2) {
                                IndexCopier.this.log.warn("[{}] Error occurred while deleting corrupted file [{}] from [{}]", new Object[]{this.indexPath, name, this.local, e2});
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (this.local.fileExists(name)) {
                            this.local.deleteFile(name);
                        }
                    }
                    catch (IOException e3) {
                        IndexCopier.this.log.warn("[{}] Error occurred while deleting corrupted file [{}] from [{}]", new Object[]{this.indexPath, name, this.local, e3});
                    }
                }
            }
            return fileSize;
        }

        @Override
        public void close() throws IOException {
            IndexCopier.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        CopyOnReadDirectory.this.removeDeletedFiles();
                    }
                    catch (IOException e) {
                        IndexCopier.this.log.warn("[{}] Error occurred while removing deleted files from Local {}, Remote {}", new Object[]{CopyOnReadDirectory.this.indexPath, CopyOnReadDirectory.this.local, CopyOnReadDirectory.this.remote, e});
                    }
                    try {
                        CopyOnReadDirectory.this.local.close();
                        CopyOnReadDirectory.this.remote.close();
                    }
                    catch (IOException e) {
                        IndexCopier.this.log.warn("[{}] Error occurred while closing directory ", (Object)CopyOnReadDirectory.this.indexPath, (Object)e);
                    }
                }
            });
        }

        @Override
        public String toString() {
            return String.format("[COR] Local %s, Remote %s", this.local, this.remote);
        }

        private void removeDeletedFiles() throws IOException {
            Object filesToBeDeleted = Sets.difference((Set)ImmutableSet.copyOf(this.localFileNames), (Set)ImmutableSet.copyOf((Object[])this.remote.listAll()));
            HashSet failedToDelete = Sets.newHashSet();
            Iterator i$ = filesToBeDeleted.iterator();
            while (i$.hasNext()) {
                String fileName = (String)i$.next();
                boolean deleted = IndexCopier.this.deleteFile(this.local, fileName, true);
                if (deleted) continue;
                failedToDelete.add(fileName);
            }
            filesToBeDeleted = new HashSet(filesToBeDeleted);
            filesToBeDeleted.removeAll(failedToDelete);
            if (!filesToBeDeleted.isEmpty()) {
                IndexCopier.this.log.debug("[{}] Following files have been removed from Lucene index directory {}", (Object)this.indexPath, filesToBeDeleted);
            }
        }

        private class CORFileReference {
            final String name;
            private volatile boolean valid;

            private CORFileReference(String name) {
                this.name = name;
            }

            boolean isLocalValid() {
                return this.valid;
            }

            IndexInput openLocalInput(IOContext context) throws IOException {
                IndexCopier.this.readerLocalReadCount.incrementAndGet();
                return CopyOnReadDirectory.this.local.openInput(this.name, context);
            }

            void markValid() {
                this.valid = true;
                CopyOnReadDirectory.this.localFileNames.add(this.name);
            }
        }
    }
}

