/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.ConfigUtil;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class Aggregate {
    public static final String MATCH_ALL = "*";
    public static final int RECURSIVE_AGGREGATION_LIMIT_DEFAULT = 5;
    private final String nodeTypeName;
    private final List<? extends Include> includes;
    final int reAggregationLimit;
    private final List<NodeInclude> relativeNodeIncludes;
    private final boolean nodeAggregates;

    Aggregate(String nodeTypeName) {
        this(nodeTypeName, Collections.emptyList());
    }

    Aggregate(String nodeTypeName, List<? extends Include> includes) {
        this(nodeTypeName, includes, 5);
    }

    Aggregate(String nodeTypeName, List<? extends Include> includes, int recursionLimit) {
        this.nodeTypeName = nodeTypeName;
        this.includes = ImmutableList.copyOf(includes);
        this.reAggregationLimit = recursionLimit;
        this.relativeNodeIncludes = Aggregate.findRelativeNodeIncludes(includes);
        this.nodeAggregates = Aggregate.hasNodeIncludes(includes);
    }

    public List<? extends Include> getIncludes() {
        return this.includes;
    }

    public void collectAggregates(NodeState root, ResultCollector collector) {
        if (Aggregate.matchingType(this.nodeTypeName, root)) {
            List<Matcher> matchers = this.createMatchers();
            Aggregate.collectAggregates(root, matchers, collector);
        }
    }

    public List<Matcher> createMatchers(AggregateRoot root) {
        ArrayList matchers = Lists.newArrayListWithCapacity((int)this.includes.size());
        for (Include include : this.includes) {
            matchers.add(new Matcher(this, include, root));
        }
        return matchers;
    }

    public boolean hasRelativeNodeInclude(String nodePath) {
        for (NodeInclude ni : this.relativeNodeIncludes) {
            if (!ni.matches(nodePath)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeAggregates() {
        return this.nodeAggregates;
    }

    public String toString() {
        return this.nodeTypeName;
    }

    private static boolean matchingType(String nodeTypeName, NodeState nodeState) {
        if (nodeTypeName.equals(ConfigUtil.getPrimaryTypeName(nodeState))) {
            return true;
        }
        for (String mixin : ConfigUtil.getMixinNames(nodeState)) {
            if (!nodeTypeName.equals(mixin)) continue;
            return true;
        }
        return false;
    }

    private static void collectAggregates(NodeState nodeState, List<Matcher> matchers, ResultCollector collector) {
        for (ChildNodeEntry cne : nodeState.getChildNodeEntries()) {
            ArrayList nextSet = Lists.newArrayListWithCapacity((int)matchers.size());
            for (Matcher m : matchers) {
                Matcher result = m.match(cne.getName(), cne.getNodeState());
                if (result.getStatus() == Matcher.Status.MATCH_FOUND) {
                    result.collectResults(collector);
                }
                if (result.getStatus() == Matcher.Status.FAIL) continue;
                nextSet.addAll(result.nextSet());
            }
            if (nextSet.isEmpty()) continue;
            Aggregate.collectAggregates(cne.getNodeState(), nextSet, collector);
        }
    }

    private List<Matcher> createMatchers() {
        ArrayList matchers = Lists.newArrayListWithCapacity((int)this.includes.size());
        for (Include include : this.includes) {
            matchers.add(new Matcher(this, include));
        }
        return matchers;
    }

    private static List<NodeInclude> findRelativeNodeIncludes(List<? extends Include> includes) {
        ArrayList result = Lists.newArrayList();
        for (Include include : includes) {
            if (!(include instanceof NodeInclude)) continue;
            NodeInclude ni = (NodeInclude)include;
            if (!ni.relativeNode) continue;
            result.add(ni);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private static boolean hasNodeIncludes(List<? extends Include> includes) {
        return Iterables.any(includes, (Predicate)new Predicate<Include>(){

            public boolean apply(Include input) {
                return input instanceof NodeInclude;
            }
        });
    }

    private static String[] computeElements(String path) {
        return (String[])Iterables.toArray((Iterable)PathUtils.elements((String)path), String.class);
    }

    public static class Matcher {
        private final RootState rootState;
        private final Include currentInclude;
        private final int depth;
        private final Status status;
        private final NodeState matchedNodeState;
        private final String currentPath;
        private final List<String> aggregateStack;

        public Matcher(Aggregate aggregate, Include currentInclude) {
            this(aggregate, currentInclude, null);
        }

        public Matcher(Aggregate aggregate, Include include, AggregateRoot root) {
            this.rootState = new RootState(root, aggregate, include);
            this.depth = 0;
            this.currentInclude = include;
            this.status = Status.CONTINUE;
            this.currentPath = null;
            this.matchedNodeState = null;
            this.aggregateStack = Collections.emptyList();
        }

        private Matcher(Matcher m, Status status, int depth) {
            Preconditions.checkArgument((status == Status.FAIL ? 1 : 0) != 0);
            this.rootState = m.rootState;
            this.depth = depth;
            this.currentInclude = m.currentInclude;
            this.status = status;
            this.currentPath = null;
            this.matchedNodeState = null;
            this.aggregateStack = m.aggregateStack;
        }

        private Matcher(Matcher m, Status status, int depth, NodeState matchedNodeState, String currentPath) {
            Preconditions.checkArgument((status != Status.FAIL ? 1 : 0) != 0);
            this.rootState = m.rootState;
            this.depth = depth;
            this.currentInclude = m.currentInclude;
            this.status = status;
            this.matchedNodeState = matchedNodeState;
            this.currentPath = currentPath;
            this.aggregateStack = m.aggregateStack;
        }

        private Matcher(Matcher m, Include i, String currentPath) {
            Preconditions.checkArgument((m.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            this.rootState = m.rootState;
            this.depth = 0;
            this.currentInclude = i;
            this.status = Status.CONTINUE;
            this.matchedNodeState = null;
            this.currentPath = currentPath;
            ArrayList paths = Lists.newArrayList(m.aggregateStack);
            paths.add(currentPath);
            this.aggregateStack = ImmutableList.copyOf((Collection)paths);
        }

        public Matcher match(String name, NodeState nodeState) {
            boolean result = this.currentInclude.match(name, nodeState, this.depth);
            if (result) {
                if (this.hasMore()) {
                    return new Matcher(this, Status.CONTINUE, this.depth, nodeState, this.path(name));
                }
                return new Matcher(this, Status.MATCH_FOUND, this.depth, nodeState, this.path(name));
            }
            return new Matcher(this, Status.FAIL, this.depth);
        }

        public Collection<Matcher> nextSet() {
            Preconditions.checkArgument((this.status != Status.FAIL ? 1 : 0) != 0);
            if (this.status == Status.MATCH_FOUND) {
                Aggregate nextAgg = this.currentInclude.getAggregate(this.matchedNodeState);
                if (nextAgg != null) {
                    int recursionLevel = this.aggregateStack.size() + 1;
                    if (recursionLevel >= this.rootState.rootAggregate.reAggregationLimit) {
                        return Collections.emptyList();
                    }
                    ArrayList result = Lists.newArrayListWithCapacity((int)nextAgg.includes.size());
                    for (Include i : nextAgg.includes) {
                        result.add(new Matcher(this, i, this.currentPath));
                    }
                    return result;
                }
                return Collections.emptyList();
            }
            return Collections.singleton(new Matcher(this, this.status, this.depth + 1, null, this.currentPath));
        }

        public void collectResults(ResultCollector results) {
            Preconditions.checkArgument((this.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            String rootIncludePath = this.aggregateStack.isEmpty() ? this.currentPath : this.aggregateStack.get(0);
            this.currentInclude.collectResults(this.rootState.rootInclude, rootIncludePath, this.currentPath, this.matchedNodeState, results);
        }

        public void markRootDirty() {
            Preconditions.checkArgument((this.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            this.rootState.root.markDirty();
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean aggregatesProperty(String name) {
            Preconditions.checkArgument((this.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            return this.currentInclude.aggregatesProperty(name);
        }

        private boolean hasMore() {
            return this.depth < this.currentInclude.maxDepth() - 1;
        }

        private String path(String nodeName) {
            if (this.currentPath == null) {
                return nodeName;
            }
            return PathUtils.concat((String)this.currentPath, (String)nodeName);
        }

        private static class RootState {
            final AggregateRoot root;
            final Aggregate rootAggregate;
            final Include rootInclude;

            private RootState(AggregateRoot root, Aggregate rootAggregate, Include rootInclude) {
                this.root = root;
                this.rootAggregate = rootAggregate;
                this.rootInclude = rootInclude;
            }
        }

        public static enum Status {
            CONTINUE,
            MATCH_FOUND,
            FAIL;

        }
    }

    public static interface AggregateRoot {
        public void markDirty();
    }

    public static class PropertyIncludeResult {
        final PropertyState propertyState;
        final PropertyDefinition pd;
        final String propertyPath;
        final String nodePath;

        public PropertyIncludeResult(PropertyState propertyState, PropertyDefinition pd, String parentPath) {
            this.propertyState = propertyState;
            this.pd = pd;
            this.nodePath = parentPath;
            this.propertyPath = PathUtils.concat((String)parentPath, (String)propertyState.getName());
        }
    }

    public static class NodeIncludeResult {
        final NodeState nodeState;
        final String nodePath;
        final String rootIncludePath;

        public NodeIncludeResult(String nodePath, NodeState nodeState) {
            this(nodePath, null, nodeState);
        }

        public NodeIncludeResult(String nodePath, String rootIncludePath, NodeState nodeState) {
            this.nodePath = nodePath;
            this.nodeState = nodeState;
            this.rootIncludePath = rootIncludePath;
        }

        public boolean isRelativeNode() {
            return this.rootIncludePath != null;
        }

        public String toString() {
            return "NodeIncludeResult{nodePath='" + this.nodePath + '\'' + ", rootIncludePath='" + this.rootIncludePath + '\'' + '}';
        }
    }

    public static interface ResultCollector {
        public void onResult(NodeIncludeResult var1);

        public void onResult(PropertyIncludeResult var1);
    }

    public static class PropertyInclude
    extends Include<PropertyInclude> {
        private final PropertyDefinition propertyDefinition;
        private final String propertyName;
        private final Pattern pattern;
        private final String parentPath;

        public PropertyInclude(PropertyDefinition pd) {
            super(PathUtils.getParentPath((String)pd.name));
            this.propertyDefinition = pd;
            this.propertyName = PathUtils.getName((String)pd.name);
            this.parentPath = PathUtils.getParentPath((String)pd.name);
            this.pattern = pd.isRegexp ? Pattern.compile(this.propertyName) : null;
        }

        @Override
        public void collectResults(String nodePath, NodeState nodeState, ResultCollector results) {
            if (this.pattern != null) {
                for (PropertyState ps : nodeState.getProperties()) {
                    if (!this.pattern.matcher(ps.getName()).matches()) continue;
                    results.onResult(new PropertyIncludeResult(ps, this.propertyDefinition, this.parentPath));
                }
            } else {
                PropertyState ps = nodeState.getProperty(this.propertyName);
                if (ps != null) {
                    results.onResult(new PropertyIncludeResult(ps, this.propertyDefinition, this.parentPath));
                }
            }
        }

        @Override
        public boolean aggregatesProperty(String name) {
            if (this.pattern != null) {
                return this.pattern.matcher(name).matches();
            }
            return this.propertyName.equals(name);
        }

        public String toString() {
            return this.propertyDefinition.toString();
        }
    }

    public static class NodeInclude
    extends Include<NodeInclude> {
        final String primaryType;
        final boolean relativeNode;
        private final String pattern;
        private final AggregateMapper aggMapper;

        public NodeInclude(AggregateMapper mapper, String pattern) {
            this(mapper, null, pattern, false);
        }

        public NodeInclude(AggregateMapper mapper, String primaryType, String pattern, boolean relativeNode) {
            super(pattern);
            this.pattern = pattern;
            this.primaryType = primaryType;
            this.aggMapper = mapper;
            this.relativeNode = relativeNode;
        }

        @Override
        public boolean match(String name, NodeState nodeState, int depth) {
            if (depth == this.maxDepth() - 1 && this.primaryType != null && !Aggregate.matchingType(this.primaryType, nodeState)) {
                return false;
            }
            return super.match(name, nodeState, depth);
        }

        @Override
        public void collectResults(NodeInclude rootInclude, String rootIncludePath, String nodePath, NodeState nodeState, ResultCollector results) {
            if (rootInclude.relativeNode) {
                results.onResult(new NodeIncludeResult(nodePath, rootIncludePath, nodeState));
            }
            results.onResult(new NodeIncludeResult(nodePath, nodeState));
        }

        @Override
        public boolean aggregatesProperty(String name) {
            return true;
        }

        @Override
        public Aggregate getAggregate(NodeState matchedNodeState) {
            Aggregate agg;
            block1: {
                String mixin;
                agg = this.aggMapper.getAggregate(ConfigUtil.getPrimaryTypeName(matchedNodeState));
                if (agg != null) break block1;
                Iterator<String> i$ = ConfigUtil.getMixinNames(matchedNodeState).iterator();
                while (i$.hasNext() && (agg = this.aggMapper.getAggregate(mixin = i$.next())) == null) {
                }
            }
            return agg;
        }

        public String toString() {
            return "NodeInclude{primaryType='" + this.primaryType + '\'' + ", relativeNode=" + this.relativeNode + ", pattern='" + this.pattern + '\'' + '}';
        }

        public boolean matches(String nodePath) {
            ImmutableList pathElements = ImmutableList.copyOf((Iterable)PathUtils.elements((String)nodePath));
            if (pathElements.size() != this.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                String element = this.elements[i];
                if (Aggregate.MATCH_ALL.equals(element) || element.equals(pathElements.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class Include<T> {
        protected final String[] elements;

        public Include(String pattern) {
            this.elements = Aggregate.computeElements(pattern);
        }

        public boolean match(String name, NodeState nodeState, int depth) {
            String element = this.elements[depth];
            if (Aggregate.MATCH_ALL.equals(element)) {
                return true;
            }
            return element.equals(name);
        }

        public int maxDepth() {
            return this.elements.length;
        }

        public void collectResults(T rootInclude, String rootIncludePath, String nodePath, NodeState nodeState, ResultCollector results) {
            this.collectResults(nodePath, nodeState, results);
        }

        public void collectResults(String nodePath, NodeState nodeState, ResultCollector results) {
        }

        public abstract boolean aggregatesProperty(String var1);

        @CheckForNull
        public Aggregate getAggregate(NodeState matchedNodeState) {
            return null;
        }
    }

    public static interface AggregateMapper {
        @CheckForNull
        public Aggregate getAggregate(String var1);
    }
}

