/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.Weigher;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;

public class CacheStats
implements CacheStatsMBean {
    private final Cache<Object, Object> cache;
    private final Weigher<Object, Object> weigher;
    private final long maxWeight;
    private final String name;
    private com.google.common.cache.CacheStats lastSnapshot = new com.google.common.cache.CacheStats(0L, 0L, 0L, 0L, 0L, 0L);

    public CacheStats(Cache<?, ?> cache, String name, Weigher<?, ?> weigher, long maxWeight) {
        this.cache = cache;
        this.name = name;
        this.weigher = weigher;
        this.maxWeight = maxWeight;
    }

    public long getRequestCount() {
        return this.stats().requestCount();
    }

    public long getHitCount() {
        return this.stats().hitCount();
    }

    public double getHitRate() {
        return this.stats().hitRate();
    }

    public long getMissCount() {
        return this.stats().missCount();
    }

    public double getMissRate() {
        return this.stats().missRate();
    }

    public long getLoadCount() {
        return this.stats().loadCount();
    }

    public long getLoadSuccessCount() {
        return this.stats().loadSuccessCount();
    }

    public long getLoadExceptionCount() {
        return this.stats().loadExceptionCount();
    }

    public double getLoadExceptionRate() {
        return this.stats().loadExceptionRate();
    }

    public long getTotalLoadTime() {
        return this.stats().totalLoadTime();
    }

    public double getAverageLoadPenalty() {
        return this.stats().averageLoadPenalty();
    }

    public long getEvictionCount() {
        return this.stats().evictionCount();
    }

    public long getElementCount() {
        return this.cache.size();
    }

    public long estimateCurrentWeight() {
        if (this.weigher == null) {
            return -1L;
        }
        long size = 0L;
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            size += (long)this.weigher.weigh(k, v);
        }
        return size;
    }

    public long getMaxTotalWeight() {
        return this.maxWeight;
    }

    public synchronized void resetStats() {
        this.lastSnapshot = this.cache.stats();
    }

    public String cacheInfoAsString() {
        return Objects.toStringHelper((String)"CacheStats").add("hitCount", this.getHitCount()).add("hitRate", (Object)String.format("%1.2f", this.getHitRate())).add("missCount", this.getMissCount()).add("missRate", (Object)String.format("%1.2f", this.getMissRate())).add("requestCount", this.getRequestCount()).add("loadCount", this.getLoadCount()).add("loadSuccessCount", this.getLoadSuccessCount()).add("loadExceptionCount", this.getLoadExceptionCount()).add("totalLoadTime", (Object)CacheStats.timeInWords(this.getTotalLoadTime())).add("averageLoadPenalty (nanos)", (Object)String.format("%1.2f", this.getAverageLoadPenalty())).add("evictionCount", this.getEvictionCount()).add("elementCount", this.getElementCount()).add("totalWeight", (Object)IOUtils.humanReadableByteCount((long)this.estimateCurrentWeight())).add("maxWeight", (Object)IOUtils.humanReadableByteCount((long)this.getMaxTotalWeight())).toString();
    }

    public String getName() {
        return this.name;
    }

    private com.google.common.cache.CacheStats stats() {
        return this.cache.stats().minus(this.lastSnapshot);
    }

    static String timeInWords(long nanos) {
        long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }
}

