/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBeanImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.lucene.analysis.Analyzer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LuceneIndexProviderService {
    private LuceneIndexProvider indexProvider;
    private final List<ServiceRegistration> regs = Lists.newArrayList();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Analyzer defaultAnalyzer = LuceneIndexConstants.ANALYZER;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private NodeAggregator nodeAggregator;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    protected Analyzer analyzer;
    private Registration mbeanReg;

    @Activate
    private void activate(BundleContext bundleContext, Map<String, ?> config) throws NotCompliantMBeanException {
        this.indexProvider = new LuceneIndexProvider();
        this.initialize();
        QueryIndexProvider aggregate = AggregateIndexProvider.wrap((QueryIndexProvider)this.indexProvider);
        this.regs.add(bundleContext.registerService(QueryIndexProvider.class.getName(), (Object)aggregate, null));
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)this.indexProvider, null));
        this.mbeanReg = WhiteboardUtils.registerMBean((Whiteboard)new OsgiWhiteboard(bundleContext), LuceneIndexMBean.class, (Object)new LuceneIndexMBeanImpl(this.indexProvider.getTracker()), (String)"LuceneIndex", (String)"Lucene Index statistics");
    }

    @Deactivate
    private void deactivate() {
        for (ServiceRegistration reg : this.regs) {
            reg.unregister();
        }
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
        }
        if (this.indexProvider != null) {
            this.indexProvider.close();
            this.indexProvider = null;
        }
    }

    private void initialize() {
        if (this.indexProvider == null) {
            return;
        }
        if (this.nodeAggregator != null) {
            this.log.debug("Using NodeAggregator {}", this.nodeAggregator.getClass());
        }
        this.indexProvider.setAggregator(this.nodeAggregator);
        Analyzer analyzer = this.analyzer != null ? this.analyzer : this.defaultAnalyzer;
        this.indexProvider.setAnalyzer(analyzer);
    }

    protected void bindNodeAggregator(NodeAggregator aggregator) {
        this.nodeAggregator = aggregator;
        this.initialize();
    }

    protected void unbindNodeAggregator(NodeAggregator aggregator) {
        this.nodeAggregator = null;
        this.initialize();
    }

    protected void bindAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.initialize();
    }

    protected void unbindAnalyzer(Analyzer analyzer) {
        this.analyzer = null;
        this.initialize();
    }
}

