/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexMBeanImpl
extends AnnotatedStandardMBean
implements LuceneIndexMBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IndexTracker indexTracker;

    public LuceneIndexMBeanImpl(IndexTracker indexTracker) throws NotCompliantMBeanException {
        super(LuceneIndexMBean.class);
        this.indexTracker = indexTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TabularData getIndexStats() throws IOException {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(LuceneIndexMBeanImpl.class.getName(), "Lucene Index Stats", IndexStats.TYPE, new String[]{"path"});
            tds = new TabularDataSupport(tt);
            Set<String> indexes = this.indexTracker.getIndexNodePaths();
            for (String path : indexes) {
                IndexNode indexNode = null;
                try {
                    indexNode = this.indexTracker.acquireIndexNode(path);
                    if (indexNode == null) continue;
                    IndexStats stats = new IndexStats(path, indexNode.getSearcher().getIndexReader());
                    tds.put(stats.toCompositeData());
                }
                finally {
                    if (indexNode == null) continue;
                    indexNode.release();
                }
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpIndexContent(String sourcePath, String destPath) throws IOException {
        IndexNode indexNode = null;
        try {
            if (sourcePath == null) {
                sourcePath = "/";
            }
            if ((indexNode = this.indexTracker.acquireIndexNode(sourcePath)) != null) {
                this.log.info("Dumping Lucene directory content for [{}] to [{}]", (Object)sourcePath, (Object)destPath);
                Directory source = LuceneIndexMBeanImpl.getDirectory(indexNode.getSearcher().getIndexReader());
                Preconditions.checkNotNull((Object)source, (Object)"IndexSearcher not backed by DirectoryReader");
                FSDirectory dest = FSDirectory.open(new File(destPath));
                for (String file : source.listAll()) {
                    source.copy(dest, file, file, IOContext.DEFAULT);
                }
            }
        }
        finally {
            if (indexNode != null) {
                indexNode.release();
            }
        }
    }

    private static Directory getDirectory(IndexReader reader) {
        if (reader instanceof DirectoryReader) {
            return ((DirectoryReader)reader).directory();
        }
        return null;
    }

    private static long dirSize(Directory directory) throws IOException {
        long totalFileSize = 0L;
        String[] files = directory.listAll();
        if (files == null) {
            return totalFileSize;
        }
        for (String file : files) {
            totalFileSize += directory.fileLength(file);
        }
        return totalFileSize;
    }

    private static class IndexStats {
        static final String[] FIELD_NAMES = new String[]{"path", "indexSizeStr", "indexSize", "numDocs", "maxDoc", "numDeletedDocs"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"Path", "Index size in human readable format", "Index size in bytes", "Number of documents in this index.", "The time and date for when the longest query took place", "Number of deleted documents"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
        static final CompositeType TYPE = IndexStats.createCompositeType();
        private final String path;
        private final long indexSize;
        private final int numDocs;
        private final int maxDoc;
        private final int numDeletedDocs;
        private final String indexSizeStr;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(IndexStats.class.getName(), "Composite data type for Lucene Index statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public IndexStats(String path, IndexReader indexReader) throws IOException {
            this.path = path;
            this.numDocs = indexReader.numDocs();
            this.maxDoc = indexReader.maxDoc();
            this.numDeletedDocs = indexReader.numDeletedDocs();
            this.indexSize = LuceneIndexMBeanImpl.dirSize(LuceneIndexMBeanImpl.getDirectory(indexReader));
            this.indexSizeStr = IOUtils.humanReadableByteCount((long)this.indexSize);
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.path, this.indexSizeStr, this.indexSize, this.numDocs, this.maxDoc, this.numDeletedDocs};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

