/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.WriteOutContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class LuceneIndexEditor
implements IndexEditor {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditor.class);
    private final LuceneIndexEditorContext context;
    private final String name;
    private final LuceneIndexEditor parent;
    private String path;
    private boolean propertiesChanged = false;

    LuceneIndexEditor(NodeBuilder definition, Analyzer analyzer, IndexUpdateCallback updateCallback) throws CommitFailedException {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.context = new LuceneIndexEditorContext(definition, analyzer, updateCallback);
    }

    private LuceneIndexEditor(LuceneIndexEditor parent, String name) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.context = parent.context;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat((String)this.parent.getPath(), (String)this.name);
        }
        return this.path;
    }

    public void enter(NodeState before, NodeState after) throws CommitFailedException {
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        long indexed;
        String path;
        if ((this.propertiesChanged || !before.exists()) && this.addOrUpdate(path = this.getPath(), after, before.exists()) && (indexed = this.context.incIndexedNodes()) % 1000L == 0L) {
            log.debug("Indexed {} nodes...", (Object)indexed);
        }
        if (this.parent == null) {
            try {
                this.context.closeWriter();
            }
            catch (IOException e) {
                throw new CommitFailedException("Lucene", 4, "Failed to close the Lucene index", (Throwable)e);
            }
            if (this.context.getIndexedNodes() > 0L) {
                log.debug("Indexed {} nodes, done.", (Object)this.context.getIndexedNodes());
            }
        }
    }

    public void propertyAdded(PropertyState after) {
        this.propertiesChanged = true;
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
        this.propertiesChanged = true;
    }

    public void propertyDeleted(PropertyState before) {
        this.propertiesChanged = true;
    }

    public Editor childNodeAdded(String name, NodeState after) {
        return new LuceneIndexEditor(this, name);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new LuceneIndexEditor(this, name);
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        String path = PathUtils.concat((String)this.getPath(), (String)name);
        try {
            IndexWriter writer = this.context.getWriter();
            writer.deleteDocuments(TermFactory.newPathTerm(path));
            writer.deleteDocuments((Query)new PrefixQuery(TermFactory.newPathTerm(path + "/")));
            this.context.indexUpdate();
        }
        catch (IOException e) {
            throw new CommitFailedException("Lucene", 5, "Failed to remove the index entries of the removed subtree " + path, (Throwable)e);
        }
        return null;
    }

    private boolean addOrUpdate(String path, NodeState state, boolean isUpdate) throws CommitFailedException {
        try {
            Document d = this.makeDocument(path, state, isUpdate);
            if (d != null) {
                this.context.getWriter().updateDocument(TermFactory.newPathTerm(path), d);
                return true;
            }
        }
        catch (IOException e) {
            throw new CommitFailedException("Lucene", 3, "Failed to index the node " + path, (Throwable)e);
        }
        return false;
    }

    private Document makeDocument(String path, NodeState state, boolean isUpdate) throws CommitFailedException {
        ArrayList<Field> fields = new ArrayList<Field>();
        boolean dirty = false;
        for (PropertyState property : state.getProperties()) {
            String pname = property.getName();
            if (!LuceneIndexEditor.isVisible(pname) || (this.context.getPropertyTypes() & 1 << property.getType().tag()) == 0 || !this.context.includeProperty(pname)) continue;
            if (Type.BINARY.tag() == property.getType().tag()) {
                this.context.indexUpdate();
                fields.addAll(this.newBinary(property, state));
                dirty = true;
                continue;
            }
            for (String value : (Iterable)property.getValue(Type.STRINGS)) {
                this.context.indexUpdate();
                fields.add(FieldFactory.newPropertyField(pname, value, !LuceneIndexHelper.skipTokenization(pname), this.context.isStored(pname)));
                fields.add(FieldFactory.newFulltextField(value));
                dirty = true;
            }
        }
        if (isUpdate && !dirty) {
            return null;
        }
        Document document = new Document();
        document.add(FieldFactory.newPathField(path));
        String name = PathUtils.getName((String)path);
        if (name != null) {
            document.add(FieldFactory.newFulltextField(name));
        }
        for (Field f : fields) {
            document.add(f);
        }
        return document;
    }

    private static boolean isVisible(String name) {
        return name.charAt(0) != ':';
    }

    private List<Field> newBinary(PropertyState property, NodeState state) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Metadata metadata = new Metadata();
        if ("jcr:data".equals(property.getName())) {
            String encoding;
            String type = state.getString("jcr:mimeType");
            if (type != null) {
                metadata.set("Content-Type", type);
            }
            if ((encoding = state.getString("jcr:encoding")) != null) {
                metadata.set("Content-Encoding", encoding);
            }
        }
        for (Blob v : (Iterable)property.getValue(Type.BINARIES)) {
            fields.add(FieldFactory.newFulltextField(this.parseStringValue(v, metadata)));
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseStringValue(Blob v, Metadata metadata) {
        WriteOutContentHandler handler;
        block6: {
            handler = new WriteOutContentHandler();
            try {
                InputStream stream = v.getNewStream();
                try {
                    this.context.getParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
                }
                finally {
                    stream.close();
                }
            }
            catch (LinkageError e) {
            }
            catch (Throwable t) {
                if (handler.isWriteLimitReached(t)) break block6;
                log.debug("Failed to extract text from a binary property. This is a fairly common case, and nothing to worry about. The stack trace is included to help improve the text extraction feature.", t);
                return "TextExtractionError";
            }
        }
        return handler.toString();
    }
}

