/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexTracker {
    private static final Logger log = LoggerFactory.getLogger(IndexTracker.class);
    private NodeState root = EmptyNodeState.EMPTY_NODE;
    private volatile Map<String, IndexNode> indices = Collections.emptyMap();

    IndexTracker() {
    }

    synchronized void close() {
        Map<String, IndexNode> indices = this.indices;
        this.indices = Collections.emptyMap();
        for (Map.Entry<String, IndexNode> entry : indices.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Failed to close the Lucene index at " + entry.getKey(), (Throwable)e);
            }
        }
    }

    synchronized void update(NodeState root) {
        Map<String, IndexNode> original = this.indices;
        final HashMap updates = Maps.newHashMap();
        ArrayList editors = Lists.newArrayListWithCapacity((int)original.size());
        for (Map.Entry<String, IndexNode> entry : original.entrySet()) {
            final String path = entry.getKey();
            final String name = entry.getValue().getName();
            ArrayList elements = Lists.newArrayList();
            Iterables.addAll((Collection)elements, (Iterable)PathUtils.elements((String)path));
            elements.add("oak:index");
            elements.add(name);
            editors.add(new SubtreeEditor((Editor)new DefaultEditor(){

                public void leave(NodeState before, NodeState after) {
                    try {
                        IndexNode index = IndexNode.open(name, after);
                        updates.put(path, index);
                    }
                    catch (IOException e) {
                        log.error("Failed to open Lucene index at " + path, (Throwable)e);
                    }
                }
            }, elements.toArray(new String[elements.size()])));
        }
        EditorDiff.process((Editor)CompositeEditor.compose((Collection)editors), (NodeState)this.root, (NodeState)root);
        this.root = root;
        if (!updates.isEmpty()) {
            this.indices = ImmutableMap.builder().putAll(Maps.filterKeys(original, (Predicate)Predicates.not((Predicate)Predicates.in(updates.keySet())))).putAll(Maps.filterValues((Map)updates, (Predicate)Predicates.notNull())).build();
            for (String path : updates.keySet()) {
                IndexNode index = original.get(path);
                try {
                    index.close();
                }
                catch (IOException e) {
                    log.error("Failed to close Lucene index at " + path, (Throwable)e);
                }
            }
        }
    }

    IndexNode acquireIndexNode(String path) {
        IndexNode index = this.indices.get(path);
        if (index != null && index.acquire()) {
            return index;
        }
        return this.findIndexNode(path);
    }

    Set<String> getIndexNodePaths() {
        return this.indices.keySet();
    }

    private synchronized IndexNode findIndexNode(String path) {
        IndexNode index = this.indices.get(path);
        if (index != null) {
            Preconditions.checkState((boolean)index.acquire());
            return index;
        }
        NodeState node = this.root;
        for (String name : PathUtils.elements((String)path)) {
            node = this.root.getChildNode(name);
        }
        node = node.getChildNode("oak:index");
        try {
            for (ChildNodeEntry child : node.getChildNodeEntries()) {
                node = child.getNodeState();
                if (!"lucene".equals(node.getString("type")) || (index = IndexNode.open(child.getName(), node)) == null) continue;
                Preconditions.checkState((boolean)index.acquire());
                this.indices = ImmutableMap.builder().putAll(this.indices).put((Object)path, (Object)index).build();
                return index;
            }
        }
        catch (IOException e) {
            log.error("Could not access the Lucene index at " + path, (Throwable)e);
        }
        return null;
    }
}

