/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;

public final class FieldFactory {
    private static final FieldType OAK_TYPE = new FieldType();
    private static final FieldType OAK_TYPE_NOT_STORED = new FieldType();

    private FieldFactory() {
    }

    public static Field newPathField(String path) {
        return new StringField(":path", path, Field.Store.YES);
    }

    public static Field newPropertyField(String name, String value, boolean tokenized, boolean stored) {
        if (tokenized) {
            return new OakTextField(name, value, stored);
        }
        return new StringField(name, value, Field.Store.NO);
    }

    public static Field newFulltextField(String value) {
        return new TextField(":fulltext", value, Field.Store.NO);
    }

    static {
        OAK_TYPE.setIndexed(true);
        OAK_TYPE.setOmitNorms(true);
        OAK_TYPE.setStored(true);
        OAK_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        OAK_TYPE.setTokenized(true);
        OAK_TYPE.freeze();
        OAK_TYPE_NOT_STORED.setIndexed(true);
        OAK_TYPE_NOT_STORED.setOmitNorms(true);
        OAK_TYPE_NOT_STORED.setStored(false);
        OAK_TYPE_NOT_STORED.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        OAK_TYPE_NOT_STORED.setTokenized(true);
        OAK_TYPE_NOT_STORED.freeze();
    }

    private static final class OakTextField
    extends Field {
        public OakTextField(String name, String value, boolean stored) {
            super(name, value, stored ? OAK_TYPE : OAK_TYPE_NOT_STORED);
        }
    }
}

