/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.commons.xml.ParsingContentHandler;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.WorkspaceDelegate;
import org.apache.jackrabbit.oak.jcr.lock.LockManagerImpl;
import org.apache.jackrabbit.oak.jcr.query.QueryManagerImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.SessionImpl;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.version.VersionManagerImpl;
import org.apache.jackrabbit.oak.jcr.xml.ImportHandler;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.name.ReadWriteNamespaceRegistry;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WorkspaceImpl
implements JackrabbitWorkspace {
    private final SessionContext sessionContext;
    private final SessionDelegate sessionDelegate;
    private final WorkspaceDelegate workspaceDelegate;
    private final QueryManagerImpl queryManager;
    private final VersionManagerImpl versionManager;
    private final ReadWriteNodeTypeManager nodeTypeManager;

    public WorkspaceImpl(final SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.sessionDelegate = sessionContext.getSessionDelegate();
        this.workspaceDelegate = new WorkspaceDelegate(sessionContext);
        this.queryManager = new QueryManagerImpl(sessionContext);
        this.versionManager = new VersionManagerImpl(sessionContext);
        this.nodeTypeManager = new ReadWriteNodeTypeManager(){

            protected void refresh() throws RepositoryException {
                WorkspaceImpl.this.getSession().refresh(true);
            }

            protected Tree getTypes() {
                return WorkspaceImpl.this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
            }

            @Nonnull
            protected Root getWriteRoot() {
                return WorkspaceImpl.this.sessionDelegate.getContentSession().getLatestRoot();
            }

            @Nonnull
            protected ValueFactory getValueFactory() {
                return sessionContext.getValueFactory();
            }

            @Nonnull
            protected NamePathMapper getNamePathMapper() {
                return sessionContext;
            }
        };
    }

    @Nonnull
    public Session getSession() {
        return this.sessionContext.getSession();
    }

    public String getName() {
        return this.sessionDelegate.getWorkspaceName();
    }

    public void copy(String srcAbsPath, String destAbsPath) throws RepositoryException {
        this.copy(this.getName(), srcAbsPath, destAbsPath);
    }

    private String getOakPathOrThrowNotFound(String srcAbsPath) throws PathNotFoundException {
        return this.sessionContext.getOakPathOrThrowNotFound(srcAbsPath);
    }

    public void copy(String srcWorkspace, String srcAbsPath, final String destAbsPath) throws RepositoryException {
        final String srcOakPath = this.getOakPathOrThrowNotFound(srcAbsPath);
        final String destOakPath = this.getOakPathOrThrowNotFound(destAbsPath);
        if (!this.getName().equals(srcWorkspace)) {
            throw new UnsupportedRepositoryOperationException("Not implemented.");
        }
        this.sessionDelegate.performVoid(new SessionOperation<Void>("copy", true){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                WorkspaceImpl.this.ensureIsAlive();
            }

            @Override
            public void performVoid() throws RepositoryException {
                WorkspaceImpl.this.sessionDelegate.checkProtectedNode(PathUtils.getParentPath((String)destOakPath));
                SessionImpl.checkIndexOnName(destAbsPath);
                WorkspaceImpl.this.workspaceDelegate.copy(srcOakPath, destOakPath);
            }
        });
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws RepositoryException {
        final String srcOakPath = this.getOakPathOrThrowNotFound(srcAbsPath);
        final String destOakPath = this.getOakPathOrThrowNotFound(destAbsPath);
        this.sessionDelegate.performVoid(new SessionOperation<Void>("clone", true){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                WorkspaceImpl.this.ensureIsAlive();
            }

            @Override
            public void performVoid() throws RepositoryException {
                WorkspaceImpl.this.sessionDelegate.checkProtectedNode(PathUtils.getParentPath((String)srcOakPath));
                WorkspaceImpl.this.sessionDelegate.checkProtectedNode(PathUtils.getParentPath((String)destOakPath));
                throw new UnsupportedRepositoryOperationException("Not implemented.");
            }
        });
    }

    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        String srcOakPath = this.getOakPathOrThrowNotFound(srcAbsPath);
        String destOakPath = this.getOakPathOrThrowNotFound(destAbsPath);
        this.ensureIsAlive();
        this.sessionDelegate.checkProtectedNode(PathUtils.getParentPath((String)srcOakPath));
        this.sessionDelegate.checkProtectedNode(PathUtils.getParentPath((String)destOakPath));
        SessionImpl.checkIndexOnName(destAbsPath);
        this.sessionDelegate.move(srcOakPath, destOakPath, false);
    }

    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        this.getVersionManager().restore(versions, removeExisting);
    }

    public LockManagerImpl getLockManager() {
        return new LockManagerImpl(this.sessionContext);
    }

    public QueryManager getQueryManager() throws RepositoryException {
        this.ensureIsAlive();
        return this.queryManager;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return new ReadWriteNamespaceRegistry(this.sessionDelegate.getRoot()){

            protected Root getWriteRoot() {
                return WorkspaceImpl.this.sessionDelegate.getContentSession().getLatestRoot();
            }

            protected void refresh() throws RepositoryException {
                WorkspaceImpl.this.getSession().refresh(true);
            }
        };
    }

    public ReadWriteNodeTypeManager getNodeTypeManager() {
        return this.nodeTypeManager;
    }

    public ObservationManager getObservationManager() throws RepositoryException {
        this.ensureIsAlive();
        return this.sessionContext.getObservationManager();
    }

    public VersionManager getVersionManager() throws RepositoryException {
        this.ensureIsAlive();
        return this.versionManager;
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.ensureIsAlive();
        return new String[]{this.getName()};
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws RepositoryException {
        this.ensureIsAlive();
        return new ImportHandler(parentAbsPath, this.sessionContext, uuidBehavior, true);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, RepositoryException {
        this.ensureIsAlive();
        try {
            ContentHandler handler = this.getImportContentHandler(parentAbsPath, uuidBehavior);
            new ParsingContentHandler(handler).parse(in);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CommitFailedException) {
                throw ((CommitFailedException)((Object)exception)).asRepositoryException();
            }
            throw new InvalidSerializedDataException("XML parse error", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void createWorkspace(String name) throws RepositoryException {
        this.ensureIsAlive();
        throw new UnsupportedRepositoryOperationException("OAK-118: Workspace.createWorkspace");
    }

    public void createWorkspace(String name, String srcWorkspace) throws RepositoryException {
        this.ensureIsAlive();
        throw new UnsupportedRepositoryOperationException("OAK-118: Workspace.createWorkspace");
    }

    public void deleteWorkspace(String name) throws RepositoryException {
        this.ensureIsAlive();
        throw new UnsupportedRepositoryOperationException("OAK-118: Workspace.deleteWorkspace");
    }

    public void createWorkspace(String workspaceName, InputSource workspaceTemplate) throws RepositoryException {
        this.ensureIsAlive();
        throw new UnsupportedRepositoryOperationException("OAK-118: Workspace.createWorkspace");
    }

    public PrivilegeManager getPrivilegeManager() throws RepositoryException {
        return this.sessionContext.getPrivilegeManager();
    }

    private void ensureIsAlive() throws RepositoryException {
        if (!this.sessionDelegate.isAlive()) {
            throw new RepositoryException("This session has been closed.");
        }
    }
}

