/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.jcr.observation.EventFactory;
import org.apache.jackrabbit.oak.jcr.observation.EventQueue;
import org.apache.jackrabbit.oak.namepath.PathTracker;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierTracker;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.observation.DefaultEventHandler;
import org.apache.jackrabbit.oak.plugins.observation.EventHandler;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventAggregator;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class QueueingHandler
extends DefaultEventHandler {
    private final QueueingHandler parent;
    private final EventQueue queue;
    private final EventFactory factory;
    private final PathTracker pathTracker;
    private final String parentType;
    private final Iterable<String> parentMixins;
    private final IdentifierTracker beforeIdentifierTracker;
    private final IdentifierTracker identifierTracker;
    private final EventAggregator aggregator;
    private final String name;
    private final NodeState root;
    private final List<ChildNodeEntry> parents;

    QueueingHandler(EventQueue queue, EventFactory factory, EventAggregator aggregator, NodeState before, NodeState after) {
        this.parent = null;
        this.queue = queue;
        this.factory = factory;
        this.name = null;
        this.aggregator = aggregator;
        this.pathTracker = new PathTracker();
        this.beforeIdentifierTracker = new IdentifierTracker(before);
        this.parents = new LinkedList<ChildNodeEntry>();
        if (after.exists()) {
            this.identifierTracker = new IdentifierTracker(after);
            this.parentType = QueueingHandler.getPrimaryType(after);
            this.parentMixins = QueueingHandler.getMixinTypes(after);
            this.root = after;
        } else {
            this.identifierTracker = this.beforeIdentifierTracker;
            this.parentType = QueueingHandler.getPrimaryType(before);
            this.parentMixins = QueueingHandler.getMixinTypes(before);
            this.root = before;
        }
    }

    private QueueingHandler(QueueingHandler parent, String name, NodeState before, NodeState after) {
        this.parent = parent;
        this.queue = parent.queue;
        this.factory = parent.factory;
        this.root = parent.root;
        this.name = name;
        this.aggregator = parent.aggregator;
        this.pathTracker = parent.pathTracker.getChildTracker(name);
        this.beforeIdentifierTracker = parent.beforeIdentifierTracker.getChildTracker(name, before);
        this.parents = new LinkedList<ChildNodeEntry>(parent.parents);
        if (after.exists()) {
            this.identifierTracker = parent.identifierTracker.getChildTracker(name, after);
            this.parentType = QueueingHandler.getPrimaryType(after);
            this.parentMixins = QueueingHandler.getMixinTypes(after);
            this.parents.add((ChildNodeEntry)new MemoryChildNodeEntry(name, after));
        } else {
            this.identifierTracker = this.beforeIdentifierTracker;
            this.parentType = QueueingHandler.getPrimaryType(before);
            this.parentMixins = QueueingHandler.getMixinTypes(before);
            this.parents.add((ChildNodeEntry)new MemoryChildNodeEntry(name, before));
        }
    }

    public EventHandler getChildHandler(String name, NodeState before, NodeState after) {
        return new QueueingHandler(this, name, before, after);
    }

    private AggregationResult aggregate(PropertyState after) {
        int aggregationLevel = 0;
        if (this.aggregator != null) {
            aggregationLevel = this.aggregator.aggregate(this.root, this.parents, after);
        }
        if (aggregationLevel <= 0) {
            return new AggregationResult(after.getName(), this.identifierTracker, this.parentType, this.parentMixins, this.pathTracker);
        }
        QueueingHandler handler = this;
        String name = after.getName();
        for (int i = 0; i < aggregationLevel; ++i) {
            name = handler.name + "/" + name;
            handler = handler.parent;
        }
        return new AggregationResult(name, handler.identifierTracker, handler.parentType, handler.parentMixins, handler.pathTracker);
    }

    public void propertyAdded(PropertyState after) {
        AggregationResult aggregated = this.aggregate(after);
        this.queue.addEvent(this.factory.propertyAdded(after, aggregated.primaryType, aggregated.mixinTypes, aggregated.pathTracker.getPath(), aggregated.name, aggregated.identifierTracker.getIdentifier()));
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
        AggregationResult aggregated = this.aggregate(after);
        this.queue.addEvent(this.factory.propertyChanged(before, after, aggregated.primaryType, aggregated.mixinTypes, aggregated.pathTracker.getPath(), aggregated.name, aggregated.identifierTracker.getIdentifier()));
    }

    public void propertyDeleted(PropertyState before) {
        AggregationResult aggregated = this.aggregate(before);
        this.queue.addEvent(this.factory.propertyDeleted(before, aggregated.primaryType, aggregated.mixinTypes, aggregated.pathTracker.getPath(), aggregated.name, aggregated.identifierTracker.getIdentifier()));
    }

    private AggregationResult aggregate(String name, NodeState node, IdentifierTracker childTracker) {
        int aggregationLevel = 0;
        if (this.aggregator != null) {
            aggregationLevel = this.aggregator.aggregate(this.root, this.parents, (ChildNodeEntry)new MemoryChildNodeEntry(name, node));
        }
        if (aggregationLevel <= 0) {
            return new AggregationResult(name, childTracker, QueueingHandler.getPrimaryType(node), QueueingHandler.getMixinTypes(node), this.pathTracker);
        }
        QueueingHandler handler = this;
        IdentifierTracker tracker = childTracker;
        String primaryType = null;
        Iterable<String> mixinTypes = null;
        PathTracker pathTracker = null;
        String childName = null;
        for (int i = 0; i < aggregationLevel; ++i) {
            if (i > 0) {
                name = childName + "/" + name;
            }
            tracker = handler.identifierTracker;
            primaryType = handler.parentType;
            mixinTypes = handler.parentMixins;
            pathTracker = handler.pathTracker;
            childName = handler.name;
            handler = handler.parent;
        }
        return new AggregationResult(name, tracker, primaryType, mixinTypes, pathTracker);
    }

    public void nodeAdded(String name, NodeState after) {
        IdentifierTracker tracker = this.identifierTracker.getChildTracker(name, after);
        AggregationResult aggregated = this.aggregate(name, after, tracker);
        this.queue.addEvent(this.factory.nodeAdded(aggregated.primaryType, aggregated.mixinTypes, aggregated.pathTracker.getPath(), aggregated.name, aggregated.identifierTracker.getIdentifier()));
    }

    public void nodeDeleted(String name, NodeState before) {
        IdentifierTracker tracker = this.beforeIdentifierTracker.getChildTracker(name, before);
        AggregationResult aggregated = this.aggregate(name, before, tracker);
        this.queue.addEvent(this.factory.nodeDeleted(aggregated.primaryType, aggregated.mixinTypes, aggregated.pathTracker.getPath(), aggregated.name, aggregated.identifierTracker.getIdentifier()));
    }

    public void nodeMoved(String sourcePath, String name, NodeState moved) {
        IdentifierTracker tracker = this.identifierTracker.getChildTracker(name, moved);
        AggregationResult aggregated = this.aggregate(name, moved, tracker);
        this.queue.addEvent(this.factory.nodeMoved(aggregated.primaryType, aggregated.mixinTypes, aggregated.pathTracker.getPath(), aggregated.name, aggregated.identifierTracker.getIdentifier(), sourcePath));
    }

    public void nodeReordered(String destName, String name, NodeState reordered) {
        IdentifierTracker tracker = this.identifierTracker.getChildTracker(name, reordered);
        AggregationResult aggregated = this.aggregate(name, reordered, tracker);
        this.queue.addEvent(this.factory.nodeReordered(aggregated.primaryType, aggregated.mixinTypes, aggregated.pathTracker.getPath(), aggregated.name, aggregated.identifierTracker.getIdentifier(), destName));
    }

    private static String getPrimaryType(NodeState before) {
        PropertyState primaryType = before.getProperty("jcr:primaryType");
        if (primaryType != null && primaryType.getType() == Type.NAME) {
            return (String)primaryType.getValue(Type.NAME);
        }
        return null;
    }

    private static Iterable<String> getMixinTypes(NodeState before) {
        PropertyState mixinTypes = before.getProperty("jcr:mixinTypes");
        if (mixinTypes != null && mixinTypes.getType() == Type.NAMES) {
            return (Iterable)mixinTypes.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    class AggregationResult {
        private final String name;
        private final IdentifierTracker identifierTracker;
        private final String primaryType;
        private final Iterable<String> mixinTypes;
        private final PathTracker pathTracker;

        AggregationResult(String name, IdentifierTracker identifierTracker, String primaryType, Iterable<String> mixinTypes, PathTracker pathTracker) {
            this.name = name;
            this.identifierTracker = identifierTracker;
            this.primaryType = primaryType;
            this.mixinTypes = mixinTypes;
            this.pathTracker = pathTracker;
        }
    }
}

