/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.osgi;

import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Repository;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceStrategy;
import org.apache.felix.scr.annotations.References;
import org.apache.jackrabbit.oak.InitialContent;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.jcr.osgi.OsgiRepository;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.commit.JcrConflictHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.WhiteboardIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.plugins.version.VersionHook;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.WhiteboardEditorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.WhiteboardIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(policy=ConfigurationPolicy.REQUIRE)
@References(value={@Reference(referenceInterface=StatisticsProvider.class, strategy=ReferenceStrategy.LOOKUP)})
public class RepositoryManager {
    private static final int DEFAULT_OBSERVATION_QUEUE_LENGTH = 10000;
    private static final boolean DEFAULT_COMMIT_RATE_LIMIT = false;
    private static final boolean DEFAULT_FAST_QUERY_RESULT_SIZE = false;
    private final WhiteboardEditorProvider editorProvider = new WhiteboardEditorProvider();
    private final WhiteboardIndexEditorProvider indexEditorProvider = new WhiteboardIndexEditorProvider();
    private final WhiteboardIndexProvider indexProvider = new WhiteboardIndexProvider();
    private Tracker<RepositoryInitializer> initializers;
    private Whiteboard whiteboard;
    private ServiceRegistration registration;
    private int observationQueueLength;
    private CommitRateLimiter commitRateLimiter;
    private boolean fastQueryResultSize;
    @Reference
    private SecurityProvider securityProvider;
    @Reference
    private NodeStore store;
    @Reference(target="(type=property)")
    private IndexEditorProvider propertyIndex;
    @Reference(target="(type=reference)")
    private IndexEditorProvider referenceIndex;
    @Property(intValue={10000}, name="Observation queue length", description="Maximum number of pending revisions in a observation listener queue")
    private static final String OBSERVATION_QUEUE_LENGTH = "oak.observation.queue-length";
    @Property(boolValue={false}, name="Commit rate limiter", description="Limit the commit rate once the number of pending revisions in the observation queue exceed 90% of its capacity.")
    private static final String COMMIT_RATE_LIMIT = "oak.observation.limit-commit-rate";
    @Property(boolValue={false}, name="Fast query result size", description="Whether the query result size should return an estimation (or -1 if disabled) for large queries")
    private static final String FAST_QUERY_RESULT_SIZE = "oak.query.fastResultSize";
    private OsgiRepository repository;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, ?> config) throws Exception {
        this.observationQueueLength = PropertiesUtil.toInteger((Object)RepositoryManager.prop(config, bundleContext, OBSERVATION_QUEUE_LENGTH), (int)10000);
        this.commitRateLimiter = PropertiesUtil.toBoolean((Object)RepositoryManager.prop(config, bundleContext, COMMIT_RATE_LIMIT), (boolean)false) ? new CommitRateLimiter() : null;
        this.fastQueryResultSize = PropertiesUtil.toBoolean((Object)RepositoryManager.prop(config, bundleContext, FAST_QUERY_RESULT_SIZE), (boolean)false);
        this.whiteboard = new OsgiWhiteboard(bundleContext);
        this.initializers = this.whiteboard.track(RepositoryInitializer.class);
        this.editorProvider.start(this.whiteboard);
        this.indexEditorProvider.start(this.whiteboard);
        this.indexProvider.start(this.whiteboard);
        this.registration = this.registerRepository(bundleContext);
    }

    private static Object prop(Map<String, ?> config, BundleContext bundleContext, String name) {
        String value = bundleContext.getProperty(name);
        if (value != null) {
            return value;
        }
        return config.get(name);
    }

    @Deactivate
    public void deactivate() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.repository != null) {
            this.repository.shutdown();
            this.repository = null;
        }
        this.initializers.stop();
        this.indexProvider.stop();
        this.indexEditorProvider.stop();
        this.editorProvider.stop();
    }

    private ServiceRegistration registerRepository(BundleContext bundleContext) {
        Oak oak = new Oak(this.store).with((RepositoryInitializer)new InitialContent()).with((CommitHook)new VersionHook()).with((ThreeWayConflictHandler)JcrConflictHandler.createJcrConflictHandler()).with(this.whiteboard).with(this.securityProvider).with((EditorProvider)this.editorProvider).with((IndexEditorProvider)this.indexEditorProvider).with((QueryIndexProvider)this.indexProvider).withFailOnMissingIndexProvider().withAsyncIndexing();
        for (RepositoryInitializer initializer : this.initializers.getServices()) {
            oak.with(initializer);
        }
        if (this.commitRateLimiter != null) {
            oak.with((CommitHook)this.commitRateLimiter);
        }
        this.repository = new OsgiRepository(oak.createContentRepository(), this.whiteboard, this.securityProvider, this.observationQueueLength, this.commitRateLimiter, this.fastQueryResultSize);
        return bundleContext.registerService(Repository.class, (Object)this.repository, new Hashtable());
    }

    protected void bindSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    protected void unbindSecurityProvider(SecurityProvider securityProvider) {
        if (this.securityProvider == securityProvider) {
            this.securityProvider = null;
        }
    }

    protected void bindStore(NodeStore nodeStore) {
        this.store = nodeStore;
    }

    protected void unbindStore(NodeStore nodeStore) {
        if (this.store == nodeStore) {
            this.store = null;
        }
    }

    protected void bindPropertyIndex(IndexEditorProvider indexEditorProvider) {
        this.propertyIndex = indexEditorProvider;
    }

    protected void unbindPropertyIndex(IndexEditorProvider indexEditorProvider) {
        if (this.propertyIndex == indexEditorProvider) {
            this.propertyIndex = null;
        }
    }

    protected void bindReferenceIndex(IndexEditorProvider indexEditorProvider) {
        this.referenceIndex = indexEditorProvider;
    }

    protected void unbindReferenceIndex(IndexEditorProvider indexEditorProvider) {
        if (this.referenceIndex == indexEditorProvider) {
            this.referenceIndex = null;
        }
    }
}

