/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.query.QueryManagerImpl;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

public class QueryImpl
implements Query {
    private final SessionContext sessionContext;
    private final QueryManagerImpl manager;
    private final HashMap<String, Value> bindVariableMap = new HashMap();
    private final String language;
    private final String statement;
    private long limit = Long.MAX_VALUE;
    private long offset;
    private boolean parsed;
    private String storedQueryPath;

    QueryImpl(QueryManagerImpl manager, String statement, String language, SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.manager = manager;
        this.statement = statement;
        this.language = language;
    }

    void setStoredQueryPath(String storedQueryPath) {
        this.storedQueryPath = storedQueryPath;
    }

    public void bindValue(String varName, Value value) throws RepositoryException {
        this.parse();
        if (!this.bindVariableMap.containsKey(varName)) {
            throw new IllegalArgumentException("Variable name " + varName + " is not a valid variable in this query");
        }
        this.bindVariableMap.put(varName, value);
    }

    private void parse() throws InvalidQueryException, RepositoryException {
        if (this.parsed) {
            return;
        }
        List<String> names = this.sessionContext.getSessionDelegate().perform(new SessionOperation<List<String>>("parse"){

            @Override
            @Nonnull
            public List<String> perform() throws RepositoryException {
                return QueryImpl.this.manager.parse(QueryImpl.this.statement, QueryImpl.this.language);
            }
        });
        for (String n : names) {
            this.bindVariableMap.put(n, null);
        }
        this.parsed = true;
    }

    public QueryResult execute() throws RepositoryException {
        return this.sessionContext.getSessionDelegate().perform(new SessionOperation<QueryResult>("execute"){

            @Override
            @Nonnull
            public QueryResult perform() throws RepositoryException {
                return QueryImpl.this.manager.executeQuery(QueryImpl.this.statement, QueryImpl.this.language, QueryImpl.this.limit, QueryImpl.this.offset, QueryImpl.this.bindVariableMap);
            }
        });
    }

    public String[] getBindVariableNames() throws RepositoryException {
        this.parse();
        String[] names = new String[this.bindVariableMap.size()];
        this.bindVariableMap.keySet().toArray(names);
        return names;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getStoredQueryPath() throws RepositoryException {
        if (this.storedQueryPath == null) {
            throw new ItemNotFoundException("Not a stored query");
        }
        return this.storedQueryPath;
    }

    public void setLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit may not be negative, is: " + limit);
        }
        this.limit = limit;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset may not be negative, is: " + offset);
        }
        this.offset = offset;
    }

    public Node storeAsNode(String absPath) throws RepositoryException {
        this.manager.ensureIsAlive();
        String oakPath = this.sessionContext.getOakPathOrThrow(absPath);
        String parent = PathUtils.getParentPath((String)oakPath);
        NodeDelegate parentDelegate = this.sessionContext.getSessionDelegate().getNode(parent);
        if (parentDelegate == null) {
            throw new PathNotFoundException("The specified path does not exist: " + parent);
        }
        NodeImpl<NodeDelegate> parentNode = NodeImpl.createNode(parentDelegate, this.sessionContext);
        if (!parentNode.isCheckedOut()) {
            throw new VersionException("Cannot store query. Node at " + absPath + " is checked in.");
        }
        String nodeName = PathUtils.getName((String)oakPath);
        ValueFactory vf = this.sessionContext.getValueFactory();
        Node n = parentNode.addNode(nodeName, "nt:query");
        n.setProperty("jcr:statement", vf.createValue(this.statement));
        n.setProperty("jcr:language", vf.createValue(this.language));
        this.setStoredQueryPath(oakPath);
        return n;
    }
}

