/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.jcr.Repository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.jcr.repository.RepositoryImpl;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.commit.JcrConflictHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceIndexProvider;
import org.apache.jackrabbit.oak.plugins.itemsave.ItemSaveValidatorProvider;
import org.apache.jackrabbit.oak.plugins.name.NameValidatorProvider;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.InitialContent;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.plugins.version.VersionEditorProvider;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CompositeConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public class Jcr {
    public static final int DEFAULT_OBSERVATION_QUEUE_LENGTH = 1000;
    private final Oak oak;
    private final Set<RepositoryInitializer> repositoryInitializers = Sets.newLinkedHashSet();
    private final Set<QueryIndexProvider> queryIndexProviders = Sets.newLinkedHashSet();
    private final Set<CommitHook> commitHooks = Sets.newLinkedHashSet();
    private final Set<IndexEditorProvider> indexEditorProviders = Sets.newLinkedHashSet();
    private final Set<EditorProvider> editorProviders = Sets.newLinkedHashSet();
    private final Set<Editor> editors = Sets.newLinkedHashSet();
    private final Set<Observer> observers = Sets.newLinkedHashSet();
    private final CompositeConflictHandler conflictHandler = JcrConflictHandler.createJcrConflictHandler();
    private SecurityProvider securityProvider;
    private CommitRateLimiter commitRateLimiter;
    private ScheduledExecutorService scheduledExecutor;
    private Executor executor;
    private QueryEngineSettings queryEngineSettings;
    private String defaultWorkspaceName;
    private Whiteboard whiteboard;
    private int observationQueueLength = 1000;
    private boolean fastQueryResultSize;
    private ContentRepository contentRepository;
    private Repository repository;
    private Clusterable clusterable;

    public Jcr(Oak oak, boolean initialize) {
        this.oak = oak;
        if (initialize) {
            this.with((RepositoryInitializer)new InitialContent());
            this.with((CommitHook)new EditorHook((EditorProvider)new VersionEditorProvider()));
            this.with((SecurityProvider)new SecurityProviderImpl());
            this.with((EditorProvider)new ItemSaveValidatorProvider());
            this.with((EditorProvider)new NameValidatorProvider());
            this.with((EditorProvider)new NamespaceEditorProvider());
            this.with((EditorProvider)new TypeEditorProvider());
            this.with((EditorProvider)new ConflictValidatorProvider());
            this.with((IndexEditorProvider)new ReferenceEditorProvider());
            this.with((QueryIndexProvider)new ReferenceIndexProvider());
            this.with((IndexEditorProvider)new PropertyIndexEditorProvider());
            this.with((IndexEditorProvider)new NodeCounterEditorProvider());
            this.with((QueryIndexProvider)new PropertyIndexProvider());
            this.with((QueryIndexProvider)new NodeTypeIndexProvider());
            this.with((IndexEditorProvider)new OrderedPropertyIndexEditorProvider());
        }
    }

    public Jcr(Oak oak) {
        this(oak, true);
    }

    public Jcr() {
        this(new Oak());
    }

    public Jcr(NodeStore store) {
        this(new Oak(store));
    }

    @Nonnull
    public Jcr with(@Nonnull Clusterable c) {
        this.ensureRepositoryIsNotCreated();
        this.clusterable = (Clusterable)Preconditions.checkNotNull((Object)c);
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull RepositoryInitializer initializer) {
        this.ensureRepositoryIsNotCreated();
        this.repositoryInitializers.add((RepositoryInitializer)Preconditions.checkNotNull((Object)initializer));
        return this;
    }

    public Jcr withAtomicCounter() {
        this.ensureRepositoryIsNotCreated();
        this.oak.withAtomicCounter();
        return this;
    }

    private void ensureRepositoryIsNotCreated() {
        Preconditions.checkState((this.repository == null && this.contentRepository == null ? 1 : 0) != 0, (Object)"Repository was already created");
    }

    @Nonnull
    public final Jcr with(@Nonnull QueryIndexProvider provider) {
        this.ensureRepositoryIsNotCreated();
        this.queryIndexProviders.add((QueryIndexProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull IndexEditorProvider indexEditorProvider) {
        this.ensureRepositoryIsNotCreated();
        this.indexEditorProviders.add((IndexEditorProvider)Preconditions.checkNotNull((Object)indexEditorProvider));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull CommitHook hook) {
        this.ensureRepositoryIsNotCreated();
        this.commitHooks.add((CommitHook)Preconditions.checkNotNull((Object)hook));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull EditorProvider provider) {
        this.ensureRepositoryIsNotCreated();
        this.editorProviders.add((EditorProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull Editor editor) {
        this.ensureRepositoryIsNotCreated();
        this.editors.add((Editor)Preconditions.checkNotNull((Object)editor));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull SecurityProvider securityProvider) {
        this.ensureRepositoryIsNotCreated();
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull PartialConflictHandler conflictHandler) {
        this.ensureRepositoryIsNotCreated();
        this.conflictHandler.addHandler((PartialConflictHandler)Preconditions.checkNotNull((Object)conflictHandler));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull ScheduledExecutorService executor) {
        this.ensureRepositoryIsNotCreated();
        this.scheduledExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull Executor executor) {
        this.ensureRepositoryIsNotCreated();
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull Observer observer) {
        this.ensureRepositoryIsNotCreated();
        this.observers.add((Observer)Preconditions.checkNotNull((Object)observer));
        return this;
    }

    @Nonnull
    public Jcr withAsyncIndexing() {
        this.ensureRepositoryIsNotCreated();
        this.oak.withAsyncIndexing();
        return this;
    }

    @Nonnull
    public Jcr withObservationQueueLength(int observationQueueLength) {
        this.ensureRepositoryIsNotCreated();
        this.observationQueueLength = observationQueueLength;
        return this;
    }

    @Nonnull
    public Jcr with(@Nonnull CommitRateLimiter commitRateLimiter) {
        this.ensureRepositoryIsNotCreated();
        this.commitRateLimiter = (CommitRateLimiter)Preconditions.checkNotNull((Object)commitRateLimiter);
        return this;
    }

    @Nonnull
    public Jcr with(@Nonnull QueryEngineSettings qs) {
        this.ensureRepositoryIsNotCreated();
        this.queryEngineSettings = (QueryEngineSettings)Preconditions.checkNotNull((Object)qs);
        return this;
    }

    @Nonnull
    public Jcr withFastQueryResultSize(boolean fastQueryResultSize) {
        this.ensureRepositoryIsNotCreated();
        this.fastQueryResultSize = fastQueryResultSize;
        return this;
    }

    @Nonnull
    public Jcr with(@Nonnull String defaultWorkspaceName) {
        this.ensureRepositoryIsNotCreated();
        this.defaultWorkspaceName = (String)Preconditions.checkNotNull((Object)defaultWorkspaceName);
        return this;
    }

    @Nonnull
    public Jcr with(@Nonnull Whiteboard whiteboard) {
        this.ensureRepositoryIsNotCreated();
        this.whiteboard = (Whiteboard)Preconditions.checkNotNull((Object)whiteboard);
        return this;
    }

    private void setUpOak() {
        if (this.whiteboard != null) {
            this.oak.with(this.whiteboard);
        }
        for (RepositoryInitializer repositoryInitializer : this.repositoryInitializers) {
            this.oak.with(repositoryInitializer);
        }
        for (QueryIndexProvider queryIndexProvider : this.queryIndexProviders) {
            this.oak.with(queryIndexProvider);
        }
        for (CommitHook commitHook : this.commitHooks) {
            this.oak.with(commitHook);
        }
        this.oak.with((ConflictHandler)this.conflictHandler);
        for (IndexEditorProvider indexEditorProvider : this.indexEditorProviders) {
            this.oak.with(indexEditorProvider);
        }
        for (Editor editor : this.editors) {
            this.oak.with(editor);
        }
        for (EditorProvider editorProvider : this.editorProviders) {
            this.oak.with(editorProvider);
        }
        this.oak.with(this.securityProvider);
        if (this.scheduledExecutor != null) {
            this.oak.with(this.scheduledExecutor);
        }
        if (this.executor != null) {
            this.oak.with(this.executor);
        }
        for (Observer observer : this.observers) {
            this.oak.with(observer);
        }
        if (this.commitRateLimiter != null) {
            this.oak.with((CommitHook)this.commitRateLimiter);
        }
        if (this.queryEngineSettings != null) {
            this.oak.with(this.queryEngineSettings);
        }
        if (this.defaultWorkspaceName != null) {
            this.oak.with(this.defaultWorkspaceName);
        }
        if (this.clusterable != null) {
            this.oak.with(this.clusterable);
        }
    }

    @Nonnull
    public ContentRepository createContentRepository() {
        if (this.contentRepository == null) {
            this.setUpOak();
            this.contentRepository = this.oak.createContentRepository();
        }
        return this.contentRepository;
    }

    @Nonnull
    public Repository createRepository() {
        if (this.repository == null) {
            this.repository = new RepositoryImpl(this.createContentRepository(), this.oak.getWhiteboard(), this.securityProvider, this.observationQueueLength, this.commitRateLimiter, this.fastQueryResultSize);
        }
        return this.repository;
    }
}

