/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.jcr.delegate.AuthorizableDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.ImpersonationDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

final class UserDelegator
extends AuthorizableDelegator
implements User {
    private UserDelegator(SessionDelegate sessionDelegate, User userDelegate) {
        super(sessionDelegate, (Authorizable)userDelegate);
    }

    static User wrap(SessionDelegate sessionDelegate, User user) {
        if (user == null) {
            return null;
        }
        return new UserDelegator(sessionDelegate, user);
    }

    @Nonnull
    static User unwrap(@Nonnull User user) {
        if (user instanceof UserDelegator) {
            return ((UserDelegator)user).getDelegate();
        }
        return user;
    }

    private User getDelegate() {
        return (User)this.delegate;
    }

    public boolean isAdmin() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isAdmin"){

            @Override
            @Nonnull
            public Boolean perform() {
                return UserDelegator.this.getDelegate().isAdmin();
            }
        });
    }

    public boolean isSystemUser() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isSystemUser"){

            @Override
            @Nonnull
            public Boolean perform() {
                return UserDelegator.this.getDelegate().isSystemUser();
            }
        });
    }

    public Credentials getCredentials() {
        return this.sessionDelegate.safePerform(new SessionOperation<Credentials>("getCredentials"){

            @Override
            @Nonnull
            public Credentials perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().getCredentials();
            }
        });
    }

    public Impersonation getImpersonation() {
        return this.sessionDelegate.safePerform(new SessionOperation<Impersonation>("getImpersonation"){

            @Override
            @Nonnull
            public Impersonation perform() throws RepositoryException {
                Impersonation impersonation = UserDelegator.this.getDelegate().getImpersonation();
                return ImpersonationDelegator.wrap(UserDelegator.this.sessionDelegate, impersonation);
            }
        });
    }

    public void changePassword(final String password) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("changePassword"){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password);
            }
        });
    }

    public void changePassword(final String password, final String oldPassword) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("changePassword"){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password, oldPassword);
            }
        });
    }

    public void disable(final String reason) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("disable"){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().disable(reason);
            }
        });
    }

    public boolean isDisabled() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isDisabled"){

            @Override
            @Nonnull
            public Boolean perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().isDisabled();
            }
        });
    }

    public String getDisabledReason() throws RepositoryException {
        return this.sessionDelegate.performNullable(new SessionOperation<String>("getDisabledReason"){

            @Override
            public String performNullable() throws RepositoryException {
                return UserDelegator.this.getDelegate().getDisabledReason();
            }
        });
    }
}

